/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Database;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.panels.ConnectionPanelUI;
import oracle.jdeveloper.db.panels.DatabaseFinder;
import oracle.jdevimpl.db.resource.ConnBundle;

public class DatabaseConnectionPanel
extends DefaultTraversablePanel
implements ItemListener {
    public static final String CHOSEN_CONNECTION_NAME = "CHOSEN_DB_CONN_NAME";
    public static final String CHOSEN_CONNECTION = "CHOSEN_DB_CONN";
    private ConnectionPanelUI m_ui;
    private WizardCallbacks m_wizCallbacks;
    private DialogCallbacks m_dlgCallbacks;

    public String getConnectionName() {
        return this.getConnectionUI().getConnectionName();
    }

    public boolean setConnectionName(String string) {
        return this.getConnectionUI().setConnectionName(string);
    }

    protected ConnectionPanelUI createConnectionUI() {
        return new ConnectionPanelUI(true);
    }

    protected final ConnectionPanelUI getConnectionUI() {
        if (this.m_ui == null) {
            this.m_ui = this.createConnectionUI();
            this.m_ui.addComboListener(this);
            this.m_ui.setConnectionPrompt(this.getConnectionPrompt());
            this.setLayout(new BorderLayout());
            this.add(this.m_ui, "Center");
        }
        return this.m_ui;
    }

    public void setConnectionLabel(String string) {
        this.m_ui.setConnectionLabel(string);
    }

    protected String getConnectionPrompt() {
        return ConnBundle.get("MESSAGE_CONNECTION_PROMPT");
    }

    protected String getProviderKey() {
        return "oracle.javatools.db.DBObjectProvider";
    }

    public void onEntry(TraversableContext traversableContext) {
        ConnectionPanelUI connectionPanelUI = this.getConnectionUI();
        String string = this.getEntryConnection(traversableContext);
        if (connectionPanelUI.resetConnections() > 0 && string != null) {
            connectionPanelUI.setConnectionName(string);
        }
        WizardCallbacks wizardCallbacks = this.m_wizCallbacks = traversableContext == null ? null : traversableContext.getWizardCallbacks();
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardSetInitialFocus(connectionPanelUI.getDefaultFocusComponent());
        }
        this.m_dlgCallbacks = traversableContext == null ? null : traversableContext.getDialogCallbacks();
        this.checkWizardButtons();
    }

    protected String getEntryConnection(TraversableContext traversableContext) {
        return traversableContext == null ? null : (String)traversableContext.get(CHOSEN_CONNECTION_NAME);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        block2: {
            ConnectionPanelUI connectionPanelUI = this.getConnectionUI();
            boolean bl = this.validateOnExit(traversableContext);
            ConnectionInfo connectionInfo = connectionPanelUI.getConnectionInfo();
            try {
                this.commitConnectionInfo(connectionInfo, traversableContext);
                connectionPanelUI.saveSettings();
            }
            catch (TraversalException traversalException) {
                if (!bl) break block2;
                throw traversalException;
            }
        }
    }

    protected boolean validateOnExit(TraversableContext traversableContext) {
        return traversableContext == null || traversableContext.getDirection() != 2;
    }

    @Deprecated
    protected void commitConnectionName(String string, TraversableContext traversableContext) throws TraversalException {
        this.commitConnectionInfo(new ConnectionInfo(this.getConnectionUI().getStoreName(), string), traversableContext);
    }

    protected void commitConnectionInfo(ConnectionInfo connectionInfo, TraversableContext traversableContext) throws TraversalException {
        if (connectionInfo == null || !connectionInfo.isValid()) {
            throw new TraversalException(ConnBundle.get("CHOOSE_CONNECTION"));
        }
        if (traversableContext != null) {
            String string = connectionInfo.getConnectionName();
            traversableContext.put(CHOSEN_CONNECTION_NAME, (Object)string);
            String string2 = this.getProviderKey();
            if (ModelUtil.hasLength((String)string2) && this.validateOnExit(traversableContext)) {
                String string3 = connectionInfo.getQualifiedName();
                Database database = DatabaseFinder.findDatabase(string3);
                traversableContext.put(string2, (Object)database);
                if (database == null) {
                    throw new TraversalException(null);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.checkWizardButtons();
    }

    public void addItemListener(ItemListener itemListener) {
        this.getConnectionUI().addComboListener(itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.getConnectionUI().removeComboListener(itemListener);
    }

    public void checkWizardButtons() {
        boolean bl = this.canWizardNext();
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardEnableButtons(null, Boolean.valueOf(bl), null);
        }
        if (this.m_dlgCallbacks != null) {
            this.m_dlgCallbacks.enableOKButton(bl);
        }
    }

    protected boolean canWizardNext() {
        return this.getConnectionName() != null;
    }

    public void enableActiveComponents(boolean bl) {
        this.getConnectionUI().setEnabled(bl);
    }
}

