/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Callable;
import oracle.ide.Addin;
import oracle.ide.ProductInformation;
import oracle.ide.model.SingletonProvider;
import oracle.ideri.util.Product;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.adapter.DatabaseProviderClassLoaderFactory;
import oracle.jdevimpl.db.DefaultPasswordPrompter;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.extension.DatabaseConnectionHook;

public class DBConnAddin
implements Addin {
    public static final String EXTENSION_ID = "oracle.jdeveloper.db.connection";

    public void initialize() {
        ProductInformation productInformation = ProductInformation.getProductInformation();
        if (productInformation != null) {
            DatabaseProviderHelper.setProgramName((String)productInformation.getShortName());
        }
        for (final DatabaseConnectionHook.ConnectionType connectionType : DatabaseConnectionHook.getHook().getConnectionTypes()) {
            String string = connectionType.getSubtype();
            if (!ModelUtil.hasLength((String)string)) continue;
            DatabaseProvider.registerLazyConnectionCreator((String)string, (Callable)new Callable<ConnectionCreator>(){

                @Override
                public ConnectionCreator call() {
                    return connectionType.getConnectionCreator();
                }
            });
        }
        DatabaseProviderHelper.setPasswordPrompter((DatabaseProviderHelper.PasswordPrompter)new DatabaseProviderHelper.PasswordPrompter(){
            private DatabaseProviderHelper.PasswordPrompter m_delegate;

            private synchronized DatabaseProviderHelper.PasswordPrompter getDelegate() {
                if (this.m_delegate == null) {
                    if (!Product.isJDeveloper()) {
                        this.m_delegate = (DatabaseProviderHelper.PasswordPrompter)SingletonProvider.find(DatabaseProviderHelper.PasswordPrompter.class);
                    }
                    if (this.m_delegate == null) {
                        this.m_delegate = new DefaultPasswordPrompter();
                    }
                }
                return this.m_delegate;
            }

            public Connection promptForPassword(DatabaseProvider databaseProvider) throws SQLException {
                return this.getDelegate().promptForPassword(databaseProvider);
            }

            @Deprecated
            public Connection promptForPassword(Properties properties, String string, ConnectionCreator connectionCreator) throws SQLException {
                return this.getDelegate().promptForPassword(properties, string, connectionCreator);
            }

            public void disconnect(Properties properties) {
                this.getDelegate().disconnect(properties);
            }

            public void cache(Properties properties) {
                this.getDelegate().cache(properties);
            }
        });
        DatabaseProvider.setClassLoaderFactory((DatabaseProviderClassLoaderFactory)new DatabaseProviderClassLoaderFactory(){

            public ClassLoader getClassLoader(String string) {
                ClassLoader classLoader = null;
                DatabaseProviderClassLoaderFactory databaseProviderClassLoaderFactory = (DatabaseProviderClassLoaderFactory)SingletonProvider.find(DatabaseProviderClassLoaderFactory.class);
                if (databaseProviderClassLoaderFactory != null) {
                    classLoader = databaseProviderClassLoaderFactory.getClassLoader(string);
                }
                return classLoader;
            }
        });
    }
}

