/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.CancelledSQLException;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.resource.ConnBundle;
import oracle.jdevimpl.db.resource.ConnPropsBundle;

public class DefaultPasswordPrompter
extends DatabaseProviderHelper.PasswordPrompter {
    private Map<Properties, String> m_passwords = new HashMap<Properties, String>();

    private Properties createCacheVersion(DatabaseProvider databaseProvider) {
        Properties properties = databaseProvider.getProperties();
        this.removePropertiesForCache(properties);
        return properties;
    }

    private void removePropertiesForCache(Properties properties) {
        properties.remove("password");
        properties.remove("SavePassword");
    }

    private Properties createCacheVersion(Properties properties) {
        Properties properties2 = (Properties)properties.clone();
        this.removePropertiesForCache(properties2);
        return properties2;
    }

    public void cache(Properties properties) {
        Properties properties2 = this.createCacheVersion(properties);
        this.m_passwords.put(properties2, properties.getProperty("password"));
    }

    public void disconnect(Properties properties) {
        Properties properties2 = this.createCacheVersion(properties);
        this.m_passwords.remove(properties2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection promptForPassword(DatabaseProvider databaseProvider) throws SQLException {
        Properties properties = this.createCacheVersion(databaseProvider);
        if (this.m_passwords.containsKey(properties)) {
            String string = this.m_passwords.get(properties);
            try {
                return databaseProvider.getConnection(databaseProvider.getProperty("user"), string);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        int n = 0;
        Connection connection = null;
        JEWTDialog jEWTDialog = null;
        try {
            while (n < 3) {
                if (connection != null) return connection;
                ++n;
                if (jEWTDialog == null) {
                    jEWTDialog = JEWTDialog.createDialog((Component)SwingUtils.getToplevelWindow(), (String)ConnBundle.get("PASSWORD_TITLE"), (int)3);
                }
                PasswordPanel passwordPanel = new PasswordPanel("user", "password", databaseProvider.getName());
                jEWTDialog.setContent((Component)passwordPanel);
                jEWTDialog.setInitialFocus((Component)passwordPanel.m_txtPass);
                jEWTDialog.setName("DBPasswordPrompter");
                passwordPanel.initFrom(databaseProvider);
                final Holder holder = new Holder();
                final JEWTDialog jEWTDialog2 = jEWTDialog;
                boolean bl = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            holder.set((Object)jEWTDialog2.runDialog());
                        }
                    });
                    bl = (Boolean)holder.get();
                } else {
                    bl = jEWTDialog2.runDialog();
                }
                if (!bl) throw new CancelledSQLException();
                Properties properties2 = new Properties();
                passwordPanel.commitTo(properties2);
                String string = properties2.getProperty("user");
                String string2 = properties2.getProperty("password");
                try {
                    connection = databaseProvider.getConnection(string, string2);
                    this.m_passwords.put(properties, string2);
                    databaseProvider.setProperty("password", string2);
                    if (!ModelUtil.areDifferent((Object)databaseProvider.getProperty("user"), (Object)string)) continue;
                    databaseProvider.setProperty("user", string);
                }
                catch (CancelledSQLException cancelledSQLException) {
                    throw cancelledSQLException;
                }
                catch (SQLException sQLException) {
                    if (n > 3) throw sQLException;
                    SQLErrorDialog.showErrorDialog((Component)Ide.getMainWindow(), (String)ConnBundle.get("PASSWORD_TITLE"), (SQLException)sQLException);
                }
            }
            return connection;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            DBLog.getLogger((Object)((Object)this)).log(Level.SEVERE, "Database Password Prompter", exception);
            return connection;
        }
        finally {
            if (jEWTDialog != null) {
                jEWTDialog.dispose();
            }
        }
    }

    private class PasswordPanel
    extends JPanel {
        private String m_userKey;
        private String m_passKey;
        private JLabel m_lblUser;
        private JTextField m_txtUser;
        private JLabel m_lblPass;
        private JPasswordField m_txtPass;

        private PasswordPanel(String string, String string2, String string3) {
            this.m_userKey = string;
            this.m_passKey = string2;
            this.layoutComponents(string3);
        }

        private void layoutComponents(String string) {
            HelpUtils.setHelpID((JComponent)this, (String)"f1_connection_info_html");
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(ConnBundle.format("PASSWORD_DESC", string)), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 10, 0), 0, 0));
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
            DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper("PasswordPanel");
            if (ModelUtil.hasLength((String)this.m_userKey)) {
                this.m_lblUser = new JLabel();
                this.m_txtUser = new JTextField();
                dBUIResourceHelper.resLabel(this.m_lblUser, (Component)this.m_txtUser, ConnPropsBundle.get("user") + ":", "User");
                this.add((Component)this.m_lblUser, gridBagConstraints);
                this.add((Component)this.m_txtUser, gridBagConstraints2);
                ++gridBagConstraints.gridy;
                ++gridBagConstraints2.gridy;
            }
            if (ModelUtil.hasLength((String)this.m_passKey)) {
                this.m_lblPass = new JLabel();
                this.m_txtPass = new JPasswordField();
                dBUIResourceHelper.resLabel(this.m_lblPass, (Component)this.m_txtPass, ConnPropsBundle.get("password") + ":", "Password");
                this.add((Component)this.m_lblPass, gridBagConstraints);
                this.add((Component)this.m_txtPass, gridBagConstraints2);
            }
        }

        private void initFrom(DatabaseProvider databaseProvider) {
            if (ModelUtil.hasLength((String)this.m_userKey)) {
                this.m_txtUser.setText(databaseProvider.getProperty(this.m_userKey));
            }
            if (ModelUtil.hasLength((String)this.m_passKey)) {
                this.m_txtPass.setText(databaseProvider.getProperty(this.m_passKey));
            }
        }

        private void commitTo(Properties properties) {
            boolean bl = false;
            if (ModelUtil.hasLength((String)this.m_userKey)) {
                properties.setProperty(this.m_userKey, this.m_txtUser.getText());
                bl = true;
            }
            if (ModelUtil.hasLength((String)this.m_passKey)) {
                char[] cArray = this.m_txtPass.getPassword();
                properties.setProperty(this.m_passKey, new String(cArray));
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = '\u0000';
                }
                this.m_txtPass.setText(null);
            }
        }
    }
}

