/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import javax.naming.spi.ObjectFactory;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.panels.Traversable;
import oracle.ideimpl.db.extension.AbstractExtensionHook;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.StoreListener;
import oracle.jdeveloper.db.StoreProvider;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.migration.ConnectionsReader;
import oracle.jdevimpl.db.resource.ConnPropsBundle;

public class DatabaseConnectionHook
extends AbstractExtensionHook {
    private static final String HOOK = "database-connection-hook";
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension/db", "database-connection-hook");
    private static final String STORE_PROVIDERS = "store-providers";
    private static final String STORE_PROVIDER = "store-provider";
    private static final String STORE_LISTENERS = "store-listeners";
    private static final String STORE_LISTENER = "store-listener";
    private static final String DRIVER_ENTRIES = "jdbc-driver-entries";
    private static final String DRIVER_ENTRY = "jdbc-driver-entry";
    private static final String DRIVER_CLASS = "driver-class";
    private static final String LIBRARY_NAME = "library-name";
    private static final String FORCE_EXT_INIT = "forceExtensionInitialization";
    private static final String CONNECTION_TYPES = "connection-types";
    private static final String CONNECTION_TYPE = "connection-type";
    private static final String SUBTYPE = "subtype";
    private static final String CONNECTION_CREATOR = "connection-creator";
    private static final String DISPLAY_NAME = "display-name";
    private static final String PROPERTY_BUNDLE = "property-bundle";
    private static final String PANEL_CLASS = "panel-class";
    private static final String ROLE_LIST = "role-list";
    private static final String ROLE = "role";
    private static final String ANY = "any";
    private static final String DRIVER_CLASSES = "driver-classes";
    private static final String JDBC_PROTOCOL = "jdbc-protocol";
    private static final String LEGACY_FACTORIES = "legacy-factories";
    private static final String LEGACY_FACTORY = "legacy-factory-class";
    private static final String LEGACY_FACTORY_CLASSNAME = "#text";
    private final List<ConnectionType> m_connTypes = new CopyOnWriteArrayList<ConnectionType>();
    private final List<DriverEntry> m_driverEntries = new CopyOnWriteArrayList<DriverEntry>();

    protected void initialize() {
        this.createChildList(STORE_PROVIDERS, STORE_PROVIDER, StoreProvider.class);
        this.createChildList(STORE_LISTENERS, STORE_LISTENER, StoreListener.class);
    }

    protected void processHashStructure(HashStructure hashStructure) {
        super.processHashStructure(hashStructure);
        ArrayList<DriverEntry> arrayList = null;
        for (Object object : this.getChildList(hashStructure, DRIVER_ENTRIES, DRIVER_ENTRY)) {
            if (arrayList == null) {
                arrayList = new ArrayList<DriverEntry>();
            }
            arrayList.add(new DriverEntry((HashStructure)object));
        }
        if (arrayList != null) {
            this.m_driverEntries.addAll(arrayList);
        }
        Object object = null;
        for (HashStructure hashStructure2 : this.getChildList(hashStructure, CONNECTION_TYPES, CONNECTION_TYPE)) {
            if (object == null) {
                object = new ArrayList();
            }
            object.add((ConnectionType)new ConnectionType(hashStructure2));
        }
        if (object != null) {
            this.m_connTypes.addAll((Collection<ConnectionType>)object);
        }
        for (HashStructure hashStructure2 : this.getChildList(hashStructure, LEGACY_FACTORIES, LEGACY_FACTORY)) {
            LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
            MetaClass metaClass = lazyClassAdapter.getMetaClass(LEGACY_FACTORY_CLASSNAME);
            if (metaClass == null) continue;
            ConnectionsReader.registerObjectFactoryClass((MetaClass<? extends ObjectFactory>)metaClass);
        }
    }

    public List<StoreProvider> getStoreProviders() {
        this.checkListenerInit();
        return this.getList(StoreProvider.class);
    }

    public List<StoreListener> getStoreListeners() {
        this.checkListenerInit();
        return this.getList(StoreListener.class);
    }

    public List<DriverEntry> getDriverEntries() {
        this.checkListenerInit();
        return Collections.unmodifiableList(this.m_driverEntries);
    }

    public void checkExtensionLoaded(String string) {
        for (DriverEntry driverEntry : this.getDriverEntries()) {
            if (!ModelUtil.areEqual((Object)driverEntry.getDriverClass(), (Object)string)) continue;
            driverEntry.checkExtensionLoaded();
            break;
        }
    }

    public List<ConnectionType> getConnectionTypes() {
        this.checkListenerInit();
        ArrayList<ConnectionType> arrayList = new ArrayList<ConnectionType>(this.m_connTypes);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static synchronized DatabaseConnectionHook getHook() {
        return (DatabaseConnectionHook)DatabaseConnectionHook.findHook((ElementName)NAME, DatabaseConnectionHook.class);
    }

    public class DriverEntry
    extends HashStructureAdapter {
        private DriverEntry(HashStructure hashStructure) {
            super(hashStructure);
        }

        public String getDriverClass() {
            return DatabaseConnectionHook.this.getText(this.getHashStructure(), DatabaseConnectionHook.DRIVER_CLASS);
        }

        public String getLibraryName() {
            return DatabaseConnectionHook.this.getText(this.getHashStructure(), DatabaseConnectionHook.LIBRARY_NAME);
        }

        private void checkExtensionLoaded() {
            if (this._hash.getBoolean(DatabaseConnectionHook.FORCE_EXT_INIT, false)) {
                DatabaseConnectionHook.this.fullyLoadExtension(this._hash, "Triggered by use of JDBC driver " + this.getDriverClass());
            }
        }
    }

    public class ConnectionType
    extends HashStructureAdapter
    implements Comparable<ConnectionType> {
        private ConnectionCreator m_cc;

        private ConnectionType(HashStructure hashStructure) {
            super(hashStructure);
        }

        public String toString() {
            String string = this.getDisplayName();
            if (!ModelUtil.hasLength((String)string)) {
                string = this.getSubtype();
            }
            return string;
        }

        public String getSubtype() {
            return DatabaseConnectionHook.this.getText(this.getHashStructure(), DatabaseConnectionHook.SUBTYPE);
        }

        public Class<? extends Traversable> getPanelClass() {
            return DatabaseConnectionHook.this.loadClass(this.getHashStructure(), DatabaseConnectionHook.PANEL_CLASS, Traversable.class);
        }

        public Map<String, String> getDriverClasses() {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (HashStructure hashStructure : DatabaseConnectionHook.this.getChildList(this.getHashStructure(), DatabaseConnectionHook.DRIVER_CLASSES, DatabaseConnectionHook.DRIVER_CLASS)) {
                String string = HashStructureHook.getText((HashStructure)hashStructure);
                if (string == null) continue;
                linkedHashMap.put(string, hashStructure.getString(DatabaseConnectionHook.JDBC_PROTOCOL));
            }
            return linkedHashMap;
        }

        public String getPropertyDisplayName(String string) {
            return StringUtils.stripMnemonic((String)this.getPropNLS(string));
        }

        public String getPropertyLabelText(String string) {
            return this.getPropNLS(string) + ":";
        }

        private String getPropNLS(String string) {
            String string2 = null;
            MetaClass metaClass = DatabaseConnectionHook.this.getSingleChildMeta(this.getHashStructure(), DatabaseConnectionHook.PROPERTY_BUNDLE, ResourceBundle.class);
            if (metaClass != null) {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(metaClass.getClassName(), Locale.getDefault(), metaClass.getClassLoader());
                    string2 = this.getResourceNoFail(resourceBundle, string);
                }
                catch (MissingResourceException missingResourceException) {
                    DatabaseConnectionHook.this.logError(this.getHashStructure(), missingResourceException.getMessage());
                }
            }
            if (string2 == null) {
                string2 = this.getResourceNoFail(ConnPropsBundle.getBundle(), string);
            }
            return string2 == null ? string : string2;
        }

        private String getResourceNoFail(ResourceBundle resourceBundle, String string) {
            String string2;
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
            return string2;
        }

        public String getDisplayName() {
            return DatabaseConnectionHook.this.getText(this.getHashStructure(), DatabaseConnectionHook.DISPLAY_NAME);
        }

        public ConnectionCreator getConnectionCreator() {
            if (this.m_cc == null) {
                MetaClass metaClass = DatabaseConnectionHook.this.getSingleChildMeta(this.getHashStructure(), DatabaseConnectionHook.CONNECTION_CREATOR, ConnectionCreator.class);
                try {
                    this.m_cc = (ConnectionCreator)metaClass.newInstance();
                }
                catch (Throwable throwable) {
                    DBLog.getLogger((Object)this).warning(throwable.getMessage());
                }
            }
            return this.m_cc;
        }

        public boolean allowAnyRole() {
            boolean bl = true;
            HashStructure hashStructure = this.getHashStructure().getHashStructure(DatabaseConnectionHook.ROLE_LIST);
            if (hashStructure != null && hashStructure.containsKey(DatabaseConnectionHook.ANY)) {
                bl = hashStructure.getBoolean(DatabaseConnectionHook.ANY);
            }
            return bl;
        }

        public List<String> getPresetRoles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (HashStructure hashStructure : DatabaseConnectionHook.this.getChildList(this.getHashStructure(), DatabaseConnectionHook.ROLE_LIST, DatabaseConnectionHook.ROLE)) {
                String string = HashStructureHook.getText((HashStructure)hashStructure);
                if (!ModelUtil.hasLength((String)string)) continue;
                arrayList.add(string);
            }
            return arrayList;
        }

        public boolean showTestConnection() {
            boolean bl = true;
            String string = DatabaseConnectionHook.this.getText(this.getHashStructure(), "show-test", false);
            if (string != null) {
                bl = !string.equalsIgnoreCase("false");
            }
            return bl;
        }

        @Override
        public int compareTo(ConnectionType connectionType) {
            String string;
            String string2;
            int n = connectionType == null ? -1 : (ModelUtil.areEqual((Object)(string2 = this.getDisplayName()), (Object)(string = connectionType.getDisplayName())) ? 0 : (string2 == null ? 1 : (string == null ? -1 : string2.compareTo(string))));
            return n;
        }
    }
}

