/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.migration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.naming.Referenceable;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdeveloper.db.migration.ConnectionsReader;
import oracle.jdevimpl.db.adapter.ReferenceWorker;
import oracle.jdevimpl.db.adapter.StorageWrapper;
import oracle.jdevimpl.db.migration.AbstractDBMigrator;

public class ConnectionMigrator
extends AbstractDBMigrator {
    private static final String CM_CONNECTIONS_FILE = "IDEConnections.xml";
    private static final String CONNECTIONS_FILE_NAME = "connections.xml";
    private static URL s_migrationURL;
    private static final int JSON_CONNECTIONS = 0;
    private static final int XML_CONNECTIONS = 1;
    private static final int[] CATEGORIES;
    private boolean[] mSelected = new boolean[CATEGORIES.length];

    @Override
    public int[] getMigrationCategories() {
        return CATEGORIES;
    }

    @Override
    public void setSelected(int n, boolean bl) {
        this.mSelected[n] = bl;
    }

    @Override
    public boolean isSelected(int n) {
        return this.mSelected[n];
    }

    @Override
    protected String getExtensionID() {
        return "oracle.jdeveloper.db.connection";
    }

    public String[] migrate(File file, File file2) {
        String[] stringArray = new String[]{};
        if (this.isSelected(0)) {
            File file3 = this.getConnectionsJSONFile(file);
            URL uRL = URLFactory.newFileURL((File)file3);
            URL uRL2 = URLFactory.newURL((URL)URLFactory.newDirURL((File)file2), (String)"connections.json");
            try {
                URLFileSystem.copy((URL)uRL, (URL)uRL2);
            }
            catch (IOException iOException) {
                stringArray = new String[]{"Connection migration failed: " + iOException.getMessage()};
            }
        } else if (this.isSelected(1)) {
            File file4 = this.getConnectionsXMLFile(file);
            if (file4 == null) {
                file4 = this.getOldConnectionsXMLFile(file);
            }
            if (file4 != null) {
                s_migrationURL = URLFactory.newFileURL((File)file4);
            }
        }
        return stringArray;
    }

    public boolean canMigrate(int n, File file) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = this.getConnectionsJSONFile(file) != null;
                break;
            }
            case 1: {
                bl = this.getConnectionsXMLFile(file) != null || this.getOldConnectionsXMLFile(file) != null;
                break;
            }
        }
        return bl;
    }

    private File getConnectionsJSONFile(File file) {
        return this.findExtensionFile(file, "connections.json");
    }

    private File getConnectionsXMLFile(File file) {
        return this.findExtensionFile(file, CONNECTIONS_FILE_NAME);
    }

    private File getOldConnectionsXMLFile(File file) {
        return this.findExtensionFile(file, new String[]{"oracle.onlinedb", "oracle.j2ee"}, CM_CONNECTIONS_FILE);
    }

    public static void finishMigration(StorageWrapper storageWrapper) {
        if (s_migrationURL != null) {
            ReferenceWorker referenceWorker = StorageWrapper.getDefaultWrapper().getReferenceWorker();
            ConnectionsReader connectionsReader = ConnectionsReader.readConnections(s_migrationURL, referenceWorker);
            if (connectionsReader != null) {
                for (String string : connectionsReader.getConnectionTypes()) {
                    Storage storage = storageWrapper.getStorage(string);
                    for (Pair<String, Referenceable> pair : connectionsReader.getConnections(string)) {
                        try {
                            storage.addConnection((String)pair.first(), (Referenceable)pair.second());
                        }
                        catch (StorageException storageException) {
                            Logger.severe(ConnectionMigrator.class, (String)("Error migrating connection " + (String)pair.first()), (Throwable)storageException);
                        }
                    }
                }
            } else {
                CMConnectionsReader cMConnectionsReader = new CMConnectionsReader(s_migrationURL.getFile(), true);
                Map<String, Referenceable> map = cMConnectionsReader.getMigratedConnections();
                Storage storage = storageWrapper.getStorage("jdbc");
                for (Map.Entry<String, Referenceable> entry : map.entrySet()) {
                    String string = entry.getKey();
                    try {
                        storage.addConnection(string, entry.getValue());
                    }
                    catch (StorageException storageException) {
                        Logger.severe(ConnectionMigrator.class, (String)("Migration of " + string + " failed: " + storageException.getMessage()));
                    }
                }
            }
        }
        s_migrationURL = null;
    }

    static {
        CATEGORIES = new int[]{0, 1};
    }
}

