/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.net;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.AbstractURLStreamHandler;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class ProxyURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static Logger s_logger = Logger.getLogger(ProxyURLStreamHandlerService.class.getName());
    private final String m_protocol;
    private final URLStreamHandlerFactory m_factory;

    public ProxyURLStreamHandlerService(String protocol, URLStreamHandlerFactory factory) {
        assert (protocol != null);
        assert (factory != null);
        this.m_protocol = protocol;
        this.m_factory = factory;
    }

    public URLConnection openConnection(URL u) throws IOException {
        URLStreamHandler urlStreamHandler = this.m_factory.createURLStreamHandler(this.m_protocol);
        if (urlStreamHandler != null && urlStreamHandler instanceof AbstractURLStreamHandler) {
            return ((AbstractURLStreamHandler)urlStreamHandler).openConnection(u);
        }
        s_logger.log(Level.SEVERE, "The URLStreamHandler for " + this.m_protocol + " is not of type " + AbstractURLStreamHandler.class.getName() + ". URL calls for this" + " protocol will not work.");
        return null;
    }
}

