/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.patch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.patch.res.Bundle;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.controls.FileField;

public class PatchFilePanel
extends JPanel {
    public static final int DIALOG_TYPE_OPEN = 1;
    public static final int DIALOG_TYPE_SAVE = 2;
    private final FilePanelUI _ui = new FilePanelUI();
    private Component _parent = null;
    private boolean _chooseFolders;
    private URLFilter _filter;
    private URL _implicitUrl;
    private int _dialogType = 2;
    public static final URL FILESYSTEM_ROOT;

    public PatchFilePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this._ui, "Center");
        this._ui.getBrowseButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatchFilePanel.this.performChooserEdit();
            }
        });
        this.setURL(FILESYSTEM_ROOT);
        this.setChooseFolders(false);
    }

    public void setBrowseMnemonic(int mnemonic) {
        this._ui.getBrowseButton().setMnemonic(mnemonic);
    }

    public void setDialogType(int dialogType) {
        this._dialogType = dialogType;
    }

    public URL getFile() {
        return this.getURL();
    }

    public void setChooseFolders(boolean folders) {
        this._chooseFolders = folders;
        this._ui.getFileField().setOnlyDirectories(folders);
    }

    public URL getURL() {
        String filePath = this._ui.getFileField().getText();
        return filePath.endsWith(File.separator) ? URLFactory.newDirURL((String)filePath) : URLFactory.newFileURL((String)filePath);
    }

    public void setPath(String path) {
        this._ui.getFileField().setText(path);
    }

    public String getPath() {
        return this._ui.getFileField().getText();
    }

    public void setFile(URL url) {
        this.setURL(url);
    }

    public void setURL(URL url) {
        String path = URLFileSystem.getPlatformPathName((URL)url);
        String platformPathName = URLFileSystem.isDirectoryPath((URL)url) && !path.endsWith(File.separator) ? (path = path + File.separator) : path;
        this._ui.getFileField().setText(platformPathName);
    }

    public void setImplicitURL(URL implicitUrl) {
        this._implicitUrl = implicitUrl;
    }

    public URL getImplicitURL() {
        return this._implicitUrl;
    }

    public void setChooserParent(Component parent) {
        this._parent = parent;
    }

    public Component getChooserParent() {
        return this._parent;
    }

    public Component getFocusComponent() {
        return this._ui.getFileField();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._ui.getFileField().setEnabled(enabled);
        this.setInsightEnabled(enabled);
        this.setBrowseEnabled(enabled);
    }

    public void setURLFilter(URLFilter filter) {
        this._filter = filter;
    }

    public boolean isFieldEmpty() {
        return this._ui.getFileField().getText().equals("");
    }

    public void setInsightEnabled(boolean enabled) {
        if (!enabled) {
            this._ui.getFileField().getPopupHandler().setInsightVisible(false);
        }
        this._ui.getFileField().getPopupHandler().unregisterInsightProvider(this._ui.getFileField().getInsightProvider());
        if (enabled) {
            this._ui.getFileField().getPopupHandler().registerInsightProvider(this._ui.getFileField().getInsightProvider());
        }
    }

    public boolean isInsightEnabled() {
        return this._ui.getFileField().getPopupHandler().isRegisteredInsightProvider(this._ui.getFileField().getInsightProvider());
    }

    public void setBrowseEnabled(boolean enabled) {
        this._ui.getBrowseButton().setEnabled(enabled);
    }

    public void setBrowseVisible(boolean visible) {
        this._ui.getBrowseButton().setVisible(visible);
    }

    public boolean isBrowseEnabled() {
        return this._ui.getBrowseButton().isEnabled();
    }

    private static final URLChooser createChooser() {
        URLChooser chooser = DialogUtil.newURLChooser();
        chooser.setSelectionMode(0);
        chooser.setShowJarsAsDirs(false);
        return chooser;
    }

    private static final URLChooser createFileChooser() {
        URLChooser chooser = PatchFilePanel.createChooser();
        chooser.setSelectionScope(0);
        return chooser;
    }

    private static final URLChooser createFolderChooser() {
        URLChooser chooser = PatchFilePanel.createChooser();
        chooser.setSelectionScope(1);
        return chooser;
    }

    private void performChooserEdit() {
        URLChooser chooser;
        URLChooser uRLChooser = chooser = this._chooseFolders ? PatchFilePanel.createFolderChooser() : PatchFilePanel.createFileChooser();
        if (this.getPath().equals("/")) {
            chooser.setSelectedURL(FILESYSTEM_ROOT);
        } else {
            URL url = this.getFile();
            if (this.isFieldEmpty()) {
                url = this._implicitUrl;
            }
            if (url != null) {
                chooser.setSelectedURL(url);
            }
        }
        chooser.setURLFilter(this._filter);
        Component parent = this.getChooserParent();
        if (parent == null) {
            parent = this;
        }
        int result = -1;
        if (this._dialogType == 1) {
            result = chooser.showOpenDialog(parent);
        }
        if (this._dialogType == 2) {
            result = chooser.showSaveDialog(parent);
        }
        if (result != 0) {
            return;
        }
        this.setFile(chooser.getSelectedURL());
    }

    static {
        URL url = URLFactory.newFileURL((String)System.getProperty("user.home"));
        while (URLFileSystem.getParent((URL)url) != null) {
            url = URLFileSystem.getParent((URL)url);
        }
        FILESYSTEM_ROOT = url;
    }

    public class FilePanelUI
    extends JPanel {
        private FileField m_FileField;
        private JButton m_BrowseButton;

        public FilePanelUI() {
            this.setName("FilePanelUI");
            this.createComponents();
            this.layoutComponents();
            this.localizeComponentsMethod();
        }

        private void createComponents() {
            this.m_FileField = new FileField();
            this.m_FileField.setName("FileField");
            this.m_BrowseButton = new JButton();
            this.m_BrowseButton.setName("BrowseButton");
        }

        private void layoutComponents() {
            int insetSize = 2;
            Insets i = new Insets(insetSize, insetSize, insetSize, insetSize);
            LayoutBuilder builder = new LayoutBuilder();
            builder.setDefaultAnchor(17);
            Object c = this.m_FileField;
            builder.setDefaultAnchor(17);
            builder.add((Component)c, i, 1, false, true);
            c = this.m_BrowseButton;
            builder.setDefaultAnchor(17);
            builder.add((Component)c, i, 1, false, false);
            builder.nl();
            builder.addToPanel((Container)this);
        }

        private void localizeComponentsMethod() {
            ResourceUtils.resButton((AbstractButton)this.m_BrowseButton, (String)Bundle.get("FILE_PANEL_BROWSE_BUTTON_LABEL"));
        }

        public FileField getFileField() {
            return this.m_FileField;
        }

        public JButton getBrowseButton() {
            return this.m_BrowseButton;
        }
    }
}

