/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controls.StatusBarControl;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.util.Log;

public class EditorStatusBar
implements ActionListener,
ChangeListener,
EditorPlugin,
FeedbackManager {
    private static boolean OFFSETS_UI = Boolean.getBoolean("ceditor.offsets.ui");
    private BasicEditorPane editor;
    private StatusBarCell insertOverwriteCell;
    private StatusBarCell lineNumberCell;
    private StatusBarCell offsetCell;
    private StatusBarCell eolTypeCell;
    private StatusBarCell modifiedCell;
    private JComponent[] cells;
    private Timer feedbackTimer;
    private Timer caretTimer;
    private static final int CARET_TIMER_DELAY = 100;
    private int lastOffset;
    private String lastMessage;
    private int lastId;
    private boolean showLineTotal = EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences()).getShowTotalLines();
    private EditorOptionL editorOptionL = new EditorOptionL();
    private static final Log LOG = new Log("expiration");
    public static final String BLANK_MESSAGE = " ";
    public static final String INSERT_MODE = CEditorArb.getString(14);
    public static final String OVERWRITE_MODE = CEditorArb.getString(15);
    public static final String LINE_COLUMN = CEditorArb.getString(16);
    public static final String LINE_WITH_TOTAL_COLUMN = CEditorArb.getString(17);
    public static final String OFFSET = CEditorArb.getString(18);
    public static final String EOL_MACINTOSH = CEditorArb.getString(19);
    public static final String EOL_UNIX = CEditorArb.getString(20);
    public static final String EOL_WINDOWS = CEditorArb.getString(21);
    public static final String MODIFIED = CEditorArb.getString(22);
    public static final String READ_ONLY = CEditorArb.getString(23);
    public static final String PROTECTED = CEditorArb.getString(24);
    public static final String[] INSERT_OVERWRITE_CELL_STRINGS;
    public static final String[] EOL_CELL_STRINGS;
    public static final String[] MODIFIED_CELL_STRINGS;
    public static final String[] LINE_NUMBER_CELL_STRINGS;
    public static final String[] LINE_NUMBER_WITH_TOTAL_CELL_STRINGS;
    public static final String[] OFFSET_CELL_STRINGS;
    private static final StringBuffer scratchBuffer;

    public EditorStatusBar() {
        this.createCells();
    }

    public void install(BasicEditorPane editor) {
        this.lastOffset = -1;
        this.lastId = -1;
        this.editor = editor;
        editor.addFeedbackManager((FeedbackManager)this);
        Caret caret = editor.getCaret();
        caret.addChangeListener(this);
        this.feedbackTimer = new Timer(5000, this);
        this.feedbackTimer.setRepeats(false);
        this.caretTimer = new Timer(100, this);
        this.caretTimer.setRepeats(false);
        this.updateAllCells();
        StatusBarUpdater.getUpdater().registerStatusBar(this);
        EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences()).addStructureChangeListener(this.editorOptionL);
    }

    public void deinstall(BasicEditorPane editor) {
        StatusBarUpdater.getUpdater().unregisterStatusBar(this);
        this.feedbackTimer.stop();
        this.feedbackTimer = null;
        this.caretTimer.stop();
        this.caretTimer = null;
        Caret caret = editor.getCaret();
        if (caret != null) {
            caret.removeChangeListener(this);
        }
        editor.removeFeedbackManager((FeedbackManager)this);
        editor = null;
        EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences()).removeStructureChangeListener(this.editorOptionL);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        boolean updateCells = false;
        if (propertyName.equals("caret")) {
            Object newValue;
            Object oldValue = event.getOldValue();
            if (oldValue instanceof Caret) {
                Caret caret = (Caret)oldValue;
                caret.removeChangeListener(this);
            }
            if ((newValue = event.getNewValue()) instanceof Caret) {
                Caret caret = (Caret)newValue;
                caret.addChangeListener(this);
            }
            updateCells = true;
        } else if (propertyName.equals("tab-size")) {
            updateCells = true;
        }
        if (updateCells) {
            this.lastOffset = -1;
            this.lastId = -1;
            this.updateAllCells();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (!this.caretTimer.isRunning()) {
            this.caretTimer.restart();
        }
    }

    public void showFeedback(BasicEditorPane editorPane, String feedbackMessage) {
        this.feedbackTimer.stop();
        this.setStatusBarMessage(feedbackMessage);
    }

    private void setStatusBarMessage(String message) {
        Ide.getStatusBar().setText(message);
    }

    private void clearStatusBarMessage(String messageToClear) {
        if (Ide.getStatusBar().getText().equals(messageToClear)) {
            Ide.getStatusBar().setText(BLANK_MESSAGE);
        }
    }

    private void clearStatusBarMessage() {
        Ide.getStatusBar().setText(BLANK_MESSAGE);
    }

    public void showFeedback(BasicEditorPane editorPane, String feedbackMessage, int milliSeconds) {
        this.feedbackTimer.stop();
        this.feedbackTimer.setInitialDelay(milliSeconds);
        this.feedbackTimer.setDelay(milliSeconds);
        this.feedbackTimer.start();
        this.lastMessage = feedbackMessage;
        this.setStatusBarMessage(feedbackMessage);
    }

    public void hideFeedback(BasicEditorPane editorPane) {
        this.feedbackTimer.stop();
        this.clearStatusBarMessage();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.feedbackTimer) {
            this.clearStatusBarMessage(this.lastMessage);
            this.lastMessage = null;
        } else if (source == this.caretTimer) {
            this.updateAllCells();
        }
    }

    public JComponent[] getStatusBarCells() {
        return this.cells;
    }

    private void createCells() {
        this.insertOverwriteCell = new StatusBarCell("Insert", INSERT_OVERWRITE_CELL_STRINGS);
        this.insertOverwriteCell.setHorizontalAlignment(2);
        this.eolTypeCell = new StatusBarCell("EOL", EOL_CELL_STRINGS);
        this.eolTypeCell.setHorizontalAlignment(2);
        this.modifiedCell = new StatusBarCell("Modified", MODIFIED_CELL_STRINGS);
        this.modifiedCell.setHorizontalAlignment(2);
        this.lineNumberCell = new StatusBarCell("LineCol", this.showLineTotal ? LINE_NUMBER_WITH_TOTAL_CELL_STRINGS : LINE_NUMBER_CELL_STRINGS);
        this.lineNumberCell.setHorizontalAlignment(2);
        if (OFFSETS_UI) {
            this.offsetCell = new StatusBarCell("Offset", OFFSET_CELL_STRINGS);
            this.offsetCell.setHorizontalAlignment(2);
        }
        this.cells = OFFSETS_UI ? new JComponent[]{this.lineNumberCell, this.offsetCell, this.insertOverwriteCell, this.modifiedCell, this.eolTypeCell} : new JComponent[]{this.lineNumberCell, this.insertOverwriteCell, this.modifiedCell, this.eolTypeCell};
    }

    private int getTabSize() {
        Integer tabInteger = (Integer)this.editor.getProperty("tab-size");
        int tabSize = tabInteger != null ? tabInteger : 8;
        return tabSize;
    }

    private void updateAllCells() {
        try {
            boolean statusBarShowing = false;
            for (JComponent statusBarCell : this.getStatusBarCells()) {
                statusBarShowing = statusBarShowing || statusBarCell != null && statusBarCell.isShowing();
            }
            if (!statusBarShowing) {
                return;
            }
            this.updateCaretCell(false);
            this.updateOtherCells();
        }
        catch (ExpiredTextBufferException e) {
            LOG.trace("handled expiration in EditorStatusBar.updateAllCells: {0}", (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaretCell(boolean forceUpdate) {
        if (this.editor != null) {
            BasicDocument document = (BasicDocument)this.editor.getDocument();
            int offset = 0;
            int line = 0;
            int column = 0;
            int total = 0;
            document.readLock();
            try {
                TextBuffer textBuffer = document.getTextBuffer();
                offset = this.editor.getCaretPosition();
                if (!forceUpdate && offset == this.lastOffset && textBuffer.getChangeId() == this.lastId) {
                    return;
                }
                this.lastOffset = offset;
                this.lastId = textBuffer.getChangeId();
                LineMap lineMap = document.getLineMap();
                line = lineMap.getLineFromOffset(offset);
                int tabSize = this.getTabSize();
                column = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)line, (int)offset, (int)tabSize);
                total = lineMap.getLineCount();
                ++line;
                ++column;
            }
            catch (ExpiredTextBufferException textBuffer) {
            }
            finally {
                document.readUnlock();
            }
            String lineText = "";
            lineText = this.showLineTotal ? EditorStatusBar.getLineWithTotalColumnText(line, total, column) : EditorStatusBar.getLineColumnText(line, column);
            this.lineNumberCell.setText(lineText);
            if (OFFSETS_UI) {
                String offsetText = EditorStatusBar.getOffsetText(OFFSET, offset);
                this.offsetCell.setText(offsetText);
            }
        }
    }

    private void updateOtherCells() {
        if (this.editor != null) {
            String oldModifiedText;
            String oldEOLText;
            String oldInsertText;
            BasicCaret basicCaret;
            boolean inInsertMode;
            Caret caret;
            String modifiedText = BLANK_MESSAGE;
            BasicDocument document = (BasicDocument)this.editor.getDocument();
            TextBuffer textBuffer = document.getTextBuffer();
            boolean readOnly = textBuffer.isReadOnly();
            boolean isProtected = this.editor.isProtected();
            String insertText = readOnly ? READ_ONLY : (isProtected ? PROTECTED : ((caret = this.editor.getCaret()) != null && caret instanceof BasicCaret ? ((inInsertMode = (basicCaret = (BasicCaret)caret).getInsertMode()) ? INSERT_MODE : OVERWRITE_MODE) : INSERT_MODE));
            String eolType = textBuffer.getEOLType();
            String eolTypeText = eolType == "\r\n" ? EOL_WINDOWS : (eolType == "\n" ? EOL_UNIX : EOL_MACINTOSH);
            if (textBuffer.isModified()) {
                modifiedText = MODIFIED;
            }
            if ((oldInsertText = this.insertOverwriteCell.getText()) != insertText) {
                this.insertOverwriteCell.setText(insertText);
            }
            if ((oldEOLText = this.eolTypeCell.getText()) != eolTypeText) {
                this.eolTypeCell.setText(eolTypeText);
            }
            if ((oldModifiedText = this.modifiedCell.getText()) != modifiedText) {
                this.modifiedCell.setText(modifiedText);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getLineColumnText(int line, int column) {
        String resultText;
        StringBuffer stringBuffer = scratchBuffer;
        synchronized (stringBuffer) {
            scratchBuffer.delete(0, scratchBuffer.length());
            scratchBuffer.append(LINE_COLUMN);
            int linePos = LINE_COLUMN.indexOf("{0}");
            int columnPos = LINE_COLUMN.indexOf("{1}");
            if (linePos < columnPos) {
                if (columnPos != -1) {
                    scratchBuffer.replace(columnPos, columnPos + 3, Integer.toString(column));
                }
                if (linePos != -1) {
                    scratchBuffer.replace(linePos, linePos + 3, Integer.toString(line));
                }
            } else {
                if (linePos != -1) {
                    scratchBuffer.replace(linePos, linePos + 3, Integer.toString(line));
                }
                if (columnPos != -1) {
                    scratchBuffer.replace(columnPos, columnPos + 3, Integer.toString(column));
                }
            }
            resultText = scratchBuffer.toString();
        }
        return resultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getLineWithTotalColumnText(int line, int total, int column) {
        String resultText;
        StringBuffer stringBuffer = scratchBuffer;
        synchronized (stringBuffer) {
            scratchBuffer.delete(0, scratchBuffer.length());
            scratchBuffer.append(LINE_WITH_TOTAL_COLUMN);
            int linePos = LINE_WITH_TOTAL_COLUMN.indexOf("{0}");
            int totalPos = LINE_WITH_TOTAL_COLUMN.indexOf("{1}");
            int columnPos = LINE_WITH_TOTAL_COLUMN.indexOf("{2}");
            if (columnPos != -1) {
                scratchBuffer.replace(columnPos, columnPos + 3, Integer.toString(column));
            }
            if (totalPos != -1) {
                scratchBuffer.replace(totalPos, totalPos + 3, Integer.toString(total));
            }
            if (linePos != -1) {
                scratchBuffer.replace(linePos, linePos + 3, Integer.toString(line));
            }
            resultText = scratchBuffer.toString();
        }
        return resultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getOffsetText(String template, int offset) {
        String resultText;
        StringBuffer stringBuffer = scratchBuffer;
        synchronized (stringBuffer) {
            scratchBuffer.delete(0, scratchBuffer.length());
            scratchBuffer.append(OFFSET);
            int linePos = OFFSET.indexOf("{0}");
            if (linePos != -1) {
                scratchBuffer.replace(linePos, linePos + 3, Integer.toString(offset));
            }
            resultText = scratchBuffer.toString();
        }
        return resultText;
    }

    private void updateStatusForTotal() {
        Ide.getMainWindow().setStatusBarVisible(false);
        this.lineNumberCell.setText(this.showLineTotal ? LINE_NUMBER_WITH_TOTAL_CELL_STRINGS[0] : LINE_NUMBER_CELL_STRINGS[0]);
        this.lineNumberCell.updateSize();
        this.lineNumberCell.setMinimumSize(new Dimension(this.lineNumberCell.minimumWidth, this.lineNumberCell.getHeight()));
        this.lineNumberCell.setPreferredSize(new Dimension(this.lineNumberCell.preferredWidth, this.lineNumberCell.getHeight()));
        ((StatusBarControl)Ide.getStatusBar()).resetStatus();
        Ide.getMainWindow().setStatusBarVisible(true);
        this.updateCaretCell(true);
    }

    static {
        scratchBuffer = new StringBuffer();
        INSERT_OVERWRITE_CELL_STRINGS = new String[]{INSERT_MODE, OVERWRITE_MODE, READ_ONLY, PROTECTED};
        EOL_CELL_STRINGS = new String[]{EOL_MACINTOSH, EOL_UNIX, EOL_WINDOWS};
        MODIFIED_CELL_STRINGS = new String[]{MODIFIED};
        LINE_NUMBER_CELL_STRINGS = new String[]{EditorStatusBar.getLineColumnText(1234, 123)};
        LINE_NUMBER_WITH_TOTAL_CELL_STRINGS = new String[]{EditorStatusBar.getLineWithTotalColumnText(1234, 1234, 123)};
        OFFSET_CELL_STRINGS = new String[]{EditorStatusBar.getOffsetText(OFFSET, 12345)};
    }

    private class EditorOptionL
    extends StructureChangeListener {
        private EditorOptionL() {
        }

        public void structureValuesChanged(StructureChangeEvent e) {
            EditorStatusBar.this.showLineTotal = EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences()).getShowTotalLines();
            EditorStatusBar.this.updateStatusForTotal();
        }
    }

    private static final class StatusBarUpdater
    implements ActionListener {
        private static final StatusBarUpdater singleton = new StatusBarUpdater();
        private static final int UPDATE_DELAY = 1000;
        private List<WeakReference<EditorStatusBar>> statusbarList = new ArrayList<WeakReference<EditorStatusBar>>();
        private Timer updateTimer = new Timer(1000, this);

        private static StatusBarUpdater getUpdater() {
            return singleton;
        }

        private StatusBarUpdater() {
            this.updateTimer.setRepeats(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerStatusBar(EditorStatusBar statusbar) {
            List<WeakReference<EditorStatusBar>> list = this.statusbarList;
            synchronized (list) {
                WeakReference<EditorStatusBar> ref = new WeakReference<EditorStatusBar>(statusbar);
                this.statusbarList.add(ref);
            }
            this.updateTimer.restart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterStatusBar(EditorStatusBar statusbar) {
            List<WeakReference<EditorStatusBar>> list = this.statusbarList;
            synchronized (list) {
                int size = this.statusbarList.size();
                for (int i = 0; i < size; ++i) {
                    WeakReference<EditorStatusBar> ref = this.statusbarList.get(i);
                    if (ref == null || ref.get() != statusbar) continue;
                    ref.clear();
                    this.statusbarList.set(i, null);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            List<WeakReference<EditorStatusBar>> list = this.statusbarList;
            synchronized (list) {
                int size = this.statusbarList.size();
                for (int i = size - 1; i >= 0; --i) {
                    WeakReference<EditorStatusBar> ref;
                    WeakReference<EditorStatusBar> obj = this.statusbarList.get(i);
                    if (obj != null && (ref = obj).get() != null) {
                        EditorStatusBar statusbar = (EditorStatusBar)ref.get();
                        statusbar.updateAllCells();
                        continue;
                    }
                    this.statusbarList.remove(i);
                }
                if (this.statusbarList.size() == 0) {
                    this.updateTimer.stop();
                }
            }
        }
    }

    protected static class StatusBarCell
    extends JLabel {
        private String[] cellStrings;
        private int minimumHeight = 0;
        private int minimumWidth = 0;
        private int preferredWidth;

        protected StatusBarCell(String cellName, String[] cellStrings) {
            this.setCellStrings(cellStrings);
            this.setName(cellName);
        }

        private void setCellStrings(String[] cellStrings) {
            this.cellStrings = cellStrings;
            this.updateSize();
        }

        protected void updateSize() {
            Font font = this.getFont();
            if (font != null) {
                FontMetrics metrics = this.getFontMetrics(font);
                int width = metrics.stringWidth(this.getText());
                if (this.cellStrings != null) {
                    int listSize = this.cellStrings.length;
                    for (int i = 0; i < listSize; ++i) {
                        width = Math.max(width, metrics.stringWidth(this.cellStrings[i]));
                    }
                }
                int height = metrics.getHeight();
                int insetHeight = 0;
                int insetWidth = 0;
                Border border = this.getBorder();
                if (border != null) {
                    Insets insets = border.getBorderInsets(this);
                    insetHeight = insets.top + insets.bottom;
                    insetWidth = insets.left + insets.right;
                }
                this.minimumHeight = height + insetHeight;
                this.minimumWidth = width + insetWidth;
                this.preferredWidth = this.minimumWidth + metrics.charWidth('m');
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.minimumWidth, this.minimumHeight);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.preferredWidth, this.minimumHeight);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            this.updateSize();
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(border);
            this.updateSize();
        }
    }
}

