/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.app.CompletionList;
import oracle.dbtools.app.SqlCompleter;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class CompleterTest {
    static Integer singleTest = null;
    private static int maxTestNo = 0;
    private static Set<Integer> failedTests = new TreeSet<Integer>();
    static Set<RuleTuple> rules = CompleterTest.insightRules();
    static Earley earley = new Earley((Set)rules){

        @Override
        protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
            LexerToken token = src.get(y);
            return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
        }
    };
    private static int output = (Integer)CompleterTest.earley.symbolIndexes.get("output");
    private static int assertion = (Integer)CompleterTest.earley.symbolIndexes.get("assertion");
    private static int query = (Integer)CompleterTest.earley.symbolIndexes.get("query");
    private static int comment = (Integer)CompleterTest.earley.symbolIndexes.get("comment");
    private static int marker = (Integer)CompleterTest.earley.symbolIndexes.get("marker");
    private static int prompt = (Integer)CompleterTest.earley.symbolIndexes.get("cue");
    private static int dotted_name = (Integer)CompleterTest.earley.symbolIndexes.get("dotted_name");
    private static int sql_prefix = (Integer)CompleterTest.earley.symbolIndexes.get("\"sql prefix\"");
    private static int sql_postfix = (Integer)CompleterTest.earley.symbolIndexes.get("\"sql postfix\"");

    public static void main(String[] args) throws Exception {
        Class.forName("oracle.jdbc.OracleDriver");
        String input = Service.readFile(CompleterTest.class, "insight.test");
        List<LexerToken> src = LexerToken.parse(input, "#");
        Matrix matrix = new Matrix(earley);
        Visual visual = null;
        if (src.size() < 100) {
            visual = new Visual(src, earley);
        }
        earley.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"atest"}, src, earley, matrix);
        if (s != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.err.println("Syntax Error");
            System.err.println("at line#" + s.line);
            System.err.println(s.code);
            System.err.println(s.marker);
            System.err.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.err.print(tmp + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode root = earley.forest(src, matrix);
        long t1 = System.currentTimeMillis();
        CompleterTest.atest(root, src, input);
        long t2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (t2 - t1));
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + maxTestNo + " TESTS are OK *** ---> ");
        } else {
            System.err.println("*** TEST FAILED! *** ---> " + failedTests.toString());
            System.exit(2);
        }
    }

    private static Set<RuleTuple> insightRules() {
        try {
            String input = Service.readFile(CompleterTest.class, "insight.grammar");
            List<LexerToken> src = LexerToken.parse(input, false, 1);
            ParseNode root = Grammar.parseGrammarFile(src, input);
            TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
            Grammar.grammar(root, src, ret);
            return ret;
        }
        catch (Exception e) {
            throw new AssertionError((Object)"VT: failed to init grammar for insight test");
        }
    }

    private static void atest(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (root.contains(assertion)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            System.out.print("TEST#" + maxTestNo + " -> ");
            if (CompleterTest.assertion(root, src, input, maxTestNo)) {
                System.out.println("OK \n");
            } else {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (root.contains(output)) {
            Iterator<ParseNode> iterator = root.children().iterator();
            if (iterator.hasNext()) {
                ParseNode child = iterator.next();
                System.out.println("TEST#" + maxTestNo + " ->\n" + CompleterTest.query(child, src, input));
                return;
            }
            return;
        }
        if (root.contains(comment)) {
            CompleterTest.comment(root, src, input);
            return;
        }
        for (ParseNode child : root.children()) {
            CompleterTest.atest(child, src, input);
        }
    }

    private static boolean assertion(ParseNode root, List<LexerToken> src, String input, int testNum) throws SQLException {
        List<String> output = null;
        Map<String, Boolean> cmp = null;
        for (ParseNode child : root.children()) {
            if (child.contains(query)) {
                output = CompleterTest.query(child, src, input);
                continue;
            }
            if (!child.contains(prompt)) continue;
            cmp = CompleterTest.prompt(child, src, input);
        }
        for (String c : cmp.keySet()) {
            boolean isPositive = (Boolean)cmp.get(c);
            String cC = c;
            cC = cC.charAt(0) != '\"' ? cC.toLowerCase() : cC.substring(1, cC.length() - 1);
            boolean matched = false;
            for (String o : output) {
                String oO = o;
                oO = oO.charAt(0) != '\"' ? oO.toLowerCase() : oO.substring(1, oO.length() - 1);
                if (!cC.equals(oO)) continue;
                matched = true;
                break;
            }
            if ((matched || !isPositive) && (!matched || isPositive)) continue;
            System.out.println((isPositive ? "no" : "unexpected") + " match for " + c);
            failedTests.add(testNum);
            return false;
        }
        return true;
    }

    private static Map<String, Boolean> prompt(ParseNode node, List<LexerToken> src, String input) {
        HashMap<String, Boolean> output = new HashMap<String, Boolean>();
        if (node.contains(dotted_name) || node.from + 2 == node.to && ".".equals(src.get(node.from + 1))) {
            String current = node.content(src);
            output.put(current, true);
            return output;
        }
        String prior = null;
        for (ParseNode child : node.children()) {
            if (child.contains(prompt) && !child.contains(dotted_name)) {
                output.putAll(CompleterTest.prompt(child, src, input));
                continue;
            }
            String current = child.content(src);
            if ("-".equals(prior)) {
                output.put(current, false);
            } else if (!"-".equals(current)) {
                output.put(current, true);
            }
            prior = current;
        }
        return output;
    }

    private static List<String> query(ParseNode root, List<LexerToken> src, String input) throws SQLException {
        int pos = -1;
        for (ParseNode child : root.children()) {
            if (!child.contains(marker)) continue;
            pos = src.get((int)child.from).begin - src.get((int)root.from).begin;
        }
        String sql = CompleterTest.sql_fragment(root, src, input);
        sql = sql.replace(">!<", "!");
        sql = sql.replace("!", "");
        return CompleterTest.output(sql, pos);
    }

    private static List<String> output(String input, int pos) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@llg00hon.uk.oracle.com:1521/DB12201", "hr", "hr");
        SqlCompleter c = new SqlCompleter(conn);
        CompletionList suggestions = c.complete(input, pos);
        LinkedList<String> output = new LinkedList<String>();
        for (CompletionItem i : suggestions.entries) {
            output.add(i.entry);
        }
        return output;
    }

    private static String sql_fragment(ParseNode root, List<LexerToken> src, String input) {
        return input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end);
    }

    private static ParseNode comment(ParseNode root, List<LexerToken> src, String input) throws Exception {
        String txt = input.substring(src.get((int)(root.from + 1)).begin, src.get((int)(root.to - 1)).end - 1);
        int testNo = Integer.parseInt(txt);
        if (maxTestNo < testNo) {
            maxTestNo = testNo;
        }
        if (singleTest != null && singleTest != testNo) {
            return null;
        }
        return null;
    }
}

