/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.dbtools.util.Service;

public class Format {
    public static String singleLineComments = "singleLineComments";
    public static String kwCase = "kwCase";
    public static String idCase = "idCase";
    public static String adjustCaseOnly = "adjustCaseOnly";
    public static String formatThreshold = "formatThreshold";
    public static String alignTabColAliases = "alignTabColAliases";
    public static String alignTypeDecl = "alignTypeDecl";
    public static String alignNamedArgs = "alignNamedArgs";
    public static String alignAssignments = "alignAssignments";
    public static String alignEquality = "alignEquality";
    public static String alignRight = "alignRight";
    public static String identSpaces = "identSpaces";
    public static String useTab = "useTab";
    public static String breaksComma = "breaksComma";
    public static String breaksProcArgs = "breaksProcArgs";
    public static String breaksConcat = "breaksConcat";
    public static String breaksAroundLogicalConjunctions = "breaksAroundLogicalConjunctions";
    public static String breaksAfterSelect = "breaksAfterSelect";
    public static String commasPerLine = "commasPerLine";
    public static String breakOnSubqueries = "breakOnSubqueries";
    public static String breakAnsiiJoin = "breakAnsiiJoin";
    public static String breakParenCondition = "breakParenCondition";
    public static String maxCharLineSize = "maxCharLineSize";
    public static String forceLinebreaksBeforeComment = "forceLinebreaksBeforeComment";
    public static String extraLinesAfterSignificantStatements = "extraLinesAfterSignificantStatements";
    public static String flowControl = "flowControl";
    public static String spaceAroundOperators = "spaceAroundOperators";
    public static String spaceAfterCommas = "spaceAfterCommas";
    public static String spaceAroundBrackets = "spaceAroundBrackets";
    public static String formatProgramURL = "formatProgramURL";
    public static Map<String, Object> options = new HashMap<String, Object>(){

        @Override
        public Object put(String key, Object value) {
            programInstance = null;
            return super.put(key, value);
        }
    };
    public int inputPos = -1;
    public int outputPos = -1;
    static final String path = "/oracle/dbtools/app/";
    static SqlProgram programInstance;
    final int unary_add_op = SqlEarley.getInstance().getSymbol("unary_add_op");
    final int compound_expression822 = SqlEarley.getInstance().getSymbol("compound_expression[8,22)");
    final int sql_statement = SqlEarley.getInstance().getSymbol("sql_statement");
    final int numeric_literal = SqlEarley.getInstance().getSymbol("numeric_literal");
    final int exp = SqlEarley.getInstance().getSymbol("\".exp.\"");
    public boolean rethrowSyntaxError = false;
    Map<Integer, Integer> posDepths = new HashMap<Integer, Integer>();
    int commasCount = 0;
    Map<Integer, String> newlinePositions = new HashMap<Integer, String>();
    Map<String, String> casedIds = new HashMap<String, String>();
    Map<String, Integer> maxIdLengthInScope = new HashMap<String, Integer>();
    Map<Integer, String> ids2scope = new HashMap<Integer, String>();
    Map<Integer, Integer> ids2interval = new HashMap<Integer, Integer>();
    Set<Integer> skipWSPositions = new HashSet<Integer>();

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(SqlEarley.class, "test.sql");
        input = Service.readFile(Format.class, "format_test.sql");
        input = Service.readFile(Format.class, "usergrantshelpertest1_b.testsql");
        long t0 = System.currentTimeMillis();
        Program.timing = 10000 < input.length();
        SqlEarley.visualize = false;
        SqlEarley.main(new String[]{input});
        Format format = new Format(){};
        options.put(alignEquality, true);
        options.put(alignRight, true);
        options.put(breaksAfterSelect, false);
        String output = format.format(input);
        if (input.length() < 100000) {
            System.out.println("----------------- output: ------------------");
            System.out.println(output);
        }
        long t1 = System.currentTimeMillis();
        output = format.format(input);
        long t2 = System.currentTimeMillis();
        System.out.println("Second fmt time = " + (t2 - t1));
        System.out.println("Total time = " + (t2 - t0));
    }

    public static void setDefaultOptions() {
        options.put(singleLineComments, (Object)InlineComments.CommentsUnchanged);
        options.put(kwCase, (Object)Case.UPPER);
        options.put(idCase, (Object)Case.lower);
        options.put(adjustCaseOnly, false);
        options.put(formatThreshold, 1);
        options.put(alignTabColAliases, true);
        options.put(alignTypeDecl, true);
        options.put(alignNamedArgs, true);
        options.put(alignEquality, false);
        options.put(alignAssignments, false);
        options.put(alignRight, false);
        options.put(identSpaces, 4);
        options.put(useTab, false);
        options.put(breaksComma, (Object)Breaks.After);
        options.put(breaksProcArgs, false);
        options.put(breaksConcat, (Object)Breaks.Before);
        options.put(breaksAroundLogicalConjunctions, (Object)Breaks.Before);
        options.put(breaksAfterSelect, true);
        options.put(commasPerLine, 1);
        options.put(breakOnSubqueries, true);
        options.put(breakAnsiiJoin, false);
        options.put(breakParenCondition, false);
        options.put(maxCharLineSize, 128);
        options.put(forceLinebreaksBeforeComment, false);
        options.put(extraLinesAfterSignificantStatements, (Object)BreaksX2.X2);
        options.put(flowControl, (Object)FlowControl.IndentedActions);
        options.put(spaceAroundOperators, true);
        options.put(spaceAfterCommas, true);
        options.put(spaceAroundBrackets, (Object)Space.Default);
        options.put(formatProgramURL, "default");
    }

    public static void setOptions(Map<String, Object> changed) {
        for (String key : changed.keySet()) {
            options.put(key, changed.get(key));
        }
    }

    public boolean breaksAfterComma() {
        return options.get(breaksComma) == Breaks.After;
    }

    public boolean breaksBeforeComma() {
        return options.get(breaksComma) == Breaks.Before;
    }

    public boolean breaksAfterLogicalConjunction() {
        return options.get(breaksAroundLogicalConjunctions) == Breaks.After || options.get(breaksAroundLogicalConjunctions) == Breaks.BeforeAndAfter;
    }

    public boolean breaksBeforeLogicalConjunction() {
        return options.get(breaksAroundLogicalConjunctions) == Breaks.Before || options.get(breaksAroundLogicalConjunctions) == Breaks.BeforeAndAfter;
    }

    public boolean breaksAfterConcat() {
        return options.get(breaksConcat) == Breaks.After || options.get(breaksConcat) == Breaks.BeforeAndAfter;
    }

    public boolean breaksBeforeConcat() {
        return options.get(breaksConcat) == Breaks.Before || options.get(breaksConcat) == Breaks.BeforeAndAfter;
    }

    public boolean breaksAfterSelectFromWhere() {
        return (Boolean)options.get(breaksAfterSelect);
    }

    public boolean spaceParenDefault() {
        return options.get(spaceAroundBrackets) == Space.Default;
    }

    public boolean noSpaceBeforeOpenParen() {
        return options.get(spaceAroundBrackets) == Space.Inside || options.get(spaceAroundBrackets) == Space.NoSpace;
    }

    public boolean noSpaceBeforeCloseParen() {
        return options.get(spaceAroundBrackets) == Space.Outside || options.get(spaceAroundBrackets) == Space.NoSpace;
    }

    public boolean noSpaceAfterOpenParen() {
        return options.get(spaceAroundBrackets) == Space.Outside || options.get(spaceAroundBrackets) == Space.NoSpace;
    }

    public boolean noSpaceAfterCloseParen() {
        return options.get(spaceAroundBrackets) == Space.Inside || options.get(spaceAroundBrackets) == Space.NoSpace;
    }

    public boolean indentConditions() {
        return options.get(flowControl) == FlowControl.IndentedConditionsActions;
    }

    public boolean indentActions() {
        return options.get(flowControl) == FlowControl.IndentedConditionsActions || options.get(flowControl) == FlowControl.IndentedActions;
    }

    public boolean breakAfterConditions() {
        return options.get(flowControl) == FlowControl.SeparateConditionsActions;
    }

    public boolean breakAfterThen() {
        return options.get(flowControl) == FlowControl.IndentedActions;
    }

    public static void resetProgramInstance(String prg) {
        options.put(formatProgramURL, prg);
        programInstance = null;
    }

    public static void resetProgramInstance() {
        programInstance = null;
    }

    public String getActiveFormatProgram() throws IOException {
        String ret = Service.readFile(Format.class, "/oracle/dbtools/app/format.prg");
        Object tmp = options.get(formatProgramURL);
        if (tmp != null) {
            try {
                String customURL = (String)tmp;
                if (!"default".equalsIgnoreCase(customURL)) {
                    ret = Service.readFile(customURL);
                }
            }
            catch (Exception e) {
                System.out.println("Failed to read custom formatting program " + tmp.toString());
                System.out.println(e.getMessage());
            }
        }
        return ret;
    }

    public synchronized String format(String input) throws IOException {
        this.checkValidity();
        this.initCallbackScaffolds();
        StringBuilder output = new StringBuilder();
        this.outputPos = -1;
        Parsed target = null;
        if (programInstance == null) {
            String formaterArboriCode = this.getActiveFormatProgram();
            programInstance = new SqlProgram(formaterArboriCode, (Object)this){

                @Override
                protected Boolean getBoolBindVar(String name) {
                    Object value = options.get(name);
                    if (value != null && value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    return super.getBoolBindVar(name);
                }
            };
        } else {
            programInstance.setStruct(this);
        }
        try {
            List<LexerToken> src = LexerToken.parse(input);
            String rootPayload = "sql_statements";
            if (!this.rethrowSyntaxError) {
                rootPayload = "parse with errors";
            }
            target = new Parsed(input, src, (Earley)SqlEarley.getInstance(), new String[]{rootPayload});
            if (this.rethrowSyntaxError && target.getSyntaxError() != null) {
                throw target.getSyntaxError();
            }
            programInstance.eval(target, this);
            if (this.inputPos < 1) {
                this.outputPos = output.length();
            }
        }
        catch (SyntaxError e) {
            this.outputPos = e.end;
            if (this.rethrowSyntaxError) {
                throw e;
            }
            return input;
        }
        List<LexerToken> fullCode = LexerToken.parse(input, true);
        int pos = -1;
        String priorIdent = null;
        LexerToken prior = null;
        int cumulativeChars = 0;
        int lastNewLine = -1;
        ParseNode root = target.getRoot();
        if (root.children().size() == 0) {
            return input;
        }
        for (LexerToken t : fullCode) {
            if (options.get(adjustCaseOnly).equals(Boolean.TRUE)) {
                if (t.type != Token.COMMENT && t.type != Token.LINE_COMMENT && t.type != Token.WS) {
                    ++pos;
                }
                String word = t.content;
                if (t.type == Token.IDENTIFIER) {
                    word = this.adjustCase(word, options.get(kwCase));
                    ParseNode node = target.getRoot().leafAtPos(pos);
                    if (node != null && this.casedIds.containsKey(node.interval())) {
                        word = this.casedIds.get(node.interval());
                    }
                }
                output.append(word);
                continue;
            }
            if (this.outputPos < 0 && this.inputPos <= t.begin) {
                this.outputPos = t.begin;
            }
            if (root.topLevel != null && root.coveredByOnTopLevel(pos + 1) == null) {
                output.append(t.content);
                if (t.type == Token.WS || t.type == Token.COMMENT || t.type == Token.LINE_COMMENT || t.type == Token.MACRO_SKIP || t.type == Token.SQLPLUSLINECONTINUE_SKIP) continue;
                ++pos;
                continue;
            }
            if (t.type == Token.WS) {
                if (!"\n".equals(t.content)) continue;
                if (prior != null && prior.end < lastNewLine && lastNewLine < t.begin && options.get(extraLinesAfterSignificantStatements) == BreaksX2.Keep) {
                    output.append("\n");
                }
                lastNewLine = t.end;
                continue;
            }
            if (t.type == Token.COMMENT || t.type == Token.LINE_COMMENT || t.type == Token.MACRO_SKIP || t.type == Token.SQLPLUSLINECONTINUE_SKIP) {
                if (((Boolean)options.get(forceLinebreaksBeforeComment)).booleanValue() && prior != null && lastNewLine < prior.end) {
                    output.append("\n    ");
                }
                if (prior != null) {
                    output.append(input.substring(prior.end, t.begin));
                }
                if (t.content.endsWith("\r")) {
                    t.content = t.content.substring(0, t.content.length() - 1) + '\n';
                }
                String pureContent = t.content;
                boolean endsWNL = false;
                if (pureContent.endsWith("\n")) {
                    pureContent = pureContent.substring(0, pureContent.length() - 1);
                    endsWNL = true;
                }
                if (pureContent.startsWith("--")) {
                    pureContent = pureContent.substring(2);
                } else if (pureContent.startsWith("/*") && pureContent.endsWith("*/")) {
                    pureContent = pureContent.substring(2, pureContent.length() - 2);
                }
                if (!pureContent.contains("\n")) {
                    if (options.get(singleLineComments) == InlineComments.MultiLine) {
                        output.append("/*" + pureContent + "*/");
                        if (endsWNL) {
                            output.append("\n");
                        }
                    } else if (options.get(singleLineComments) == InlineComments.SingleLine) {
                        output.append("--" + pureContent);
                        output.append("\n");
                    } else {
                        output.append(t.content);
                    }
                } else {
                    output.append(t.content);
                }
                prior = t;
                cumulativeChars = 0;
                continue;
            }
            ParseNode node = target.getRoot().leafAtPos(++pos);
            String ident = this.newlinePositions.get(pos);
            if (ident != null) {
                output.append(ident);
                priorIdent = ident;
                cumulativeChars = ident.length() - 1;
            } else {
                String scope;
                if (prior != null && prior.type == Token.LINE_COMMENT) {
                    if (priorIdent != null) {
                        output.append(priorIdent);
                    } else {
                        output.append("\n");
                    }
                }
                if (null != (scope = this.ids2scope.get(pos))) {
                    scope = this.nullifySingletonIds(scope);
                }
                if (null != scope) {
                    int maxLen = this.maxIdLengthInScope.get(scope);
                    LexerToken startToken = target.getSrc().get(this.ids2interval.get(pos));
                    int idLength = prior.end - startToken.begin;
                    int pad = maxLen + 3 - idLength;
                    if (pad < 1) {
                        pad = 1;
                    }
                    output.append(Service.padln("", pad));
                } else {
                    String separator = this.decideSpace(target, pos);
                    if ("/".equals(t.content) && node.parent() != null && node.parent().contains(this.sql_statement)) {
                        separator = "\n";
                        cumulativeChars = 0;
                    }
                    if ((Integer)options.get(maxCharLineSize) < cumulativeChars) {
                        separator = priorIdent;
                        cumulativeChars = priorIdent.length() - 1;
                    } else {
                        cumulativeChars += separator.length();
                    }
                    output.append(separator);
                }
            }
            String word = t.content;
            if (t.type == Token.IDENTIFIER) {
                word = this.adjustCase(word, options.get(kwCase));
            }
            if (node != null && this.casedIds.containsKey(node.interval())) {
                word = this.casedIds.get(node.interval());
            }
            output.append(word);
            cumulativeChars += word.length();
            prior = t;
        }
        if (pos < (Integer)options.get(formatThreshold)) {
            return input;
        }
        String ret = output.toString();
        if (ret.startsWith("\n")) {
            ret = ret.substring(1);
        }
        if (options.get(extraLinesAfterSignificantStatements) != BreaksX2.Keep) {
            ret = ret.replace("\n\n\n", "\n\n");
        }
        int index = -1;
        while ((index = ret.indexOf(";/", index + 1)) >= 0) {
            if (ret.indexOf("*", index + 1) == index + 2) continue;
            ret = ret.substring(0, index) + ";\n/" + ret.substring(index + 2);
        }
        this.inputPos = -1;
        return ret;
    }

    private void checkValidity() throws IOException {
        String formaterArboriCode = this.getActiveFormatProgram();
        boolean oK = this.checkIfContains(formaterArboriCode, "skipWhiteSpaceBeforeNode:");
        if (oK) {
            oK = this.checkIfContains(formaterArboriCode, ":indentConditions");
        }
    }

    private boolean checkIfContains(String formaterArboriCode, String substr) {
        boolean oK = true;
        if (formaterArboriCode.indexOf(substr) < 0) {
            oK = false;
        }
        if (!oK) {
            MessageLogging.getInstance().log("Mising " + substr + "; had to reset format program");
            Format.resetProgramInstance();
            options.put(formatProgramURL, "default");
        }
        return oK;
    }

    private String nullifySingletonIds(String scope) {
        int cnt = 0;
        for (String sc : this.ids2scope.values()) {
            if (!sc.equals(scope)) continue;
            ++cnt;
        }
        return cnt > 1 ? scope : null;
    }

    private String decideSpace(Parsed target, int pos) {
        if (pos == 0) {
            return "";
        }
        if (this.skipWSPositions.contains(pos)) {
            return "";
        }
        return " ";
    }

    public String adjustCase(String word, Object changeCase) {
        if (!word.startsWith("\"") && changeCase == Case.lower) {
            word = word.toLowerCase();
        }
        if (!word.startsWith("\"") && changeCase == Case.UPPER) {
            word = word.toUpperCase();
        }
        if (!word.startsWith("\"") && changeCase == Case.InitCap) {
            char[] converted = new char[word.length()];
            int prior1 = 37;
            for (int i = 0; i < converted.length; ++i) {
                char current = word.charAt(i);
                converted[i] = i == 0 || prior1 == 95 ? Character.toUpperCase(current) : Character.toLowerCase(current);
                prior1 = current;
            }
            word = new String(converted);
        }
        return word;
    }

    String spaceSequence(int level) {
        String output = "";
        if (((Boolean)options.get(useTab)).booleanValue()) {
            for (int i = 0; i < level; ++i) {
                output = output + "\t";
            }
        } else {
            for (int i = 0; i < level * (Integer)options.get(identSpaces); ++i) {
                output = output + " ";
            }
        }
        return output;
    }

    private void initCallbackScaffolds() {
        this.posDepths = new HashMap<Integer, Integer>();
        this.commasCount = 0;
        this.newlinePositions = new HashMap<Integer, String>();
        this.casedIds = new HashMap<String, String>();
        this.maxIdLengthInScope = new HashMap<String, Integer>();
        this.ids2scope = new HashMap<Integer, String>();
        this.ids2interval = new HashMap<Integer, Integer>();
        this.skipWSPositions = new HashSet<Integer>();
    }

    public void closestPrecursorDescendant(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc()));
    }

    public void ancestorDescendant(Parsed target, Map<String, ParseNode> tuple) {
        String m = new Object(){}.getClass().getEnclosingMethod().getName();
        System.out.println(m + ".  " + MaterializedPredicate.tupleMnemonics(tuple, target.getSrc()));
    }

    public void indentedNodes1(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        if (node == null) {
            throw new AssertionError((Object)"node == null");
        }
        for (int i = node.from; i < node.to; ++i) {
            Integer posDepth = this.posDepths.get(i);
            if (posDepth == null) {
                posDepth = 0;
            }
            Integer n = posDepth;
            Integer n2 = posDepth = Integer.valueOf(posDepth + 1);
            this.posDepths.put(i, posDepth);
        }
    }

    public void indentedNodes2(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        int pos = node.from;
        Integer depth = this.depth(pos);
        int priorDepth = -1;
        if (0 < pos) {
            priorDepth = this.depth(pos - 1);
        }
        if (priorDepth != depth) {
            this.newlinePositions.put(pos, "\n" + this.spaceSequence(depth));
        }
        if (target.getSrc().size() <= node.to) {
            return;
        }
        pos = node.to;
        this.newlinePositions.put(pos, "\n" + this.spaceSequence(this.depth(pos)));
    }

    private int depth(int pos) {
        Integer ret = this.posDepths.get(pos);
        if (ret == null) {
            return 0;
        }
        return ret;
    }

    public void identifiers(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("identifier");
        String id = target.getSrc().get((int)node.from).content;
        if ("TO_CHAR".equals(id.toUpperCase()) || "TO_DATE".equals(id.toUpperCase()) || "DECODE".equals(id.toUpperCase()) || "SYSDATE".equals(id.toUpperCase()) || "REF".equals(id.toUpperCase()) || "VARCHAR".equals(id.toUpperCase()) || "NULL".equals(id.toUpperCase()) || "RAISE".equals(id.toUpperCase()) || "EXIT".equals(id.toUpperCase())) {
            return;
        }
        id = this.adjustCase(id, options.get(idCase));
        this.casedIds.put(node.interval(), id);
    }

    public void paddedIdsInScope(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode scope = tuple.get("scope");
        Integer maxLen = this.maxIdLengthInScope.get(scope.interval());
        if (maxLen == null) {
            maxLen = 0;
        }
        ParseNode id = tuple.get("predecessor");
        ParseNode id1 = tuple.get("follower");
        String name = target.getInput().substring(target.getSrc().get((int)id.from).begin, target.getSrc().get((int)(id.to - 1)).begin);
        if (0 < name.indexOf(10)) {
            return;
        }
        int idLen = 0;
        for (int i = id.from; i < id1.from; ++i) {
            idLen += target.getSrc().get((int)i).content.length();
        }
        if (maxLen < idLen) {
            maxLen = idLen;
        }
        this.maxIdLengthInScope.put(scope.interval(), maxLen);
        this.ids2scope.put(id1.from, scope.interval());
        this.ids2interval.put(id1.from, id.from);
    }

    public void incrementalAlignments(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String ident = this.offset(node.from, target);
        for (int i = node.from + 1; i < node.to; ++i) {
            String oldOffset = this.newlinePositions.get(i);
            if (oldOffset == null) continue;
            this.newlinePositions.put(i, oldOffset + Service.padln("", ident.length() - this.indent(node.from, target)));
        }
    }

    private int indent(int pos, Parsed target) {
        int i = pos;
        while (pos - 50 < i & 0 <= i) {
            String tmp = this.newlinePositions.get(i);
            if (tmp != null) {
                return tmp.length();
            }
            --i;
        }
        return 1;
    }

    public void pairwiseAlignments(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        ParseNode predecessor = tuple.get("predecessor");
        String nodeIndent = this.newlinePositions.get(node.from);
        if (nodeIndent == null) {
            return;
        }
        String ident = this.offset(predecessor.from, target);
        int delta = ident.length() - nodeIndent.length();
        this.newlinePositions.put(node.from, ident);
        if (0 < delta) {
            for (int i = node.from + 1; i < node.to; ++i) {
                String oldOffset = this.newlinePositions.get(i);
                if (oldOffset == null) continue;
                this.newlinePositions.put(i, oldOffset + Service.padln("", delta));
            }
        }
    }

    private String offset(int pos, Parsed target) {
        String ret = "\n";
        int i = pos;
        while (pos - 50 < i & 0 <= i) {
            String tmp = this.newlinePositions.get(i);
            if (tmp != null && tmp.startsWith("\n\n")) {
                tmp = tmp.substring(1);
            }
            if (i == 0) {
                tmp = "\n";
            }
            if (tmp != null) {
                ret = tmp;
                for (int j = i; j < pos; ++j) {
                    for (int k = 0; k < target.getSrc().get((int)j).content.length(); ++k) {
                        ret = ret + ' ';
                    }
                    ret = ret + this.decideSpace(target, j + 1);
                }
                break;
            }
            --i;
        }
        return ret;
    }

    public void rightAlignments(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String kw = target.getSrc().get((int)node.from).content;
        int delta = "select".length() - kw.length();
        String nodeIndent = this.newlinePositions.get(node.from);
        if (nodeIndent == null) {
            return;
        }
        this.newlinePositions.put(node.from, nodeIndent + Service.padln("", delta));
    }

    public void extraBrkBefore(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String padding = this.newlinePositions.get(node.from);
        if (padding == null) {
            int depth = this.depth(node.from);
            this.newlinePositions.put(node.from, "\n" + this.spaceSequence(depth));
        }
    }

    public void extraBrkAfter(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        String padding = this.newlinePositions.get(node.to);
        if (padding == null) {
            int depth = this.depth(node.to);
            this.newlinePositions.put(node.to, "\n" + this.spaceSequence(depth));
        }
    }

    public void brkX2(Parsed target, Map<String, ParseNode> tuple) {
        if (options.get(extraLinesAfterSignificantStatements) != BreaksX2.X2) {
            return;
        }
        ParseNode node = tuple.get("node");
        String padding = this.newlinePositions.get(node.to);
        if (padding == null) {
            this.newlinePositions.put(node.to, "\n\n");
        } else {
            this.newlinePositions.put(node.to, "\n" + padding);
        }
    }

    public void ignoreLineBreaksBeforeNode(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        this.newlinePositions.remove(node.from);
    }

    public void ignoreLineBreaksAfterNode(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        this.newlinePositions.remove(node.to);
    }

    public void skipWhiteSpaceBeforeNode(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        this.skipWSPositions.add(node.from);
    }

    public void skipWhiteSpaceAfterNode(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("node");
        this.skipWSPositions.add(node.to);
    }

    static {
        Format.setDefaultOptions();
        programInstance = null;
    }

    public static enum FlowControl {
        IndentedActions,
        Terse,
        SeparateConditionsActions,
        IndentedConditionsActions;

    }

    public static enum InlineComments {
        CommentsUnchanged,
        SingleLine,
        MultiLine;

    }

    public static enum BreaksX2 {
        X1,
        X2,
        Keep;

    }

    public static enum Breaks {
        Before,
        After,
        None,
        BeforeAndAfter;

    }

    public static enum Space {
        Default,
        Inside,
        Outside,
        NoSpace;

    }

    public static enum Case {
        UPPER,
        lower,
        InitCap,
        NoCaseChange;

    }
}

