/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import oracle.dbtools.app.Rewrite;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class Obfuscator
extends Rewrite {
    private int varCnt = 0;
    private int changeCnt = 0;
    static SecretKey desKey = null;
    static Cipher desCipher = null;
    static final String path = "/oracle/dbtools/app/";
    static SqlProgram programInstance;

    public Obfuscator(Set<String> fileExtensions) {
        super(fileExtensions);
    }

    private static String rename(String input) {
        try {
            desCipher.init(1, desKey);
            byte[] cleartext = input.getBytes();
            byte[] ciphertext = desCipher.doFinal(cleartext);
            String output64 = Base64.getEncoder().encodeToString(ciphertext);
            if (30 < output64.length()) {
                char last = output64.charAt(output64.length() - 1);
                output64 = last + output64.substring(1, 30);
            }
            return "\"" + output64 + "\"";
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(Obfuscator.class, "obfuscator_test.sql");
        List<LexerToken> src = LexerToken.parse(input);
        Obfuscator o = new Obfuscator(null);
        String output = o.transform(input, src, null);
        System.out.println(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String transform(String input, List<LexerToken> src, LazyNode notUsed) {
        try {
            if (programInstance == null) {
                programInstance = new SqlProgram(Service.readFile(Obfuscator.class, "/oracle/dbtools/app/vars.prg"));
                Program.debug = false;
            }
            Map<String, MaterializedPredicate> predicateVectors = programInstance.run(input, null);
            TreeMap<Long, String> substitutions = new TreeMap<Long, String>();
            MaterializedPredicate symbols = predicateVectors.get("\"var entry in scope\"");
            this.changeCnt += symbols.cardinality();
            HashSet<String> variables = new HashSet<String>();
            for (Tuple tu : symbols.getTuples()) {
                ParseNode scope = symbols.getAttribute(tu, "scope");
                ParseNode entry = symbols.getAttribute(tu, "entry");
                LexerToken t = src.get(entry.from);
                String scopedName = t.content + scope.from + ',' + scope.to;
                variables.add(scopedName);
                substitutions.put(Service.lPair(t.begin, t.end), Obfuscator.rename(scopedName));
            }
            this.varCnt += variables.size();
            StringBuilder output = new StringBuilder();
            int priorLexPos = 0;
            Iterator iterator = substitutions.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    output.append(input.substring(priorLexPos));
                    return output.toString();
                }
                long xy = (Long)iterator.next();
                int x = Service.lX(xy);
                int y = Service.lY(xy);
                String newName = (String)substitutions.get(xy);
                output.append(input.substring(priorLexPos, x));
                priorLexPos = y;
                output.append(newName);
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        catch (AssertionError e) {
            System.err.println(((Throwable)((Object)e)).getMessage());
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected String found() {
        return "found " + this.varCnt + " symbols, ";
    }

    @Override
    protected String changed() {
        return "obfuscated " + this.changeCnt + " instances";
    }

    static {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("DES");
            desKey = keygen.generateKey();
            desCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        }
        catch (Exception exception) {
            // empty catch block
        }
        programInstance = null;
    }
}

