/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class SqlRecognizerTest {
    static int testNo = 0;
    private static TreeSet<Integer> failedTests = new TreeSet();
    private static int output = -1;
    private static int recognized = -1;
    private static int list;
    private static int digits;
    private static int assertion;
    private static int identifier;
    private static int query;
    private static int atest;
    private static int sql_fragment;
    private static int comment;
    public static Earley testParser;
    static Random random;
    protected static boolean introduceRandomError;

    public static void main(String[] args) throws Exception {
        String testFile = "recognizer.test";
        SqlRecognizerTest.test(testFile);
    }

    public static void test(String testFile) throws Exception {
        String input = Service.readFile(SqlRecognizerTest.class, testFile);
        List<LexerToken> src = LexerToken.parse(input, "`");
        Visual visual = null;
        Matrix matrix = new Matrix(testParser);
        testParser.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"atest"}, src, testParser, matrix);
        if (s != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.err.println("Syntax Error");
            System.err.println("at line#" + s.line);
            System.err.println(s.code);
            System.err.println(s.marker);
            System.err.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.out.print(tmp + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode root = testParser.forest(src, matrix);
        SqlRecognizerTest.atest(root, src, input);
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + testNo + " TESTS are OK *** ---> ");
        } else {
            System.err.println("*** FAILED " + failedTests.size() + " tests *** ");
        }
        int cnt = -1;
        for (int testNo : failedTests) {
            if (++cnt < 10) {
                System.err.print(testNo + ",");
                continue;
            }
            if (cnt == 10) {
                System.err.print(" ... ");
                continue;
            }
            if (failedTests.size() - 10 >= cnt) continue;
            System.err.print("," + testNo);
        }
        if (0 < failedTests.size()) {
            System.exit(2);
        }
    }

    private static Set<RuleTuple> getRules() throws Exception {
        String input = Service.readFile(SqlRecognizerTest.class, "recognizerTest.grammar");
        List<LexerToken> src = LexerToken.parse(input, false, 1);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, ret);
        return ret;
    }

    private static void atest(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (root.contains(assertion)) {
            System.out.println("TEST#" + testNo);
            SqlRecognizerTest.assertion(root, src, input);
            return;
        }
        if (root.contains(output)) {
            Iterator<ParseNode> iterator = root.children().iterator();
            if (iterator.hasNext()) {
                ParseNode child = iterator.next();
                System.out.println("TEST#" + testNo + ":  ---> ");
                String sql = SqlRecognizerTest.sql_fragment(child, src, input);
                Method[] methods = SqlRecognizer.class.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Class<?>[] argTypes;
                    String name = methods[i].getName();
                    if (!name.startsWith("get") || (argTypes = methods[i].getParameterTypes()).length != 1 || argTypes[0] != String.class) continue;
                    Object ret = methods[i].invoke(null, sql);
                    System.out.println(name + "  " + ret.toString());
                }
                return;
            }
            return;
        }
        if (root.contains(comment)) {
            SqlRecognizerTest.comment(root, src, input);
        }
        for (ParseNode child : root.children()) {
            SqlRecognizerTest.atest(child, src, input);
        }
    }

    private static ParseNode comment(ParseNode root, List<LexerToken> src, String input) throws Exception {
        String testNum = input.substring(src.get((int)(root.from + 2)).begin, src.get((int)(root.to - 1)).end - 1);
        testNo = Integer.parseInt(testNum);
        return null;
    }

    private static String sql_fragment(ParseNode root, List<LexerToken> src, String input) {
        String ret = input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end);
        if (ret.charAt(0) == '\"') {
            ret = ret.substring(1, ret.length() - 1);
        }
        if (ret.charAt(0) == '`') {
            ret = ret.substring(1, ret.length() - 1);
        }
        return " " + ret + " ";
    }

    private static ParseNode assertion(ParseNode root, List<LexerToken> src, String input) throws Exception {
        String sql = null;
        for (ParseNode child : root.children()) {
            if (child.contains(query)) {
                sql = SqlRecognizerTest.sql_fragment(child, src, input);
                continue;
            }
            if (!child.contains(recognized)) continue;
            SqlRecognizerTest.recognized(child, src, input, sql);
        }
        return null;
    }

    private static ParseNode recognized(ParseNode root, List<LexerToken> src, String input, String sql) throws Exception {
        String id = null;
        LinkedList<Object> ret = null;
        for (ParseNode child : root.children()) {
            if (child.contains(recognized)) {
                SqlRecognizerTest.recognized(child, src, input, sql);
                continue;
            }
            if (child.contains(list)) {
                List<String> cmp = SqlRecognizerTest.list(child, src, input);
                String diff = SqlRecognizerTest.diff(cmp, (List<String>)ret, id);
                if (diff != null && 0 < diff.length()) {
                    failedTests.add(testNo);
                    System.out.println("TEST#" + testNo + ":  broken");
                    System.out.println(diff);
                }
                return null;
            }
            if (!child.contains(identifier)) continue;
            id = child.content(src);
            Object tmp = null;
            try {
                Method m = SqlRecognizer.class.getDeclaredMethod(id, String.class);
                tmp = m.invoke(null, sql);
            }
            catch (NoSuchMethodException e) {
                Method m = SqlRecognizer.class.getDeclaredMethod(id, new Class[0]);
                tmp = m.invoke((Object)new SqlRecognizer(sql), new Object[0]);
            }
            if (tmp instanceof List) {
                ret = (List)tmp;
                continue;
            }
            if (tmp instanceof Map) {
                ret = new LinkedList<Object>();
                Map tmp1 = (Map)tmp;
                Iterator iterator = tmp1.keySet().iterator();
                while (iterator.hasNext()) {
                    int k = (Integer)iterator.next();
                    ret.add(tmp1.get(k));
                }
                continue;
            }
            if (!(tmp instanceof String)) continue;
            ret = new LinkedList();
            ret.add((String)tmp);
        }
        if (0 < ret.size()) {
            failedTests.add(testNo);
            System.out.println("TEST#" + testNo + ":  broken");
            System.out.println("method " + id + " returns unexpected " + ((String)ret.get(0)).toString());
        }
        return null;
    }

    private static List<String> list(ParseNode root, List<LexerToken> src, String input) {
        LinkedList<String> ret = new LinkedList<String>();
        if (root.contains(identifier)) {
            ParseNode parent = root.parent();
            boolean negative = false;
            for (ParseNode child : parent.children()) {
                if (child.to != root.from || !child.contains("'-'")) continue;
                negative = true;
            }
            String id = root.content(src);
            if (id.charAt(0) != '`' && id.charAt(0) != '\"') {
                id = id.toUpperCase();
            }
            if (negative) {
                id = "-" + id;
            }
            ret.add(id);
            return ret;
        }
        for (ParseNode child : root.children()) {
            ret.addAll(SqlRecognizerTest.list(child, src, input));
        }
        return ret;
    }

    private static String diff(List<String> cmp0, List<String> notNormalized, String method) {
        StringBuilder ret = new StringBuilder();
        LinkedList<String> cmpPositive = new LinkedList<String>();
        LinkedList<String> cmpNegative = new LinkedList<String>();
        for (String c : cmp0) {
            if (c.charAt(0) != '`' && c.charAt(0) != '\"') {
                c = c.toUpperCase();
            } else if (c.charAt(0) == '`') {
                c = c.substring(1, c.length() - 1);
            }
            if (c.charAt(0) == '-') {
                cmpNegative.add(c.substring(1));
                continue;
            }
            cmpPositive.add(c);
        }
        LinkedList<String> cmp2 = new LinkedList<String>();
        for (String c : notNormalized) {
            if (c.charAt(0) != '`' && c.charAt(0) != '\"') {
                c = c.toUpperCase();
            } else if (c.charAt(0) == '`') {
                c = c.substring(1, c.length() - 1);
            }
            cmp2.add(c);
        }
        for (String c : cmpPositive) {
            if (cmp2.contains(c)) continue;
            ret.append("   expected " + c + " in " + method + " return");
            break;
        }
        for (String c : cmp2) {
            if (cmpPositive.contains(c)) continue;
            ret.append("   extra " + c + " in " + method + " return");
            break;
        }
        for (String c : cmpNegative) {
            if (!cmp2.contains(c)) continue;
            ret.append("   extra " + c + " in " + method + " return");
            break;
        }
        return ret.toString();
    }

    static {
        digits = -1;
        assertion = -1;
        identifier = -1;
        query = -1;
        atest = -1;
        sql_fragment = -1;
        comment = -1;
        testParser = null;
        try {
            testParser = new Earley((Set)SqlRecognizerTest.getRules()){

                @Override
                protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                    LexerToken token = src.get(y);
                    return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING || symbol == this.identifier && token.type == Token.BQUOTED_STRING;
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        output = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("output");
        list = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("list");
        assertion = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("assertion");
        identifier = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("identifier");
        query = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("query");
        atest = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("atest");
        recognized = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("recognized");
        digits = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("digits");
        sql_fragment = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("sql_fragment");
        comment = (Integer)SqlRecognizerTest.testParser.symbolIndexes.get("comment");
        random = new Random();
        introduceRandomError = false;
    }
}

