/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.app.injection.SqlInjection;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class RegressionTest {
    static Integer singleTest = null;
    private static int maxTestNo = 0;
    private static Set<Integer> failedTests = new TreeSet<Integer>();
    static Set<RuleTuple> rules = RegressionTest.injectionRules();
    static Earley earley = new Earley((Set)rules){

        @Override
        protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
            LexerToken token = src.get(y);
            return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING || symbol == this.identifier && token.type == Token.BQUOTED_STRING;
        }
    };
    private static int output = (Integer)RegressionTest.earley.symbolIndexes.get("output");
    private static int assertion = (Integer)RegressionTest.earley.symbolIndexes.get("assertion");
    private static int query = (Integer)RegressionTest.earley.symbolIndexes.get("query");
    private static int comment = (Integer)RegressionTest.earley.symbolIndexes.get("comment");
    private static int cue = (Integer)RegressionTest.earley.symbolIndexes.get("cue");
    private static int path = (Integer)RegressionTest.earley.symbolIndexes.get("path");

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(RegressionTest.class, "injection.test");
        List<LexerToken> src = LexerToken.parse(input, "`");
        Matrix matrix = new Matrix(earley);
        Visual visual = null;
        if (src.size() < 100) {
            visual = new Visual(src, earley);
        }
        earley.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"atest"}, src, earley, matrix);
        if (s != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.err.println("Syntax Error");
            System.err.println("at line#" + s.line);
            System.err.println(s.code);
            System.err.println(s.marker);
            System.err.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.err.print(tmp + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode root = earley.forest(src, matrix);
        long t1 = System.currentTimeMillis();
        RegressionTest.atest(root, src, input);
        long t2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (t2 - t1));
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + maxTestNo + " TESTS are OK *** ---> ");
        } else {
            System.err.println("*** TEST FAILED! *** ---> " + failedTests.toString());
            System.exit(2);
        }
    }

    private static Set<RuleTuple> injectionRules() {
        try {
            String input = Service.readFile(RegressionTest.class, "injectionTest.grammar");
            List<LexerToken> src = LexerToken.parse(input, "`");
            ParseNode root = Grammar.parseGrammarFile(src, input);
            TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
            Grammar.grammar(root, src, ret);
            return ret;
        }
        catch (Exception e) {
            throw new AssertionError((Object)"VT: failed to init grammar for injection test");
        }
    }

    private static void atest(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (root.contains(assertion)) {
            if (singleTest != null && singleTest != maxTestNo) {
                return;
            }
            System.out.print("TEST#" + maxTestNo + " -> ");
            if (RegressionTest.assertion(root, src, input, maxTestNo)) {
                System.out.println("OK \n");
            } else {
                System.out.println("*** Failed ***\n");
            }
            return;
        }
        if (root.contains(output)) {
            Iterator<ParseNode> iterator = root.children().iterator();
            if (iterator.hasNext()) {
                ParseNode child = iterator.next();
                System.out.println("TEST#" + maxTestNo + " ->\n" + RegressionTest.query(child, src, input));
                return;
            }
            return;
        }
        if (root.contains(comment)) {
            RegressionTest.comment(root, src, input);
            return;
        }
        for (ParseNode child : root.children()) {
            RegressionTest.atest(child, src, input);
        }
    }

    private static boolean assertion(ParseNode root, List<LexerToken> src, String input, int testNum) throws SQLException {
        List<String> output = null;
        Map<String, Boolean> cmp = null;
        for (ParseNode child : root.children()) {
            if (child.contains(query)) {
                output = RegressionTest.query(child, src, input);
                continue;
            }
            if (!child.contains(cue)) continue;
            cmp = RegressionTest.cue(child, src, input);
        }
        for (String c : cmp.keySet()) {
            boolean isPositive = (Boolean)cmp.get(c);
            String cC = c;
            cC = cC.charAt(0) != '\"' ? cC.toLowerCase() : cC.substring(1, cC.length() - 1);
            if (cC.charAt(0) == '%') {
                cC = cC.substring(1, cC.length() - 1);
            }
            boolean matched = false;
            for (String o : output) {
                String oO = o;
                oO = oO.charAt(0) != '\"' ? oO.toLowerCase() : oO.substring(1, oO.length() - 1);
                if (!(cC = cC.replace(" ", "")).equals(oO = oO.replace(" ", "")) && (isPositive || !oO.contains(cC))) continue;
                matched = true;
                break;
            }
            if ((matched || !isPositive) && (!matched || isPositive)) continue;
            System.out.println((isPositive ? "no" : "unexpected") + " match for " + c);
            failedTests.add(testNum);
            return false;
        }
        return true;
    }

    private static Map<String, Boolean> cue(ParseNode node, List<LexerToken> src, String input) {
        HashMap<String, Boolean> output = new HashMap<String, Boolean>();
        if (node.contains(path)) {
            String current = node.content(src);
            output.put(current, true);
            return output;
        }
        String prior = null;
        for (ParseNode child : node.children()) {
            if (child.contains(cue)) {
                output.putAll(RegressionTest.cue(child, src, input));
                continue;
            }
            String current = child.content(src);
            if ("-".equals(prior)) {
                output.put(current, false);
            } else if (!"-".equals(current)) {
                output.put(current, true);
            }
            prior = current;
        }
        return output;
    }

    private static List<String> query(ParseNode root, List<LexerToken> src, String input) throws SQLException {
        String sql = RegressionTest.sql_fragment(root, src, input);
        return RegressionTest.output(sql);
    }

    private static List<String> output(String input) throws SQLException {
        LinkedList<String> output = new LinkedList<String>();
        SqlInjection inject = SqlInjection.findDependencies(input);
        for (int p : inject.params) {
            for (int e : inject.execs) {
                String vars;
                ParseNode se;
                ParseNode ss = inject.parseNode2Scope.get(p);
                if (ss != (se = inject.parseNode2Scope.get(e)) || (vars = inject.dependencyStr(p, e)) == null) continue;
                output.add(vars);
            }
        }
        long t2 = System.currentTimeMillis();
        return output;
    }

    private static String sql_fragment(ParseNode root, List<LexerToken> src, String input) {
        String ret = input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end);
        if (ret.startsWith("`") || ret.startsWith("\"")) {
            ret = ret.substring(1, ret.length() - 1);
        }
        return ret;
    }

    private static ParseNode comment(ParseNode root, List<LexerToken> src, String input) throws Exception {
        String txt = input.substring(src.get((int)(root.from + 1)).begin, src.get((int)(root.to - 1)).end - 1);
        int testNo = Integer.parseInt(txt);
        if (maxTestNo < testNo) {
            maxTestNo = testNo;
        }
        if (singleTest != null && singleTest != testNo) {
            return null;
        }
        return null;
    }
}

