/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.parser.ParseNode;

class Usage {
    private static final boolean DEBUG = false;
    private final SymbolTable symtab;
    private final String name;
    private final ParseNode pos;
    private final List<Usage> sources;
    private final List<Usage> flows;
    private final PlsqlType type;
    private boolean safe;

    Usage(SymbolTable symtab, String name, PlsqlType type, ParseNode pos) {
        this.symtab = symtab;
        this.name = name;
        this.sources = new ArrayList<Usage>();
        this.flows = new ArrayList<Usage>();
        this.pos = pos;
        this.type = type;
    }

    Usage(Usage usage, ParseNode pos) {
        this(usage.symtab, usage.getName(), usage.getType(), pos);
    }

    void from(Usage u) {
        if (!(this.sources.size() > 0 && this.sources.get(this.sources.size() - 1) == u || u.flows.size() > 0 && u.flows.get(u.flows.size() - 1) == u)) {
            this.sources.add(u);
            u.flows.add(this);
        }
    }

    boolean isSafe() {
        return this.safe;
    }

    void setSafe(boolean safe) {
        this.safe = safe;
    }

    SymbolTable getSymtab() {
        return this.symtab;
    }

    String getName() {
        return this.name;
    }

    List<Usage> getSources() {
        return this.sources;
    }

    List<Usage> getFlows() {
        return this.flows;
    }

    public PlsqlType getType() {
        return this.type;
    }

    public ParseNode getPos() {
        return this.pos;
    }

    public String getPosString() {
        return "$" + this.pos.from;
    }

    public String toString(boolean full) {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append(" <-");
        for (Usage u : this.sources) {
            sb.append(" " + u.toString());
        }
        sb.append(" ->");
        for (Usage u : this.flows) {
            sb.append(" " + u.toString());
        }
        return sb.toString();
    }

    public String toString() {
        return this.name + (SqlInjectionGraph.isFake(this.pos) ? "$F" : "$") + this.pos.from;
    }
}

