/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public class AggregatePredicate
implements Predicate {
    private Type type;
    String attribute;
    Predicate predicate;

    public AggregatePredicate(String attribute, Predicate predicate, boolean slash1, boolean slash2) {
        HashSet<String> signature = new HashSet<String>();
        predicate.signature(signature);
        if (!signature.contains(attribute)) {
            boolean found = false;
            for (String attr : signature) {
                int pos = attr.indexOf(46);
                if (0 >= pos || !(attr = attr.substring(pos + 1)).equals(attribute)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new AssertionError((Object)("missing " + attribute + " in " + signature + ""));
            }
        }
        if (!slash1 && !slash2) {
            this.type = Type.OLD;
        } else if (!slash1 && slash2) {
            this.type = Type.ANCESTOR;
        } else if (slash1 && !slash2) {
            this.type = Type.DESCENDANT;
        } else if (slash1 && slash2) {
            this.type = Type.YOUNG;
        }
        this.attribute = attribute;
        this.predicate = predicate;
    }

    public AggregatePredicate(AggregatePredicate source) {
        this.type = source.type;
        this.attribute = source.attribute;
        this.predicate = source.predicate;
    }

    @Override
    public MaterializedPredicate eval(Parsed target) {
        MaterializedPredicate table = this.predicate.eval(target);
        Integer col = table.getAttribute(this.attribute);
        if (col == null) {
            throw new AssertionError((Object)("Predicate " + table.name + " doesn't have " + this.attribute + " attribute"));
        }
        MaterializedPredicate ret = new MaterializedPredicate(table.attributes, target.getSrc(), table.name);
        for (Tuple tuple : table.tuples) {
            this.eval(tuple, ret.tuples, col);
        }
        return ret;
    }

    private void eval(Tuple tuple, Set<Tuple> output, int col) {
        Tuple inferior = null;
        Tuple superior = null;
        for (Tuple cmp : output) {
            boolean sameProjection = true;
            Tuple inf = null;
            Tuple sup = null;
            for (int i = 0; i < tuple.values.length; ++i) {
                if (i == col) {
                    boolean isEarlierDOD = tuple.values[col].to < cmp.values[col].to;
                    boolean isSameDOD = tuple.values[col].to == cmp.values[col].to;
                    boolean isLaterDOD = cmp.values[col].to < tuple.values[col].to;
                    boolean isEarlierDOB = tuple.values[col].from < cmp.values[col].from;
                    boolean isSameDOB = tuple.values[col].from == cmp.values[col].from;
                    boolean isLaterDOB = cmp.values[col].from < tuple.values[col].from;
                    switch (this.type) {
                        case ANCESTOR: {
                            if ((isLaterDOD || isSameDOD && isEarlierDOB) && (isEarlierDOB || isSameDOB && isLaterDOD)) {
                                inf = cmp;
                            }
                            if (!isEarlierDOD && (!isSameDOD || !isLaterDOB) || !isLaterDOB && (!isSameDOB || !isEarlierDOD)) break;
                            sup = cmp;
                            break;
                        }
                        case DESCENDANT: {
                            if ((isEarlierDOD || isSameDOD && isLaterDOB) && (isLaterDOB || isSameDOB && isEarlierDOD)) {
                                inf = cmp;
                            }
                            if (!isLaterDOD && (!isSameDOD || !isEarlierDOB) || !isEarlierDOB && (!isSameDOB || !isLaterDOD)) break;
                            sup = cmp;
                            break;
                        }
                        case OLD: {
                            if ((isEarlierDOD || isSameDOD) && (isEarlierDOB || isSameDOB)) {
                                inf = cmp;
                            }
                            if (!isLaterDOD && !isSameDOD || !isLaterDOB && !isSameDOB) break;
                            sup = cmp;
                            break;
                        }
                        case YOUNG: {
                            if ((isLaterDOD || isSameDOD) && (isLaterDOB || isSameDOB)) {
                                inf = cmp;
                            }
                            if (!isEarlierDOD && !isSameDOD || !isEarlierDOB && !isSameDOB) break;
                            sup = cmp;
                        }
                    }
                    continue;
                }
                if (cmp.values[i].from == tuple.values[i].from && cmp.values[i].to == tuple.values[i].to) continue;
                sameProjection = false;
                break;
            }
            if (!sameProjection) continue;
            if (inferior == null) {
                inferior = inf;
            }
            if (superior != null) continue;
            superior = sup;
        }
        if (inferior != null) {
            output.remove(inferior);
        }
        if (superior == null) {
            output.add(tuple);
        }
    }

    @Override
    public String toString(int depth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append(this.attribute);
        switch (this.type) {
            case ANCESTOR: {
                sb.append("\\/");
                break;
            }
            case DESCENDANT: {
                sb.append("/\\");
                break;
            }
            case OLD: {
                sb.append("\\\\");
                break;
            }
            case YOUNG: {
                sb.append("//");
            }
        }
        sb.append(this.predicate.toString(depth));
        return sb.toString();
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src, Map<String, Attribute> varDefs) {
        throw new AssertionError((Object)"N/A");
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        this.predicate.variables(ret, false);
    }

    @Override
    public void signature(Set<String> ret) {
        this.predicate.signature(ret);
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        return this.predicate.isRelated(var1, var2, varDefs);
    }

    @Override
    public Map<String, Boolean> dependencies() {
        return this.predicate.dependencies();
    }

    @Override
    public Predicate copy(Program prg) {
        AggregatePredicate ret = new AggregatePredicate(this);
        ret.predicate = this.predicate.copy(prg);
        return ret;
    }

    public static enum Type {
        ANCESTOR,
        DESCENDANT,
        OLD,
        YOUNG;

    }
}

