/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.BindVar;
import oracle.dbtools.arbori.CompositeExpr;
import oracle.dbtools.arbori.NodeContent;
import oracle.dbtools.arbori.NodeMatchingSrc;
import oracle.dbtools.arbori.Oper;
import oracle.dbtools.arbori.PositionalRelation;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.True;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.ParseNode;

abstract class Attribute {
    String name;

    Attribute() {
    }

    static ParseNode getSibling(ParseNode self, ParseNode parent, int offset) {
        if (offset == 1) {
            boolean matched = false;
            for (ParseNode c : parent.children()) {
                if (matched) {
                    return c;
                }
                if (c != self) continue;
                matched = true;
            }
            return null;
        }
        if (offset == -1) {
            ParseNode prior = null;
            for (ParseNode c : parent.children()) {
                if (c == self) {
                    return prior;
                }
                prior = c;
            }
            return null;
        }
        ParseNode[] children = parent.children().toArray(new ParseNode[0]);
        for (int i = 0; i < children.length; ++i) {
            int pos;
            ParseNode child = children[i];
            if (child != self || 0 > (pos = i + offset) || pos >= children.length) continue;
            return children[pos];
        }
        return null;
    }

    protected static String referredTo(String attr) {
        int pos2;
        int pos = attr.indexOf(60);
        if (0 < pos) {
            String postfix = attr.substring(pos + 1).trim();
            if (postfix.charAt(0) == '=' || postfix.charAt(0) == '<') {
                postfix = postfix.substring(1);
            }
            if (postfix.indexOf(46) < 0 & postfix.indexOf(93) < 0) {
                return postfix;
            }
        }
        if (0 < (pos = attr.indexOf(61))) {
            return attr.substring(pos + 1);
        }
        if (attr.endsWith("^")) {
            return attr.substring(0, attr.length() - 1);
        }
        int pos1 = attr.lastIndexOf(45);
        if (pos1 < (pos2 = attr.lastIndexOf(43))) {
            pos1 = pos2;
        }
        if (0 < pos1) {
            try {
                String suffix = attr.substring(pos1);
                int n = Integer.parseInt(suffix);
                return attr.substring(0, pos1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (0 < (pos = attr.lastIndexOf(46))) {
            return attr.substring(0, pos);
        }
        return null;
    }

    boolean isDependent(String primaryVar, Map<String, Attribute> varDefs) {
        if (primaryVar.equals(this.name)) {
            return true;
        }
        Attribute ref = this.referredTo(varDefs);
        if (ref == null) {
            return false;
        }
        return ref.isDependent(primaryVar, varDefs);
    }

    public String toString() {
        return this.name;
    }

    Predicate appendProposition(Predicate extra, Predicate p) {
        return new CompositeExpr(extra, p, Oper.CONJUNCTION);
    }

    static Predicate unaryFilter(Predicate p, String nodeVar) {
        if (p instanceof NodeContent) {
            NodeContent nc = (NodeContent)p;
            if (!nc.nodeVar.equals(nodeVar)) {
                return new True();
            }
            return p;
        }
        if (p instanceof PositionalRelation) {
            PositionalRelation pr = (PositionalRelation)p;
            if (!(pr.a instanceof BindVar && pr.b.name.equals(nodeVar) || pr.b instanceof BindVar && pr.a.name.equals(nodeVar))) {
                return new True();
            }
            return p;
        }
        if (p instanceof NodeMatchingSrc) {
            NodeMatchingSrc nms = (NodeMatchingSrc)p;
            if (!nms.nodeVar.equals(nodeVar)) {
                return new True();
            }
            return p;
        }
        if (p instanceof CompositeExpr) {
            CompositeExpr ce = (CompositeExpr)p;
            if (ce.oper == Oper.CONJUNCTION || ce.oper == Oper.DISJUNCTION) {
                Predicate lft = Attribute.unaryFilter(ce.lft, nodeVar);
                Predicate rgt = Attribute.unaryFilter(ce.rgt, nodeVar);
                return new CompositeExpr(lft, rgt, ce.oper);
            }
            if (ce.oper == Oper.NEGATION) {
                return new True();
            }
        }
        return new True();
    }

    abstract Set<Tuple> eval(Map<String, Integer> var1, Set<Tuple> var2, ParseNode var3);

    abstract ParseNode lookup(Map<String, Integer> var1, ParseNode[] var2, Map<String, Attribute> var3);

    abstract Attribute referredTo(Map<String, Attribute> var1);
}

