/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.AncestorExpr;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.True;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

public class IndependentAttribute
extends Attribute {
    Map<String, Predicate> db;
    private MaterializedPredicate content;
    private Predicate failfastFilter = null;

    public IndependentAttribute(String name, Map<String, Predicate> db) {
        this.name = name;
        this.db = db;
    }

    public MaterializedPredicate getContent() {
        return this.content;
    }

    public void initContent(ParseNode root, List<LexerToken> src, Map<String, Attribute> varDefs, String predVar) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(this.name);
        for (String candidate : varDefs.keySet()) {
            Attribute attr = varDefs.get(candidate);
            if (attr == null) {
                attr = null;
            }
            if (attributes.contains(candidate) || !attr.isDependent(this.name, varDefs)) continue;
            attributes.add(candidate);
        }
        this.content = new MaterializedPredicate(attributes, src, null);
        Predicate fullPredicate = this.db.get(predVar);
        block1: for (ParseNode node : root.descendants()) {
            if (node.from == 7 && node.to == 12) {
                node.from = 7;
            }
            Set<Tuple> candidates = new TreeSet<Tuple>();
            ParseNode[] t = new ParseNode[this.content.arity()];
            candidates.add(new Tuple(t));
            t[this.content.getAttribute((String)this.name).intValue()] = node;
            if (!IndependentAttribute.unaryFilter(fullPredicate, this.name).eval(this.content.attributePositions, t, src, varDefs)) continue;
            for (String attr : attributes) {
                candidates = this.content.assignDependencyChain(attr, candidates, varDefs, root);
                if (candidates.size() != 0) continue;
                continue block1;
            }
            candidates = this.filterUnaryPredicates(varDefs, predVar, this.content.attributePositions, candidates, root, src);
            candidates = this.filterClosestAncestorDescendants(varDefs, predVar, this.content.attributePositions, candidates, root, src);
            for (Tuple tmp : candidates) {
                this.content.tuples.add(tmp);
            }
        }
    }

    int getLimits() {
        return this.content.cardinality();
    }

    void putFilter(Predicate filter) {
        this.failfastFilter = filter;
    }

    private Set<Tuple> filterClosestAncestorDescendants(Map<String, Attribute> varDefs, String predVar, Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root, List<LexerToken> src) {
        if (candidates.size() < 2) {
            return candidates;
        }
        for (String a : varDefs.keySet()) {
            Attribute attr = varDefs.get(a);
            if (!(attr instanceof AncestorExpr)) continue;
            AncestorExpr ancExpr = (AncestorExpr)attr;
            if (ancExpr.type != AncestorDescendantNodes.Type.CLOSEST) continue;
            int iDesc = attributePositions.get(ancExpr.def);
            int iAnc = attributePositions.get(ancExpr.name);
            TreeSet<Tuple> delete = new TreeSet<Tuple>();
            for (Tuple t1 : candidates) {
                for (Tuple t2 : candidates) {
                    if (t1.compareTo(t2) <= 0) continue;
                    ParseNode desc1 = t1.values[iDesc];
                    ParseNode anc1 = t1.values[iAnc];
                    ParseNode desc2 = t2.values[iDesc];
                    ParseNode anc2 = t2.values[iAnc];
                    if (desc1 == desc2) {
                        if (anc1.from <= anc2.from && anc2.to <= anc1.to) {
                            delete.add(t1);
                            continue;
                        }
                        if (anc2.from <= anc1.from && anc1.to <= anc2.to) {
                            delete.add(t2);
                            continue;
                        }
                    }
                    if (anc1 != anc2) continue;
                    if (desc1.from <= desc2.from && desc2.to <= desc1.to) {
                        delete.add(t2);
                        continue;
                    }
                    if (desc2.from > desc1.from || desc1.to > desc2.to) continue;
                    delete.add(t1);
                }
            }
            for (Tuple t : delete) {
                candidates.remove(t);
            }
        }
        return candidates;
    }

    private Set<Tuple> filterUnaryPredicates(Map<String, Attribute> varDefs, String predVar, Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root, List<LexerToken> src) {
        if (this.failfastFilter == null) {
            Predicate fullPredicate = this.db.get(predVar);
            this.failfastFilter = this.unaryFilter(varDefs, fullPredicate);
        }
        TreeSet<Tuple> ret = new TreeSet<Tuple>();
        int i = -1;
        for (Tuple t : candidates) {
            if (0 == ++i % 1000 && Thread.interrupted()) {
                throw new AssertionError((Object)"Interrupted");
            }
            if (!this.failfastFilter.eval(attributePositions, t.values, src, varDefs)) continue;
            ret.add(t);
        }
        return ret;
    }

    private Predicate unaryFilter(Map<String, Attribute> varDefs, Predicate fullPredicate) {
        LinkedList<Predicate> tmp = new LinkedList<Predicate>();
        for (String s : varDefs.keySet()) {
            Attribute attr = varDefs.get(s);
            if (!attr.isDependent(this.name, varDefs)) continue;
            tmp.add(IndependentAttribute.unaryFilter(fullPredicate, attr.name));
        }
        Predicate ret = new True();
        for (Predicate extra : tmp) {
            ret = this.appendProposition(extra, ret);
        }
        return ret;
    }

    @Override
    Set<Tuple> eval(Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root) {
        throw new AssertionError((Object)"or should just return candidates?");
    }

    @Override
    Attribute referredTo(Map<String, Attribute> varDefs) {
        return null;
    }

    @Override
    ParseNode lookup(Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) {
        Integer pos = attributePositions.get(this.name);
        if (pos == null) {
            throw new AssertionError((Object)("Missing column " + this.name));
        }
        return tuple[pos];
    }
}

