/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

class PredRef
implements Predicate {
    String name;
    Program program;

    public PredRef(String name, Program program) {
        this.name = name;
        this.program = program;
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src, Map<String, Attribute> varDefs) {
        Predicate ref = this.program.namedPredicates.get(this.name);
        if (ref == null) {
            throw new AssertionError((Object)("Unreferenced predicate variable " + this.name));
        }
        if (!(ref instanceof MaterializedPredicate)) {
            throw new AssertionError((Object)("Unevaluated predicate variable " + this.name));
        }
        return ref.eval(attributePositions, tuple, src, varDefs);
    }

    @Override
    public String toString(int depth) {
        return "->" + this.name;
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        Predicate ref = this.program.namedPredicates.get(this.name);
        ref.variables(ret, optimizeEqs);
    }

    @Override
    public void signature(Set<String> ret) {
        this.variables(ret, false);
    }

    @Override
    public MaterializedPredicate eval(Parsed target) {
        Predicate ref = this.program.namedPredicates.get(this.name);
        if (ref == null) {
            throw new AssertionError((Object)("Unreferenced predicate variable " + this.name));
        }
        if (!(ref instanceof MaterializedPredicate)) {
            throw new AssertionError((Object)("Unevaluated predicate variable " + this.name));
        }
        return ref.eval(target);
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        ret.put(this.name, true);
        return ret;
    }

    @Override
    public Predicate copy(Program prg) {
        return new PredRef(this.name, prg);
    }
}

