/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class SameNodes
extends IdentedPredicate {
    private String a;
    private String b;
    private boolean isFunctional = false;

    public SameNodes(String a, String b) {
        this.a = a;
        this.b = b;
        String ref = Attribute.referredTo(a);
        if (ref == null) {
            this.isFunctional = true;
            return;
        }
        ref = Attribute.referredTo(b);
        if (ref == null) {
            this.isFunctional = true;
            return;
        }
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src, Map<String, Attribute> varDefs) {
        if (this.isFunctional) {
            return true;
        }
        ParseNode nodeA = this.getNode(this.a, attributePositions, tuple, varDefs);
        if (nodeA == null) {
            return false;
        }
        ParseNode nodeB = this.getNode(this.b, attributePositions, tuple, varDefs);
        if (nodeB == null) {
            return false;
        }
        return nodeA.from == nodeB.from && nodeA.to == nodeB.to;
    }

    public String toString() {
        return this.a + " = " + this.b;
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        if (optimizeEqs) {
            SameNodes.variables(this.a + "=" + this.b, ret);
        } else {
            this.isFunctional = false;
            SameNodes.variables(this.a, ret);
            SameNodes.variables(this.b, ret);
        }
    }

    @Override
    public void signature(Set<String> ret) {
        SameNodes.variables(this.a, ret);
        SameNodes.variables(this.b, ret);
    }

    @Override
    ParseNode getNode(String nodeVar, Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) throws AssertionError {
        try {
            return super.getNode(nodeVar, attributePositions, tuple, varDefs);
        }
        catch (AssertionError e) {
            if (((Throwable)((Object)e)).getMessage().startsWith("unassigned var: ") && (this.a.contains("^") || this.a.contains("+1") || this.a.contains("-1") || this.b.contains("^") || this.b.contains("+1") || this.b.contains("-1"))) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        Attribute attr1 = varDefs.get(this.a);
        Attribute attr2 = varDefs.get(this.b);
        if (attr1.isDependent(var1, varDefs) && attr2.isDependent(var2, varDefs) || attr2.isDependent(var1, varDefs) && attr1.isDependent(var2, varDefs)) {
            return this;
        }
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        int pos = this.a.indexOf(46);
        if (0 < pos) {
            ret.put(this.a.substring(0, pos), true);
        }
        if (0 < (pos = this.b.indexOf(46))) {
            ret.put(this.b.substring(0, pos), true);
        }
        return ret;
    }
}

