/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class UnitTest {
    static Integer singleTest = null;
    static boolean debug = false;
    static boolean printDiffs = true;
    static int testNo = 0;
    static boolean unitTestIsOK = true;
    private static int assertion = -1;
    private static int atest = -1;
    private static int attribute = -1;
    private static int closePar = -1;
    private static int comment = -1;
    private static int col = -1;
    private static int content = -1;
    private static int header = -1;
    private static int identifier = -1;
    private static int marker = -1;
    private static int openPar = -1;
    private static int output = -1;
    private static int program_code_or_filename = -1;
    private static int program_with_input = -1;
    private static int sql_prefix = -1;
    private static int sql_postfix = -1;
    private static int table = -1;
    private static int tables = -1;
    private static int value = -1;
    static Map<String, Parsed> parsed = new HashMap<String, Parsed>();
    static Map<String, UTProgram> programs = new HashMap<String, UTProgram>();

    public static void main(String[] args) throws Exception {
        Set<RuleTuple> rules = UnitTest.getRules();
        Earley testParser = new Earley((Set)rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING || symbol == this.identifier && token.type == Token.BQUOTED_STRING;
            }
        };
        identifier = testParser.identifier;
        assertion = (Integer)testParser.symbolIndexes.get("assertion");
        atest = (Integer)testParser.symbolIndexes.get("atest");
        attribute = (Integer)testParser.symbolIndexes.get("attribute");
        closePar = (Integer)testParser.symbolIndexes.get("')'");
        col = (Integer)testParser.symbolIndexes.get("':'");
        comment = (Integer)testParser.symbolIndexes.get("comment");
        content = (Integer)testParser.symbolIndexes.get("content");
        header = (Integer)testParser.symbolIndexes.get("header");
        output = (Integer)testParser.symbolIndexes.get("output");
        marker = (Integer)testParser.symbolIndexes.get("marker");
        openPar = (Integer)testParser.symbolIndexes.get("'('");
        program_with_input = (Integer)testParser.symbolIndexes.get("program_with_input");
        program_code_or_filename = (Integer)testParser.symbolIndexes.get("program_code_or_filename");
        sql_prefix = (Integer)testParser.symbolIndexes.get("\"sql prefix\"");
        sql_postfix = (Integer)testParser.symbolIndexes.get("\"sql postfix\"");
        table = (Integer)testParser.symbolIndexes.get("table");
        tables = (Integer)testParser.symbolIndexes.get("tables");
        value = (Integer)testParser.symbolIndexes.get("value");
        String input = Service.readFile(UnitTest.class, "unit.test");
        List<LexerToken> src = LexerToken.parse(input, "`");
        Visual visual = null;
        Matrix matrix = new Matrix(testParser);
        testParser.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"atest"}, src, testParser, matrix);
        if (s != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.err.println("Syntax Error");
            System.err.println("at line#" + s.line);
            System.err.println(s.code);
            System.err.println(s.marker);
            System.err.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.out.print(tmp + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode root = testParser.forest(src, matrix);
        long t1 = System.currentTimeMillis();
        UnitTest.atest(root, src, input);
        System.out.println("time= " + (System.currentTimeMillis() - t1) + " ms (compared to 550 ms)");
        if (unitTestIsOK) {
            System.out.println("*** ALL TESTS are OK *** ---> ");
        } else {
            System.err.println("*** TEST FAILED! *** ---> ");
            System.exit(2);
        }
    }

    private static Set<RuleTuple> getRules() throws Exception {
        String input = Service.readFile(UnitTest.class, "unitTest.grammar");
        List<LexerToken> src = LexerToken.parse(input, false, 1);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, ret);
        return ret;
    }

    private static void atest(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (root.contains(assertion)) {
            if (singleTest != null && singleTest != testNo) {
                ++testNo;
                return;
            }
            UnitTest.assertion(root, src, input);
            return;
        }
        if (root.contains(output)) {
            if (singleTest != null && singleTest != testNo) {
                ++testNo;
                return;
            }
            UnitTest.output(root, src, input);
            return;
        }
        if (root.contains(comment)) {
            UnitTest.comment(root, src, input);
        }
        for (ParseNode child : root.children()) {
            UnitTest.atest(child, src, input);
        }
    }

    private static void output(ParseNode root, List<LexerToken> src, String input) throws Exception {
        Iterator<ParseNode> iterator = root.children().iterator();
        if (iterator.hasNext()) {
            ParseNode child = iterator.next();
            Map<String, MaterializedPredicate> output = UnitTest.runProgram(child, src, input);
            for (String p : output.keySet()) {
                MaterializedPredicate pred = output.get(p);
                if (pred == null) {
                    System.err.println("!!! missing predicate " + p);
                    continue;
                }
                System.out.println(p + "=" + pred.toString(p.length() + 1));
            }
            System.out.println("TEST#" + testNo++ + ":  ^^^^^ ");
            return;
        }
    }

    private static Map<String, MaterializedPredicate> runProgram(ParseNode root, List<LexerToken> src, String input) throws Exception {
        UTProgram program = null;
        boolean sawCol = false;
        String prefix = null;
        int markerPos = -1;
        String postfix = null;
        for (ParseNode child : root.children()) {
            if (child.contains(program_code_or_filename)) {
                program = UnitTest.program(child, src);
                continue;
            }
            if (!sawCol && child.contains(col)) {
                sawCol = true;
                continue;
            }
            if (prefix == null && child.contains(sql_prefix)) {
                prefix = input.substring(src.get((int)child.from).begin, src.get((int)(child.to - 1)).end);
                markerPos = child.to - child.from;
                continue;
            }
            if (child.contains(marker)) continue;
            if (postfix == null && child.contains(sql_postfix)) {
                postfix = input.substring(src.get((int)child.from).begin, src.get((int)(child.to - 1)).end);
                continue;
            }
            throw new AssertionError((Object)"Unexpected case");
        }
        Program.debug = debug;
        program.offset = markerPos;
        Map<String, MaterializedPredicate> predicateVectors = program.run(postfix == null ? prefix : prefix + ' ' + postfix, null);
        HashMap<String, MaterializedPredicate> output = new HashMap<String, MaterializedPredicate>();
        for (String p : program.namedPredicates.keySet()) {
            output.put(p, predicateVectors.get(p));
        }
        return output;
    }

    private static UTProgram program(ParseNode root, List<LexerToken> src) throws IOException {
        String str = root.content(src);
        if (str.charAt(0) == '\"') {
            str = str.substring(1, str.length() - 1);
        } else if (str.charAt(0) == '`') {
            str = str.substring(1, str.length() - 1);
        }
        UTProgram ret = programs.get(str);
        if (ret != null) {
            return ret;
        }
        List<LexerToken> lexed = LexerToken.parse(str);
        ParseNode tmp = UTProgram.getArboriParser().parse(lexed);
        String code = str;
        if (!tmp.contains(UTProgram.getArboriParser().getSymbol("program"))) {
            code = 0 < str.indexOf(47) || 0 < str.indexOf(92) ? Service.readFile(str) : Service.readFile(UnitTest.class, str);
        }
        ret = new UTProgram(code);
        programs.put(str, ret);
        return ret;
    }

    private static void comment(ParseNode root, List<LexerToken> src, String input) {
        System.out.println(input.substring(src.get((int)(root.from + 2)).begin, src.get((int)(root.to - 1)).end - 1));
    }

    private static void assertion(ParseNode root, List<LexerToken> src, String input) throws Exception {
        Map<String, MaterializedPredicate> output = null;
        HashMap<String, MaterializedPredicate> cmp = null;
        boolean sawDash = false;
        boolean sawGt = false;
        for (ParseNode child : root.children()) {
            if (output == null && child.contains(program_with_input)) {
                output = UnitTest.runProgram(child, src, input);
                continue;
            }
            if (!sawDash && child.from + 1 == child.to && "-".equals(child.content(src))) {
                sawDash = true;
                continue;
            }
            if (!sawGt && child.from + 1 == child.to && ">".equals(child.content(src))) {
                sawGt = true;
                continue;
            }
            if (cmp == null && child.contains(tables)) {
                cmp = new HashMap<String, MaterializedPredicate>();
                UnitTest.tables(cmp, child, src, input);
                continue;
            }
            if (child.from + 1 != child.to || !";".equals(child.content(src))) {
                throw new AssertionError((Object)"Unexpected case");
            }
        }
        boolean test = UnitTest.areMatching(output, cmp);
        if (!test) {
            unitTestIsOK = false;
        }
        if (test) {
            System.out.println("TEST#" + testNo++ + ":  ---> " + test);
        } else {
            System.err.println("TEST#" + testNo++ + ":  ---> " + test);
        }
    }

    private static boolean areMatching(Map<String, MaterializedPredicate> cmp1, Map<String, MaterializedPredicate> cmp2) {
        boolean ret = true;
        for (String key : cmp2.keySet()) {
            MaterializedPredicate vd1 = cmp1.get(key);
            MaterializedPredicate vd2 = cmp2.get(key);
            if (vd1 != null && vd2 != null && UnitTest.areMatching(vd1, vd2)) continue;
            if (printDiffs) {
                System.err.println(vd1.toString());
                System.err.println(vd2.toString());
            }
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean areMatching(MaterializedPredicate vd1, MaterializedPredicate vd2) {
        void var5_9;
        if (vd1.arity() != vd2.arity()) {
            return false;
        }
        if (vd1.cardinality() != vd2.cardinality()) {
            return false;
        }
        for (String attr1 : vd1.attributes) {
            if (null != vd2.getAttribute(attr1)) continue;
            return false;
        }
        Tuple[] t1 = new Tuple[vd1.tuples.size()];
        int pos = 0;
        for (Tuple tuple : vd1.tuples) {
            t1[pos++] = tuple;
        }
        Tuple[] t2 = new Tuple[vd2.tuples.size()];
        pos = 0;
        for (Tuple t : vd2.tuples) {
            t2[pos++] = t;
        }
        boolean bl = false;
        while (var5_9 < t1.length) {
            for (String attr1 : vd1.attributes) {
                ParseNode node1 = vd1.getAttribute(t1[var5_9], attr1);
                ParseNode node2 = vd2.getAttribute(t2[var5_9], attr1);
                if (node1.from == node2.from && node1.to == node2.to) continue;
                return false;
            }
            ++var5_9;
        }
        return true;
    }

    private static void tables(Map<String, MaterializedPredicate> ret, ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(table)) {
            UnitTest.table(ret, root, src, input);
            return;
        }
        for (ParseNode child : root.children()) {
            UnitTest.tables(ret, child, src, input);
        }
    }

    private static void table(Map<String, MaterializedPredicate> ret, ParseNode root, List<LexerToken> src, String input) {
        String name = null;
        boolean sawEq = false;
        boolean sawOpenBr = false;
        boolean sawCloseBr = false;
        MaterializedPredicate vd = null;
        for (ParseNode child : root.children()) {
            if (name == null && child.from + 1 == child.to) {
                name = child.content(src);
                continue;
            }
            if (!sawEq && child.from + 1 == child.to && "=".equals(child.content(src))) {
                sawEq = true;
                continue;
            }
            if (!sawOpenBr && child.from + 1 == child.to && "[".equals(child.content(src))) {
                sawOpenBr = true;
                continue;
            }
            if (vd == null && child.contains(header)) {
                vd = new MaterializedPredicate(UnitTest.values(child, src), src, null);
                continue;
            }
            if (!sawCloseBr && child.from + 1 == child.to && "]".equals(child.content(src))) {
                sawCloseBr = true;
                continue;
            }
            if (child.contains(content)) {
                UnitTest.addContent(vd, child, src);
                continue;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        ret.put(name, vd);
    }

    private static ArrayList<String> values(ParseNode root, List<LexerToken> src) {
        ArrayList<String> ret = new ArrayList<String>();
        if (root.from + 1 == root.to && (src.get((int)root.from).type == Token.IDENTIFIER || src.get((int)root.from).type == Token.DQUOTED_STRING) || root.contains(value) || root.contains(attribute)) {
            ret.add(root.content(src));
        } else {
            for (ParseNode child : root.children()) {
                ret.addAll(UnitTest.values(child, src));
            }
        }
        return ret;
    }

    private static void addContent(MaterializedPredicate ret, ParseNode root, List<LexerToken> src) {
        int i = 0;
        ParseNode[] t = new ParseNode[ret.arity()];
        for (String elem : UnitTest.values(root, src)) {
            int comma = elem.indexOf(44);
            int clPar = elem.indexOf(41);
            int from = Integer.parseInt(elem.substring(1, comma));
            int to = Integer.parseInt(elem.substring(comma + 1, clPar));
            t[i % ret.arity()] = new ParseNode(from, to, -1, -1, null);
            if (i % ret.arity() == ret.arity() - 1) {
                ret.addContent(t);
                t = new ParseNode[ret.arity()];
            }
            ++i;
        }
    }

    static class UTProgram
    extends SqlProgram {
        int offset = -1;
        String newName = "-new name-";

        public UTProgram(String arboriProgram) throws IOException {
            super(arboriProgram);
        }
    }
}

