/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.SQLPlusProviderForSQLPATH;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.util.Logger;

public class FileUtils {
    public static URLConnection getFile(String filename) {
        return FileUtils.getFile(null, filename);
    }

    public static URLConnection getFile(ScriptRunnerContext ctx, String filename) {
        if (FileUtils.getFile(ctx, filename, true) != null) {
            try {
                return FileUtils.getFile(ctx, filename, true).openConnection();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public static Path getFilePath(ScriptRunnerContext ctx, String filename) {
        URL u = FileUtils.getFile(ctx, filename, true);
        if (u != null) {
            try {
                return Paths.get(u.toURI()).toRealPath(new LinkOption[0]);
            }
            catch (Exception e) {
                Logger.fine(FileUtils.class, e);
            }
        }
        return null;
    }

    private static String expandENVvars(String text) {
        Map<String, String> envMap = System.getenv();
        String pattern = "\\$\\{([A-Za-z0-9]+)\\}";
        Pattern expr = Pattern.compile(pattern);
        Matcher matcher = expr.matcher(text);
        while (matcher.find()) {
            String envValue = envMap.get(matcher.group(1).toUpperCase());
            envValue = envValue == null ? "" : envValue.replace("\\", "\\\\");
            Pattern subexpr = Pattern.compile(Pattern.quote(matcher.group(0)));
            text = subexpr.matcher(text).replaceAll(envValue);
        }
        return text;
    }

    public static URL getFile(ScriptRunnerContext ctx, String filename, boolean once) {
        String cdfilename = null;
        String toRun = null;
        if (ctx == null) {
            ctx = new ScriptRunnerContext();
        }
        if (filename != null && filename.length() > 0) {
            filename = FileUtils.expandENVvars(filename);
            try {
                if (!(FileUtils.startsWithHttpOrFtp(filename) && FileUtils.haveIBytes(filename, ctx) || FileUtils.haveIBytesRaw(filename))) {
                    cdfilename = ctx.prependCD(filename);
                    String pathGiven = null;
                    if (cdfilename.equals(filename) && SQLPLUS.getSqlpathProvider() != null && (pathGiven = SQLPLUS.getSqlpathProvider().getSQLPATHsetting()).trim().equals(".")) {
                        pathGiven = System.getProperty("user.dir");
                    }
                    boolean prependDirectory = false;
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        if (filename.length() <= 3 || (filename.charAt(1) != ':' || filename.charAt(2) != '/' && filename.charAt(2) != '\\') && (filename.charAt(0) != '/' || filename.charAt(2) != ':' || filename.charAt(3) != '/')) {
                            prependDirectory = true;
                        }
                    } else if (!filename.startsWith("/") && !filename.startsWith("\\")) {
                        prependDirectory = true;
                    }
                    if (pathGiven != null && prependDirectory) {
                        String[] paths;
                        for (String possible : paths = FileUtils.getSQLPathString(ctx).split(File.pathSeparator)) {
                            if (possible == null) continue;
                            possible = possible.endsWith("/") || possible.endsWith("\\") ? possible + filename : possible + File.separator + filename;
                            possible = System.getProperty("os.name").startsWith("Windows") ? possible.replace("/", "\\") : possible.replace("\\", "/");
                            if (!new File(possible).exists() || !new File(possible).canRead()) continue;
                            toRun = new File(possible).getAbsolutePath();
                            break;
                        }
                    } else {
                        toRun = !new File(filename).isAbsolute() && cdfilename.equals(filename) && prependDirectory ? System.getProperty("user.home") + File.separator + filename : cdfilename;
                    }
                    if (toRun == null) {
                        toRun = cdfilename;
                    }
                    if (FileUtils.startsWithHttpOrFtp(toRun)) {
                        return new URL(toRun);
                    }
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        toRun = "/" + toRun.replace("\\", "/");
                    }
                    return new URL("file://" + toRun);
                }
                toRun = filename;
                return new URL(toRun);
            }
            catch (MalformedURLException e) {
                Logger.info(FileUtils.class, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean haveIBytes(String base, ScriptRunnerContext ctx) {
        if (!FileUtils.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        Proxy proxy = null;
        try {
            String lower = base.toLowerCase();
            if (FileUtils.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            try {
                if (ctx.getProperty("script.runner.hhtp.proxy") != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ctx.getProperty("script.runner.hhtp.proxy.host").toString(), Integer.parseInt(ctx.getProperty("script.runner.hhtp.proxy.port").toString())));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (System.getProperties().get("http.proxyHost") != null && System.getProperties().get("http.proxyPort") != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getProperties().get("http.proxyHost").toString(), Integer.parseInt(System.getProperty("http.proxyPort"))));
            }
            if ((is = (c = proxy != null ? new URL(base).openConnection(proxy) : new URL(base.replaceAll("\\\\", "/")).openConnection()).getInputStream()).read() != -1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean startsWithHttpOrFtp(String base) {
        if (base == null) {
            return false;
        }
        String lower = base.toLowerCase();
        return lower.startsWith("http://") || lower.startsWith("https://") || lower.startsWith("http:\\\\") || lower.startsWith("https:\\\\") || FileUtils.containsFile(lower) || lower.startsWith("ftp:\\\\") || lower.startsWith("ftps:\\\\") || lower.startsWith("ftps://") || lower.startsWith("ftp://");
    }

    public static boolean containsFile(String inFile) {
        String stub;
        boolean retVal = false;
        if (inFile.indexOf(":") > 1 && (stub = inFile.substring(0, inFile.indexOf(":"))).endsWith("file") && stub.indexOf("/") == -1 && stub.indexOf("\\") == -1) {
            retVal = true;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean haveIBytesRaw(String base) {
        if (!FileUtils.startsWithHttpOrFtp(base)) {
            return false;
        }
        InputStream is = null;
        URLConnection c = null;
        try {
            String lower = base.toLowerCase();
            if (FileUtils.containsFile(lower)) {
                base = base.substring(lower.indexOf("file:"));
            }
            if (base.indexOf("\\") != -1) {
                base.replace("/", "\\");
                c = new URL(base).openConnection();
                is = c.getInputStream();
                if (is.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (MalformedURLException e1) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e1) {
            boolean bl = false;
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static String getSQLPathString(ScriptRunnerContext ctx) {
        Object[] sources;
        String provider = null;
        if (SQLPLUS.getSqlpathProvider() != null) {
            provider = SQLPLUS.getSqlpathProvider().getSQLPATHsetting();
        }
        String pathGiven = "";
        for (Object source : sources = new Object[]{(String)ctx.getProperty("script.runner.cd_command"), FileUtils.getParent((URL)ctx.getProperty("script.runner.base.url")), System.getenv("SQLDEV_STARTUP"), FileUtils.getParent((URL)ctx.getProperty("script.runner.topbase.url")), FileUtils.getParent(FileUtils.useIfNotDirectoryOrNotFile(ctx.getLastNodeForDirNameURL())), FileUtils.useIfDirectoryOrNotFile(ctx.getLastNodeForDirNameURL()), FileUtils.getParent(FileUtils.useIfNotDirectoryOrNotFile(ctx.getLastDirNameURL())), FileUtils.useIfDirectoryOrNotFile(ctx.getLastDirNameURL()), ctx.getProperty("DBConfig.DEFAULT_PATH"), provider}) {
            if (source == null) continue;
            if (source instanceof String) {
                String val = (String)source;
                if (val.equals("")) continue;
                pathGiven = pathGiven + File.pathSeparator + (String)source;
                continue;
            }
            if (!(source instanceof URL)) continue;
            String toString = ((URL)source).toString();
            toString = FileUtils.decodeIfFile(toString);
            pathGiven = pathGiven + File.pathSeparator + toString;
        }
        if (ctx.getProperty("script.runner.jline") == null) {
            pathGiven = pathGiven + File.pathSeparator + ".";
        }
        if (pathGiven.length() > 1) {
            pathGiven = pathGiven.substring(1);
        }
        return pathGiven;
    }

    public static String[] getSQLPath(ScriptRunnerContext ctx) {
        return FileUtils.getSQLPathString(ctx).split(File.pathSeparator);
    }

    public static String getCWD(ScriptRunnerContext ctx) {
        String[] paths = FileUtils.getSQLPath(ctx);
        if (paths.length > 0) {
            return paths[0];
        }
        return Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
    }

    public static Path getFileOnSQLPATH(ScriptRunnerContext ctx, String filename, boolean firstFileFound) {
        GetFilenameVisitor gfnv;
        if (ctx == null) {
            ctx = new ScriptRunnerContext();
        }
        if (filename != null && filename.length() > 0 && (gfnv = FileUtils.populateSQLPATHFileList(ctx, filename, firstFileFound)).hasFiles()) {
            return gfnv.getFiles().get(0);
        }
        return null;
    }

    public static Path[] getFilesOnSQLPATH(ScriptRunnerContext ctx, String filename) {
        GetFilenameVisitor gfnv;
        if (ctx == null) {
            ctx = new ScriptRunnerContext();
        }
        if (filename != null && filename.length() > 0 && (gfnv = FileUtils.populateSQLPATHFileList(ctx, filename, false)).hasFiles()) {
            HashSet<Path> e = new HashSet<Path>();
            e.addAll(gfnv.getFiles());
            ArrayList<Path> alp = new ArrayList<Path>();
            alp.addAll(e);
            return alp.toArray(new Path[alp.size()]);
        }
        return null;
    }

    private static GetFilenameVisitor populateSQLPATHFileList(ScriptRunnerContext ctx, String filename, boolean firstFileFound) {
        GetFilenameVisitor gfnv = new GetFilenameVisitor(filename, firstFileFound);
        ArrayList<Path> pathlist = new ArrayList<Path>();
        if (FileUtils.findFileOnSQLPATH(ctx, filename, firstFileFound)) {
            String[] paths = FileUtils.getSQLPath(ctx);
            gfnv.getFiles().clear();
            for (String path : paths) {
                if (path.trim().equalsIgnoreCase(".")) continue;
                try {
                    Files.walkFileTree(Paths.get(path, new String[0]), gfnv);
                    ArrayList<Path> p = new ArrayList<Path>(gfnv.getFiles());
                    pathlist.addAll(p);
                    gfnv.getFiles().clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            gfnv.setFiles(pathlist);
        }
        return gfnv;
    }

    public static boolean findFileOnSQLPATH(ScriptRunnerContext ctx, String filename, boolean firstFileFound) {
        String[] paths = FileUtils.getSQLPath(ctx);
        GetFilenameVisitor gfnv = new GetFilenameVisitor(filename, firstFileFound);
        gfnv.getFiles().clear();
        for (String path : paths) {
            try {
                if (path.trim().equalsIgnoreCase(".")) continue;
                Files.walkFileTree(Paths.get(path, new String[0]), gfnv);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return gfnv.hasFiles();
    }

    public static URL getParent(URL inURL) {
        URL retVal = null;
        if (inURL == null) {
            return null;
        }
        try {
            URI uri = inURL.toURI();
            String resolve = ".";
            if (uri.getPath().endsWith("/") || uri.getPath().endsWith("\\")) {
                resolve = "..";
            }
            URI parent = uri.resolve(resolve);
            retVal = parent.toURL();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return retVal;
    }

    public static String getDirFromFileURL(URL inURL) throws IOException {
        if (inURL == null) {
            return null;
        }
        String pathname = null;
        File file = null;
        try {
            file = new File(inURL.getFile());
            pathname = file.getCanonicalPath();
            if (!file.isDirectory()) {
                if (!file.exists() || pathname.indexOf(File.separator) == -1) {
                    throw new IOException(Messages.getString("ScriptRunnerContext.14") + pathname);
                }
                pathname = pathname.substring(0, pathname.lastIndexOf(File.separator));
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return pathname;
    }

    static URL useIfDirectoryOrNotFile(URL inURL) {
        if (inURL == null) {
            return null;
        }
        if (inURL.getProtocol() == null || !inURL.getProtocol().toLowerCase().endsWith("file")) {
            return inURL;
        }
        try {
            if (new File(inURL.getFile()).isDirectory()) {
                return inURL;
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static URL useIfNotDirectoryOrNotFile(URL inURL) {
        if (inURL == null) {
            return null;
        }
        if (inURL.getProtocol() == null || !inURL.getProtocol().toLowerCase().endsWith("file")) {
            return inURL;
        }
        try {
            if (new File(inURL.getFile()).isDirectory()) {
                return null;
            }
            return inURL;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static String decodeIfFile(String sourceRef) {
        if (sourceRef != null && !sourceRef.equals("") && FileUtils.containsFile(sourceRef)) {
            try {
                String toString = null;
                try {
                    toString = new URL(sourceRef).toURI().getPath();
                }
                catch (URISyntaxException e) {
                    Logger.fine(FileUtils.class, e);
                }
                catch (MalformedURLException e) {
                    Logger.fine(FileUtils.class, e);
                }
                if (toString == null && (toString = URLDecoder.decode(sourceRef, "UTF-8")) != null) {
                    int theIndex = toString.indexOf(":");
                    toString = theIndex != -1 && toString.length() > theIndex + 1 ? toString.substring(theIndex + 1) : null;
                }
                if (toString != null) {
                    if (toString.replace('\\', '/').startsWith("//") && toString.length() > 2) {
                        toString = toString.substring(2);
                    }
                    if (System.getProperty("os.name").startsWith("Windows") && (toString.startsWith("/") || toString.startsWith("\\")) && toString.length() > 3 && toString.substring(2, 3).equals(":")) {
                        toString = toString.substring(1).replace("/", "\\");
                    }
                    sourceRef = toString;
                }
            }
            catch (UnsupportedEncodingException e) {
                Logger.warn(FileUtils.class, e);
            }
        }
        return sourceRef;
    }

    public static String getUserHome() {
        String storage = System.getProperty("user.home") + File.separator + ".sqlcl";
        if (PlatformUtils.isWindows()) {
            String appData = System.getenv("APPDATA");
            storage = appData != null ? appData + File.separator + "sqlcl" : null;
        }
        return storage;
    }

    public static boolean isFileOnCWD(File file, ScriptRunnerContext ctx) {
        String cwd = FileUtils.getCWD(ctx);
        String filedir = file.getParentFile().getAbsolutePath();
        if (filedir.indexOf(46) != -1) {
            filedir = filedir.replaceAll("\\.+$", "");
        }
        return filedir.equals(cwd);
    }

    public static boolean isFileOnSQLPATH(File file, ScriptRunnerContext ctx) {
        String fileDir = "";
        try {
            if (file == null) {
                return false;
            }
            fileDir = file.isFile() ? file.getParentFile().getCanonicalFile().getAbsolutePath() : file.getCanonicalFile().getAbsolutePath();
        }
        catch (Exception e) {
            return false;
        }
        String sqlpath = SQLPLUS.getSqlpathProvider().getSQLPATHsetting();
        if (sqlpath != null) {
            String[] paths;
            for (String path : paths = sqlpath.split(File.pathSeparator)) {
                if (path.equals(".")) continue;
                File fileDirfile = new File(fileDir);
                File pathDir = new File(path);
                if (!pathDir.getAbsolutePath().equals(fileDirfile.getAbsolutePath())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCWDonSQLPATH(ScriptRunnerContext ctx) {
        try {
            String[] sqlpath;
            File afile = new File(FileUtils.getCWD(ctx));
            String cwd = afile.getCanonicalFile().getAbsolutePath();
            for (String s : sqlpath = FileUtils.getSQLPath(ctx)) {
                if (s.equals(".")) continue;
                File a = new File(s);
                String s2 = a.getCanonicalFile().getAbsolutePath();
                return s2.equals(cwd);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSQLPATHSet() {
        if (SQLPLUS.getSqlpathProvider() != null) {
            return SQLPLUS.getSqlpathProvider().getSQLPATHsetting() != null;
        }
        return System.getenv("SQLPATH") != null;
    }

    public static void main(String[] args) {
        SQLPLUS.setSqlpathProvider(new SQLPlusProviderForSQLPATH());
        System.out.println(FileUtils.isSQLPATHSet());
        System.out.println("CWD:" + FileUtils.getCWD(new ScriptRunnerContext()));
        System.out.println("CWD:" + new File(FileUtils.getCWD(new ScriptRunnerContext())).getAbsolutePath());
        System.out.println("SQLPATH:" + FileUtils.getSQLPathString(new ScriptRunnerContext()));
        System.out.println(FileUtils.isCWDonSQLPATH(new ScriptRunnerContext()));
        File file = new File("/private/tmp/login.sql");
        System.out.println("isFileOnCWD:" + FileUtils.isFileOnCWD(file, new ScriptRunnerContext()));
        System.out.println("isFileOnSQLPATH:" + FileUtils.isFileOnSQLPATH(file, new ScriptRunnerContext()));
    }

    static class GetFilenameVisitor
    extends SimpleFileVisitor<Path> {
        private String _filename = "";
        private ArrayList<Path> files = new ArrayList();
        private boolean _onlyOne = false;

        public GetFilenameVisitor(String filename, boolean onefile) {
            this._filename = filename;
            this._onlyOne = onefile;
        }

        public void setFiles(ArrayList<Path> pathlist) {
            this.files = pathlist;
        }

        public ArrayList<Path> getFiles() {
            return this.files;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            if (attr.isDirectory()) {
                return FileVisitResult.CONTINUE;
            }
            if (attr.isSymbolicLink()) {
                return FileVisitResult.CONTINUE;
            }
            if (attr.isRegularFile() && file.getFileName().toString().equalsIgnoreCase(this._filename)) {
                this.files.add(file);
                if (this._onlyOne) {
                    return FileVisitResult.TERMINATE;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        public boolean hasFiles() {
            return this.files != null && this.files.size() > 0;
        }

        public void reverseFileOrder() {
            Collections.reverse(this.files);
        }
    }
}

