/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.ConnectionFactory;
import oracle.dbtools.connections.NameExistsException;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.StorageManager;
import oracle.dbtools.util.Logger;

public class Storage<T> {
    private final String mType;
    private final ArrayNode mData;
    private final Map<String, Object> mEnv;
    private final StorageManager.ChangeProcessor mChangeProcessor;

    static <T> Storage<T> createStorage(String type, StorageManager storageMgr) {
        return new Storage<T>(type, storageMgr.getStorageData(type), storageMgr.getChangeProcessor(), storageMgr.getEnv());
    }

    Storage(String type, ArrayNode data, StorageManager.ChangeProcessor cp, Map<String, Object> env) {
        this.mType = type;
        this.mData = data;
        this.mEnv = env;
        this.mChangeProcessor = cp;
    }

    public String getType() {
        return this.mType;
    }

    public String[] listConnections() {
        String[] names = new String[this.mData.size()];
        int count = 0;
        for (JsonNode conn : this.mData) {
            String name;
            JsonNode typeNode;
            if (conn == null || !conn.isObject() || !this.valueMatches(typeNode = conn.get("type"), this.mType) || (name = this.getValue(conn.get("name"))) == null) continue;
            names[count++] = name;
        }
        if (count < names.length) {
            String[] tmp = names;
            names = new String[count];
            System.arraycopy(tmp, 0, names, 0, count);
        }
        return names;
    }

    public T getConnection(String name, ConnectionFactory<T> factory) throws StorageException {
        ObjectNode data = this.findConnectionEntry(name);
        return data != null ? (T)this.createConnection(name, factory, data.get("info")) : null;
    }

    private T createConnection(String name, ConnectionFactory<T> factory, JsonNode data) {
        T result = null;
        if (data != null && data.isObject()) {
            try {
                Reference ref = this.convertFromJson(factory.getConnectionClass().getName(), factory.getClass().getName(), (ObjectNode)data);
                result = factory.createObject(name, ref, this.mEnv);
            }
            catch (StorageException e) {
                Logger.severe(Storage.class, e);
            }
        }
        return result;
    }

    private ObjectNode findConnectionEntry(String name) {
        ObjectNode entry = null;
        for (JsonNode conn : this.mData) {
            if (conn == null || !conn.isObject() || !this.valueMatches(conn.get("type"), this.mType) || !this.valueMatches(conn.get("name"), name)) continue;
            entry = (ObjectNode)conn;
        }
        return entry;
    }

    public void addConnection(String name, Referenceable connectionData) throws StorageException {
        if (this.findConnectionEntry(name) != null) {
            throw new NameExistsException(name, this.mType);
        }
        this.addConnectionImpl(name, connectionData);
    }

    private void addConnectionImpl(String name, Referenceable connectionData) throws StorageException {
        ObjectNode conn = this.mData.addObject();
        conn.put("name", name);
        conn.put("type", this.mType);
        ObjectNode data = this.convertToJson(connectionData);
        conn.set("info", (JsonNode)data);
        this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.ADD);
    }

    public boolean removeConnection(String name) throws StorageException {
        boolean removed = false;
        Iterator iter = this.mData.elements();
        while (iter.hasNext()) {
            JsonNode conn = (JsonNode)iter.next();
            if (conn == null || !conn.isObject() || !this.valueMatches(conn.get("type"), this.mType) || !this.valueMatches(conn.get("name"), name)) continue;
            iter.remove();
            removed = true;
            break;
        }
        if (removed) {
            this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.REMOVE);
        }
        return removed;
    }

    public void updateConnection(String name, Referenceable connectionData) throws StorageException {
        ObjectNode conn = this.findConnectionEntry(name);
        if (conn == null) {
            this.addConnectionImpl(name, connectionData);
        } else {
            ObjectNode data = this.convertToJson(connectionData);
            conn.set("info", (JsonNode)data);
            this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.UPDATE);
        }
    }

    public void updateConnection(String oldName, String newName, Referenceable connectionData) throws StorageException {
        ObjectNode conn = this.findConnectionEntry(oldName);
        if (conn == null) {
            this.addConnectionImpl(newName, connectionData);
        } else {
            if (this.findConnectionEntry(newName) != null) {
                throw new NameExistsException(newName, this.mType);
            }
            conn.put("name", newName);
            ObjectNode data = this.convertToJson(connectionData);
            conn.set("info", (JsonNode)data);
            this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.UPDATE);
        }
    }

    public void renameConnection(String oldName, String newName) throws StorageException {
        ObjectNode conn = this.findConnectionEntry(oldName);
        if (conn != null) {
            if (this.findConnectionEntry(newName) != null) {
                throw new NameExistsException(newName, this.mType);
            }
            conn.set("name", (JsonNode)conn.textNode(newName));
            this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.UPDATE);
        }
    }

    private boolean valueMatches(JsonNode node, String value) {
        return ModelUtil.areEqual(this.getValue(node), value);
    }

    private String getValue(JsonNode node) {
        return node != null && node.isTextual() ? node.asText() : null;
    }

    private ObjectNode convertToJson(Referenceable connection) throws StorageException {
        ObjectNode data = this.mData.objectNode();
        try {
            Reference ref = connection.getReference();
            if (ref != null) {
                Enumeration<RefAddr> e = ref.getAll();
                while (e.hasMoreElements()) {
                    RefAddr addr = e.nextElement();
                    String key = addr.getType();
                    if (addr instanceof StringRefAddr) {
                        String value = (String)addr.getContent();
                        data.put(key, value);
                        continue;
                    }
                    Logger.warn(Storage.class, "Unsupported reference address: (" + key + ", " + addr.getClass() + ")");
                }
            }
        }
        catch (NamingException ne) {
            Logger.severe(Storage.class, ne);
            throw new StorageException(ne);
        }
        return data;
    }

    private Reference convertFromJson(String connCls, String factoryCls, ObjectNode node) {
        Reference ref = new Reference(connCls, factoryCls, null);
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String key = (String)field.getKey();
            JsonNode data = (JsonNode)field.getValue();
            if (data.isValueNode()) {
                ref.add(new StringRefAddr(key, data.asText()));
                continue;
            }
            Logger.warn(Storage.class, "Unsupported JSON node type found for " + key);
        }
        return ref;
    }
}

