/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.connections.ConnectionsResources;
import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.util.Logger;

public final class StorageManager {
    public static final String DEFAULT_CONNECTIONS_FILENAME = "connections.json";
    private static final String CONNECTIONS_PROPERTY = "connections";
    static final String NAME_PROPERTY = "name";
    static final String TYPE_PROPERTY = "type";
    static final String INFO_PROPERTY = "info";
    private static final ObjectMapper sMapper = new ObjectMapper();
    private static final ChangeProcessor NCP = new ChangeProcessor(){

        @Override
        public void processChange(ChangeProcessor.Change change) {
        }
    };
    private final Location mLocation;
    private final ObjectNode mRoot;
    private final Map<String, Object> mEnvironment;
    private final ChangeProcessor mChangeProcessor;

    public static Builder builder() {
        return new Builder();
    }

    static ObjectMapper getMapper() {
        return sMapper;
    }

    private StorageManager(Location location, ObjectNode root, boolean autoSave, Map<String, Object> env) {
        this.mLocation = location;
        this.mRoot = root;
        this.mEnvironment = Collections.unmodifiableMap(env);
        this.mChangeProcessor = autoSave ? new ChangeProcessor(){

            @Override
            public void processChange(ChangeProcessor.Change change) throws StorageException {
                StorageManager.this.save();
            }
        } : NCP;
    }

    private static ObjectNode getRoot(Location location) throws StorageException {
        ObjectNode root = null;
        if (location == null) {
            Logger.warn(StorageManager.class, "StorageManager created with null location");
            root = sMapper.createObjectNode();
        } else {
            try {
                if (location.exists()) {
                    root = sMapper.readTree(location.getInputStream());
                }
                if (root == null) {
                    root = sMapper.createObjectNode();
                }
            }
            catch (IOException e) {
                Logger.severe(StorageManager.class, "Unexpected error encountered loading " + location, e);
                throw new StorageException(e);
            }
        }
        if (!root.isObject()) {
            Logger.severe(StorageManager.class, "Unexpected JSON format found at " + location + "; " + root);
            throw new StorageException(ConnectionsResources.format("ERROR_UNEXPECTED_FORMAT", location));
        }
        return root;
    }

    public void save() throws StorageException {
        this.saveImpl(this.mLocation);
    }

    public void saveAs(Location location) throws StorageException {
        this.saveImpl(location);
    }

    public <T> Storage<T> getStorage(String type) {
        return Storage.createStorage(type, this);
    }

    private void saveImpl(Location location) throws StorageException {
        if (location == null) {
            Logger.warn(StorageManager.class, "Attempt to save to null location");
            throw new StorageException("Storage location is null");
        }
        JsonFactory factory = sMapper.getFactory();
        try (OutputStream os = location.getOutputStream();){
            JsonGenerator generator = factory.createGenerator(os);
            sMapper.writeTree(generator, (JsonNode)this.mRoot);
        }
        catch (IOException e) {
            Logger.severe(StorageManager.class, e);
            throw new StorageException(e);
        }
    }

    ArrayNode getStorageData(String connType) {
        JsonNode node = this.mRoot.get(CONNECTIONS_PROPERTY);
        if (node == null) {
            node = sMapper.createArrayNode();
            this.mRoot.set(CONNECTIONS_PROPERTY, node);
        }
        if (!node.isArray()) {
            Logger.severe(StorageManager.class, "Unexpected JSON format found at " + this.mLocation + "; " + node);
            node = sMapper.createArrayNode();
        }
        ArrayNode connections = (ArrayNode)node;
        return connections;
    }

    Map<String, Object> getEnv() {
        return this.mEnvironment;
    }

    ChangeProcessor getChangeProcessor() {
        return this.mChangeProcessor;
    }

    public static class Builder {
        private Location mLocation;
        private ObjectNode mRoot;
        private Map<String, Object> mEnv;
        private boolean mAutosave;

        Builder() {
        }

        public Builder addEnvValue(String key, Object value) {
            if (this.mEnv == null) {
                this.mEnv = new HashMap<String, Object>();
            }
            this.mEnv.put(key, value);
            return this;
        }

        public Builder location(Location location) throws StorageException {
            this.mLocation = location;
            this.mRoot = StorageManager.getRoot(this.mLocation);
            return this;
        }

        public Builder autosave(boolean autosave) {
            this.mAutosave = autosave;
            return this;
        }

        public StorageManager build() {
            ObjectNode root = this.mRoot != null ? this.mRoot : sMapper.createObjectNode();
            return new StorageManager(this.mLocation, root, this.mAutosave, this.mEnv != null ? this.mEnv : Collections.emptyMap());
        }
    }

    static interface ChangeProcessor {
        public void processChange(Change var1) throws StorageException;

        public static enum Change {
            ADD,
            REMOVE,
            UPDATE;

        }
    }
}

