/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.data.model.Baseable;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.Table;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.jdbc.OraclePreparedStatement;

public class GenericTable
implements Baseable {
    protected Table _table;
    protected String _schemaName;

    public GenericTable(Connection conn, String schemaName, String tableName) {
        this.populateTable(conn, schemaName, tableName);
    }

    public GenericTable(Table inTable) {
        this._table = inTable;
    }

    public GenericTable() {
        this._table = new Table();
    }

    private void populateTable(Connection conn, String schemaName, String tableName) {
        this._table = this.getMetaData(conn, schemaName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table getMetaData(Connection conn, String schemaName, String tableName) {
        Table table = null;
        ArrayList<Column> columns = new ArrayList<Column>();
        if (LockManager.lock(conn)) {
            try {
                PreparedStatement pstmt;
                ResultSetMetaData m_meta;
                String sql = "";
                String[] qName = tableName.split("@");
                String tName = DBUtil.addDoubleQuote(qName[0]);
                if (qName.length > 1) {
                    tName = tName + "@" + qName[1];
                }
                if ((m_meta = (pstmt = this.getPreparedStatement(conn, sql = schemaName != null && schemaName.length() > 0 ? "select * from " + DBUtil.addDoubleQuote(schemaName) + "." + tName + " where 1 = 2" : "select * from " + tName + " where 1 = 2")).getMetaData()) != null) {
                    int colCount = m_meta.getColumnCount();
                    for (int i = 0; i < colCount; ++i) {
                        Column column = new Column();
                        column.setName(m_meta.getColumnName(i + 1));
                        column.setNullable(m_meta.isNullable(i + 1) == 1);
                        column.setType(m_meta.getColumnTypeName(i + 1));
                        column.setPrecision(m_meta.getPrecision(i + 1));
                        column.setScale(m_meta.getScale(i + 1));
                        columns.add(column);
                    }
                    table = new Table();
                    table.setTablename(tableName);
                    table.setColumns(columns);
                }
            }
            catch (Exception e) {
                boolean bl = true;
            }
            finally {
                LockManager.unlock(conn);
            }
        }
        return table;
    }

    protected PreparedStatement getPreparedStatement(Connection conn, String sql) throws SQLException {
        return (OraclePreparedStatement)conn.prepareStatement(sql);
    }

    public static void main(String[] args) {
    }

    @Override
    public void addColumn(Column column) {
        this._table.addColumn(column);
    }

    @Override
    public Column getColumn(int number) {
        return this.getColumns()[number];
    }

    @Override
    public Column[] getColumns() {
        return this._table.getColumns().toArray(new Column[this._table.getColumns().size()]);
    }

    @Override
    public String getDataType(Column column) {
        return column.getType();
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    @Override
    public void setColumns(Column[] columns) {
        List<Column> cols = this._table.getColumns();
        if (cols != null) {
            cols.clear();
            for (int i = 0; i < columns.length; ++i) {
                cols.add(columns[i]);
            }
            this._table.setColumns(cols.toArray(new Column[cols.size()]));
        }
    }

    @Override
    public void setTableName(String name) {
        this._table.setTablename(name);
    }

    private boolean isExistsTable(Connection conn, boolean isDba, String owner, String name) {
        if (conn == null) {
            return false;
        }
        HashMap binds = new HashMap();
        String object = "";
        String query = "select count(1) from ";
        if (owner != null && owner.length() > 0) {
            query = query + owner + ".";
        }
        query = query + name + " where rownum =0";
        String ret = DBUtil.getInstance(conn).executeOracleReturnOneCol(query, binds);
        return ret != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isExistsTableSave(Connection conn, boolean isDba, String owner, String name) {
        if (conn == null) {
            return false;
        }
        String EXIST_OBJECT = " select 1 from " + (isDba ? "dba_objects" : "all_objects") + " where owner = :OWNER  and object_type = 'TABLE'  and object_name = :NAME ";
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        binds.put("OWNER", owner);
        binds.put("NAME", name);
        if (LockManager.lock(conn)) {
            block6: {
                boolean bl;
                try {
                    rset = DBUtil.getInstance(conn).executeQuery(EXIST_OBJECT, binds);
                    if (!rset.next()) break block6;
                    bl = true;
                }
                catch (Exception exception) {
                    DBUtil.closeResultSet(rset);
                    LockManager.unlock(conn);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(rset);
                        LockManager.unlock(conn);
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet(rset);
                LockManager.unlock(conn);
                return bl;
            }
            DBUtil.closeResultSet(rset);
            LockManager.unlock(conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList<Column> getColumnsSave(Connection conn, String owner, String tableName) {
        ArrayList<Column> columns = new ArrayList<Column>();
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        binds.put("OWNER", owner);
        binds.put("TAB", tableName);
        String COLUMN_OBJECT = "select column_name, nullable from all_tab_cols where table_name = :TAB and owner = :OWNER ORDER BY COLUMN_ID";
        if (LockManager.lock(conn)) {
            try {
                rset = DBUtil.getInstance(conn).executeQuery(COLUMN_OBJECT, binds);
                while (rset.next()) {
                    Column column = new Column();
                    column.setName(rset.getString(1));
                    column.setNullable(rset.getString(2).equals("Y"));
                    columns.add(column);
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(rset);
                LockManager.unlock(conn);
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(rset);
                    LockManager.unlock(conn);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet(rset);
            LockManager.unlock(conn);
        }
        return columns;
    }
}

