/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.model;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.model.LoadField;

public class LoadFile {
    private List<LoadField> _fields;
    private String _name;
    private String _shortName;
    private String _canonicalName;
    private String _type;

    public LoadFile() {
        this._fields = new ArrayList<LoadField>();
        this._type = "csv";
    }

    public LoadFile(String name) {
        this.setName(name);
        this._fields = new ArrayList<LoadField>();
    }

    public void addField(LoadField field) {
        if (field != null) {
            this._fields.add(field);
        }
    }

    public List<LoadField> getFields() {
        return this._fields;
    }

    public int getFieldCount() {
        return this._fields.size();
    }

    private void setFields(List<LoadField> fields) {
        this._fields = fields;
    }

    public void setFields(LoadField[] fields) {
        ArrayList<LoadField> list = new ArrayList<LoadField>();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null) continue;
            list.add(fields[i]);
        }
        this.setFields(list);
    }

    public String getName() {
        return this._name;
    }

    public URL getURL() {
        try {
            return new File(this._name).toURI().toURL();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
    }

    public String getShortName() {
        return this._shortName;
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    public void setName(String fileName) {
        this._name = fileName;
        try {
            this._canonicalName = new File(this._name).getCanonicalPath();
            this._type = this._name.substring(this._name.lastIndexOf(".", this._name.length()) + 1);
            this._shortName = new File(this._name).getName();
            if (this._shortName.lastIndexOf(".") > -1) {
                this._shortName = this._shortName.substring(0, this._shortName.lastIndexOf("."));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public String getType() {
        return this._type;
    }

    public LoadField getField(int fieldIndex) {
        if (fieldIndex < this._fields.size()) {
            return this._fields.get(fieldIndex);
        }
        return null;
    }

    public LoadField getFieldByName(String name) {
        for (LoadField field : this._fields) {
            if (!name.trim().equals(field.getName().trim())) continue;
            return field;
        }
        return null;
    }

    public LoadField getFirstField() {
        Iterator<LoadField> it = this._fields.iterator();
        if (it.hasNext()) {
            LoadField field = it.next();
            return field;
        }
        return null;
    }
}

