/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.Messages;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.ResultSetFormatterWrapper;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.util.Service;
import oracle.jdbc.OracleResultSet;

public class ResultSetFormatter {
    private static final int defaultPixelFactor = 7;
    protected int spacePixelWidthMode1 = -1;
    protected int spacePixelWidthMode2 = -1;
    protected static int s_maxRows = Integer.MAX_VALUE;
    protected static int s_maxLines;
    private static FontMetrics s_fmCache;
    private boolean getFontMetricsCalled = false;
    private static boolean fontMetricsException;
    private IRaptorTaskProgressUpdater m_progressUpdater = null;
    private static Logger m_logger;
    protected ScriptRunnerContext m_scriptRunnerContext = null;
    protected ISQLCommand cmd = null;
    protected boolean cancel = false;

    public int formatResults(BufferedOutputStream out, ResultSet rset, ISQLCommand cmd) throws IOException, SQLException {
        this.cmd = cmd;
        return this.formatResults(out, rset, cmd.getSql());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int formatResults(BufferedOutputStream out, ResultSet rset, String sql) throws IOException, SQLException {
        int cnt = 0;
        List<String> types = FormatRegistry.getAllTypes();
        Boolean wasCacheNext = (Boolean)this.m_scriptRunnerContext.getProperty("sqlcl.spool.nexttrue");
        Boolean wasToSpoolOnly = (Boolean)this.m_scriptRunnerContext.getProperty("sqlcl.spool.spoolonly");
        try {
            boolean handled = false;
            String useFormat = (String)this.m_scriptRunnerContext.getProperty("sql.format");
            for (String format : types) {
                if (sql.indexOf("/*" + format + "*/") <= 0) continue;
                useFormat = format;
            }
            if (rset.getStatement() instanceof PreparedStatement && useFormat != null && !useFormat.equals("pdf") && !useFormat.equals("xls")) {
                IResultFormatter formatter = FormatRegistry.getFormatter(useFormat);
                ResultSetFormatterWrapper rsfw = new ResultSetFormatterWrapper(rset, this.getMaxRows());
                formatter.setDataProvider(rsfw);
                boolean header = this.m_scriptRunnerContext.getProperty("script.runner.setheading").toString().equals("ON");
                formatter.isHeader(header);
                String tblName = this.getTableName(sql);
                if (tblName == null) {
                    tblName = "MYTABLE";
                }
                formatter.setTableName(tblName);
                formatter.setScriptContext(this.m_scriptRunnerContext);
                formatter.setEncode("UTF-8");
                formatter.setOutWriter(null);
                formatter.setOutputStream(out);
                cnt = formatter.print();
                handled = true;
            }
            if (!handled) {
                cnt = sql.startsWith("desc") || this.cmd != null && this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DESCRIBE) ? (this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.m_scriptRunnerContext.getProperty("sqlplus.classic.mode").toString()) ? this.rset2sqlplus(rset, rset.getStatement().getConnection(), out) : this.rset2sqlplusShrinkToSize(rset, rset.getStatement().getConnection(), out)) : (sql.indexOf("/*html*/") > 0 ? this.rset2html(rset, out) : (sql.indexOf("/*csv*/") > 0 ? this.rset2csv(rset, out) : (sql.indexOf("/*xml*/") > 0 ? this.rset2xml(rset, out) : (sql.indexOf("/*json*/") > 0 ? this.rset2xml(rset, out) : this.rset2sqlplus(rset, rset.getStatement().getConnection(), out)))));
            }
        }
        finally {
            ResultSetFormatter.clearSpoolOnly(this.m_scriptRunnerContext, out, wasToSpoolOnly, wasCacheNext);
        }
        return cnt;
    }

    private String getTableName(String orig) {
        try {
            Parsed parsed = new Parsed(orig, SqlEarley.getInstance(), "sql_statement");
            ParseNode root = parsed.getRoot();
            for (ParseNode child : root.descendants()) {
                if (child.to - child.from > 4 || !child.contains(SqlEarley.getInstance().getSymbol("query_table_expression"))) continue;
                return Service.handleMixedCase(orig.substring(parsed.getSrc().get((int)child.from).begin, parsed.getSrc().get((int)(child.to - 1)).end), false);
            }
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        return null;
    }

    public void setProgressUpdater(IRaptorTaskProgressUpdater progressUpdater) {
        this.m_progressUpdater = progressUpdater;
    }

    public ResultSetFormatter() {
    }

    public ResultSetFormatter(ScriptRunnerContext inScriptRunnerContext) {
        this.m_scriptRunnerContext = inScriptRunnerContext;
    }

    protected static synchronized int getPixelSize(String theString, int mode) {
        FontMetrics fm = ResultSetFormatter.getFontMetricsInternal();
        if (fontMetricsException) {
            return 7 * theString.length();
        }
        if (mode == 1) {
            return fm.stringWidth(theString);
        }
        if (mode == 2) {
            return SwingUtilities.computeStringWidth(fm, theString);
        }
        Logger.getLogger(ResultSetFormatter.class.getName()).log(Level.WARNING, "GETFONTMETRICS INCORRECT MODE", new Exception());
        return 7 * theString.length();
    }

    protected void getFontMetrics() {
        if (!this.getFontMetricsCalled) {
            ResultSetFormatter.getFontMetricsInternal();
            this.getFontMetricsCalled = true;
        }
    }

    private static synchronized FontMetrics getFontMetricsInternal() {
        if (s_fmCache == null && !fontMetricsException) {
            try {
                Font font = new Font("Monospaced", 0, 12);
                s_fmCache = Toolkit.getDefaultToolkit().getFontMetrics(font);
            }
            catch (Exception e) {
                Logger.getLogger(ResultSetFormatter.class.getName()).log(Level.WARNING, "GETFONTMETRICS ERROR", e);
                fontMetricsException = true;
            }
        }
        return s_fmCache;
    }

    public static void setMaxRows(int maxRows) {
        s_maxRows = maxRows;
    }

    protected int getMaxRows() {
        return ResultSetFormatter.getMaxRows(this.m_scriptRunnerContext);
    }

    protected static int getMaxRows(ScriptRunnerContext ctx) {
        if (ctx == null) {
            return s_maxRows;
        }
        Integer ctxRows = (Integer)ctx.getProperty("sqlcl.script.maxrows");
        if (ctxRows == null) {
            return s_maxRows;
        }
        return ctxRows;
    }

    public int rset2sqlplus(ResultSet rset, Connection conn, BufferedOutputStream out) throws IOException, SQLException {
        int cnt = 0;
        cnt = this.rset2sqlplus(rset, conn, (Object)out);
        return cnt;
    }

    public int rset2sqlplusShrinkToSize(ResultSet rset, Connection conn, BufferedOutputStream out) throws IOException, SQLException {
        int cnt = 0;
        StringBuffer buf = new StringBuffer();
        cnt = this.rset2sqlplusShrinkToSize(rset, conn, buf);
        out.write(buf.toString().getBytes(this.m_scriptRunnerContext.getEncoding()));
        return cnt;
    }

    public int rset2sqlplus(ResultSet rset, Connection conn, Object out) throws IOException, SQLException {
        return this.rset2sqlplus(rset, conn, out, null);
    }

    public int rset2sqlplusShrinkToSize(ResultSet rset, Connection conn, StringBuffer out) throws IOException, SQLException {
        return this.rset2sqlplusShrinkToSize(rset, conn, out, null);
    }

    public int rset2sqlplusShrinkToSize(ResultSet rset, Connection conn, StringBuffer buf, StringBuffer errbuf) throws IOException, SQLException {
        int i;
        int cnt = 0;
        ResultSetMetaData rmeta = rset.getMetaData();
        int colCnt = rmeta.getColumnCount();
        int[] colsizes = new int[colCnt + 1];
        StringBuffer header = new StringBuffer();
        StringBuffer headerLine = new StringBuffer();
        String[] columns = new String[colCnt + 1];
        String[] lastVal = null;
        boolean newVal = this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getColumnMap() != null && this.m_scriptRunnerContext.getColumnMap().size() > 0;
        int[] displaySizeArray = new int[colCnt + 1];
        int[] columnTypeArray = new int[colCnt + 1];
        String[] columnNameArray = new String[colCnt + 1];
        int[] sizeSoFar = new int[colCnt + 1];
        ArrayList<StringBuffer[]> cacheAllRows = new ArrayList<StringBuffer[]>();
        for (i = 1; i < colCnt + 1; ++i) {
            displaySizeArray[i] = rmeta.getColumnDisplaySize(i);
            columnTypeArray[i] = rmeta.getColumnType(i);
            columnNameArray[i] = rmeta.getColumnName(i);
            sizeSoFar[i] = 0;
        }
        block3: while (rset.next() && cnt < this.getMaxRows()) {
            StringBuffer[] sb = new StringBuffer[colCnt + 1];
            ++cnt;
            for (int i2 = 1; i2 < colCnt + 1; ++i2) {
                String setNull;
                this.checkCanProceed();
                if (this.cancel) break block3;
                Object o = null;
                if (rset instanceof OracleResultSet) {
                    try {
                        o = ((OracleResultSet)rset).getOracleObject(i2);
                    }
                    catch (SQLException e) {
                        o = rset.getObject(i2);
                    }
                } else {
                    o = rset.getObject(i2);
                }
                if (this.m_scriptRunnerContext != null && o == null && (setNull = (String)this.m_scriptRunnerContext.getProperty("script.runner.setnull")) != null && !setNull.equals("")) {
                    o = setNull;
                }
                String s = DataTypesUtil.stringValue(o, conn);
                StringBuffer nlsed = new StringBuffer();
                if (s != null) {
                    nlsed = new StringBuffer(DataTypesUtil.stringValue(s, rset.getStatement().getConnection()).replace("\r\n", "\n"));
                }
                if (nlsed.length() > sizeSoFar[i2]) {
                    sizeSoFar[i2] = nlsed.length();
                }
                sb[i2] = nlsed;
            }
            cacheAllRows.add(sb);
        }
        for (i = 1; i < colCnt + 1; ++i) {
            int j;
            this.checkCanProceed();
            if (this.cancel) break;
            int displaySize = sizeSoFar[i];
            if (displaySize > 4000 || displaySize < 0) {
                displaySize = 4000;
            }
            colsizes[i] = columnTypeArray[i] == 91 || columnTypeArray[i] == 92 || columnTypeArray[i] == 93 ? 25 : (displaySize < columnNameArray[i].length() ? columnNameArray[i].length() : displaySize);
            columns[i] = columnNameArray[i];
            header.append(columns[i]);
            int jj = colsizes[i] - columnNameArray[i].length();
            for (j = 0; j < jj; ++j) {
                header.append(" ");
            }
            jj = colsizes[i];
            for (j = 0; j < jj; ++j) {
                headerLine.append("-");
            }
            header.append(" ");
            headerLine.append(" ");
        }
        buf.append(header.toString());
        buf.append("\n");
        buf.append(headerLine.toString());
        buf.append("\n");
        for (StringBuffer[] rowSb : cacheAllRows) {
            this.checkCanProceed();
            if (this.cancel) break;
            ArrayList<StringBuffer> cacheRow = new ArrayList<StringBuffer>();
            for (int i3 = 0; i3 < colCnt + 1; ++i3) {
                cacheRow.add(rowSb[i3]);
            }
            boolean multiline = false;
            boolean stopit = false;
            int spacePixelWidth = -1;
            if (this.spacePixelWidthMode1 == -1) {
                this.spacePixelWidthMode1 = ResultSetFormatter.getPixelSize(" ", 1);
            }
            spacePixelWidth = this.spacePixelWidthMode1;
            while (!stopit) {
                stopit = true;
                for (int i4 = 1; i4 < colCnt + 1; ++i4) {
                    int pixelWidth;
                    StringBuffer nextChunk = (StringBuffer)cacheRow.get(i4);
                    int ival = nextChunk.indexOf("\n");
                    if (ival != -1) {
                        multiline = true;
                        StringBuffer store = nextChunk;
                        nextChunk = new StringBuffer(nextChunk.substring(0, ival));
                        store = store.length() - 1 > ival ? new StringBuffer(store.substring(ival + 1)) : new StringBuffer("");
                        cacheRow.set(i4, store);
                        stopit = false;
                    } else {
                        cacheRow.set(i4, new StringBuffer(""));
                    }
                    if (this.m_scriptRunnerContext != null && newVal) {
                        if (lastVal == null) {
                            lastVal = new String[colCnt + 1];
                        }
                        lastVal[i4] = ((StringBuffer)cacheRow.get(i4)).toString();
                    }
                    if ((pixelWidth = ResultSetFormatter.getPixelSize(nextChunk.toString(), 1)) < colsizes[i4] * spacePixelWidth) {
                        int pixelsRequired = colsizes[i4] * spacePixelWidth - pixelWidth;
                        int spacesRequired = pixelsRequired / spacePixelWidth;
                        for (int j = 0; j < spacesRequired; ++j) {
                            nextChunk.append(" ");
                        }
                    }
                    nextChunk.append(" ");
                    buf.append(nextChunk.toString());
                }
                buf.append("\n");
            }
            if (!multiline) continue;
            buf.append("\n");
        }
        if (cnt == this.getMaxRows() && rset.next()) {
            if (errbuf == null) {
                this.logMaxReached(buf);
            } else {
                ResultSetFormatter.logMaxReached(errbuf, this.m_scriptRunnerContext);
            }
        }
        if (this.m_scriptRunnerContext != null && newVal) {
            if (cnt == 0) {
                this.m_scriptRunnerContext.updateColumn(columns, null, null);
            } else {
                this.m_scriptRunnerContext.updateColumn(columns, lastVal, null);
            }
        }
        return cnt;
    }

    public int rset2sqlplus(ResultSet rset, Connection conn, Object out, StringBuffer errbuf) throws IOException, SQLException {
        int cnt = 0;
        ResultSetMetaData rmeta = rset.getMetaData();
        int colCnt = rmeta.getColumnCount();
        int[] colsizes = new int[colCnt + 1];
        StringBuffer header = new StringBuffer();
        StringBuffer headerLine = new StringBuffer();
        String[] columns = new String[colCnt + 1];
        String[] lastVal = null;
        boolean newVal = this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getColumnMap() != null && this.m_scriptRunnerContext.getColumnMap().size() > 0;
        for (int i = 1; i < colCnt + 1; ++i) {
            int j;
            int displaySize = rmeta.getColumnDisplaySize(i);
            if (rmeta.getColumnType(i) == -3) {
                displaySize *= 2;
            }
            if (displaySize == 0) {
                displaySize = 1;
            }
            if (displaySize > 4000 || displaySize <= 0) {
                displaySize = 4000;
            }
            colsizes[i] = rmeta.getColumnType(i) == 91 || rmeta.getColumnType(i) == 92 || rmeta.getColumnType(i) == 93 ? 25 : (displaySize < rmeta.getColumnName(i).length() ? rmeta.getColumnName(i).length() : displaySize);
            columns[i] = rmeta.getColumnName(i);
            header.append(columns[i]);
            int jj = colsizes[i] - rmeta.getColumnName(i).length();
            for (j = 0; j < jj; ++j) {
                header.append(" ");
            }
            jj = colsizes[i];
            for (j = 0; j < jj; ++j) {
                headerLine.append("-");
            }
            header.append(" ");
            headerLine.append(" ");
        }
        ArrayList<StringBuffer> cacheRow = new ArrayList<StringBuffer>();
        while (ResultSetFormatter.replaceNext(cnt, this.getMaxRows(), this.m_scriptRunnerContext, out, rset, errbuf, null) && (cnt < this.getMaxRows() || ResultSetFormatter.maxRowsSpoolOnly(this.m_scriptRunnerContext))) {
            int i;
            if (cnt == 0) {
                this.write(out, header.toString());
                this.write(out, "\n");
                this.write(out, headerLine.toString());
                this.write(out, "\n");
                for (i = 0; i < colCnt + 1; ++i) {
                    cacheRow.add(new StringBuffer());
                }
            }
            this.checkCanProceed();
            ++cnt;
            for (i = 1; i < colCnt + 1; ++i) {
                String setNull;
                Object o = null;
                if (rset instanceof OracleResultSet) {
                    try {
                        o = ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, i);
                    }
                    catch (SQLException e) {
                        o = rset.getObject(i);
                    }
                } else {
                    o = rset.getObject(i);
                }
                if (this.m_scriptRunnerContext != null && o == null && (setNull = (String)this.m_scriptRunnerContext.getProperty("script.runner.setnull")) != null && !setNull.equals("")) {
                    o = setNull;
                }
                String s = DataTypesUtil.stringValue(o, conn);
                StringBuffer nlsed = new StringBuffer();
                if (s != null) {
                    nlsed = new StringBuffer(DataTypesUtil.stringValue(s, rset.getStatement().getConnection()).replace("\r\n", "\n"));
                }
                if (this.m_scriptRunnerContext != null && newVal) {
                    if (lastVal == null) {
                        lastVal = new String[colCnt + 1];
                    }
                    lastVal[i] = nlsed.toString();
                }
                cacheRow.set(i, nlsed);
            }
            boolean multiline = false;
            boolean stopit = false;
            if (this.spacePixelWidthMode1 == -1) {
                this.spacePixelWidthMode1 = ResultSetFormatter.getPixelSize(" ", 1);
            }
            int spacePixelWidth = this.spacePixelWidthMode1;
            while (!stopit) {
                stopit = true;
                for (int i2 = 1; i2 < colCnt + 1; ++i2) {
                    StringBuffer nextChunk = (StringBuffer)cacheRow.get(i2);
                    int ival = nextChunk.indexOf("\n");
                    if (ival != -1) {
                        multiline = true;
                        StringBuffer store = nextChunk;
                        nextChunk = new StringBuffer(nextChunk.substring(0, ival));
                        store = store.length() - 1 > ival ? new StringBuffer(store.substring(ival + 1)) : new StringBuffer("");
                        cacheRow.set(i2, store);
                        stopit = false;
                    } else {
                        cacheRow.set(i2, new StringBuffer(""));
                    }
                    int pixelWidth = ResultSetFormatter.getPixelSize(nextChunk.toString(), 1);
                    if (pixelWidth < colsizes[i2] * spacePixelWidth) {
                        int pixelsRequired = colsizes[i2] * spacePixelWidth - pixelWidth;
                        int spacesRequired = pixelsRequired / spacePixelWidth;
                        for (int j = 0; j < spacesRequired; ++j) {
                            nextChunk.append(" ");
                        }
                    }
                    nextChunk.append(" ");
                    this.write(out, nextChunk.toString());
                }
                this.write(out, "\n");
            }
            if (!multiline) continue;
            this.write(out, "\n");
        }
        if (cnt == 0) {
            this.write(out, "\n");
            this.write(out, Messages.getString("ResultSetFormatter.4"));
        }
        if (!ResultSetFormatter.maxRowsSpoolOnly(this.m_scriptRunnerContext) && cnt == this.getMaxRows() && rset.next()) {
            if (errbuf == null) {
                this.logMaxReached(out);
            } else {
                ResultSetFormatter.logMaxReached(errbuf, this.m_scriptRunnerContext);
            }
        }
        if (this.m_scriptRunnerContext != null && newVal) {
            if (cnt == 0) {
                this.m_scriptRunnerContext.updateColumn(columns, null, null);
            } else {
                this.m_scriptRunnerContext.updateColumn(columns, lastVal, null);
            }
        }
        return cnt;
    }

    protected void write(Object out, String output) throws IOException {
        if (out instanceof BufferedOutputStream) {
            this.write((BufferedOutputStream)out, output);
        } else if (out instanceof StringBuffer) {
            this.write((StringBuffer)out, output);
        }
    }

    protected void write(BufferedOutputStream out, String output) throws IOException {
        try {
            out.write(output.getBytes(this.m_scriptRunnerContext.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    protected void write(StringBuffer out, String output) {
        out.append(output);
    }

    protected void checkCanProceed() {
        if (this.m_progressUpdater != null) {
            try {
                this.m_progressUpdater.checkCanProceed();
                this.cancel = false;
            }
            catch (ExecutionException e) {
                this.cancel = true;
            }
        }
    }

    public int rset2csv(ResultSet rset, BufferedOutputStream out) throws IOException, SQLException {
        int cnt = 0;
        ResultSetMetaData rmeta = rset.getMetaData();
        int colCnt = rmeta.getColumnCount();
        while (ResultSetFormatter.replaceNext(cnt, this.getMaxRows(), this.m_scriptRunnerContext, out, rset, null, null) && (cnt < this.getMaxRows() || ResultSetFormatter.maxRowsSpoolOnly(this.m_scriptRunnerContext))) {
            ++cnt;
            for (int i = 0; i < colCnt; ++i) {
                if (rset.getString(i + 1) != null) {
                    out.write(34);
                    out.write(DataTypesUtil.stringValue(rset.getObject(i + 1), rset.getStatement().getConnection()).getBytes(this.m_scriptRunnerContext.getEncoding()));
                    out.write(34);
                }
                if (i == colCnt) continue;
                out.write(44);
            }
            out.write(10);
        }
        if (!ResultSetFormatter.maxRowsSpoolOnly(this.m_scriptRunnerContext) && cnt == this.getMaxRows() && rset.next()) {
            this.logMaxReached(out);
        }
        return cnt;
    }

    public int rset2xml(ResultSet rset, BufferedOutputStream out) throws IOException, SQLException {
        int cnt = 0;
        int colCnt = rset.getMetaData().getColumnCount();
        out.write("<results>".getBytes());
        while (ResultSetFormatter.replaceNext(cnt, this.getMaxRows(), this.m_scriptRunnerContext, out, rset, null, null) && (cnt < this.getMaxRows() || ResultSetFormatter.maxRowsSpoolOnly(this.m_scriptRunnerContext))) {
            ++cnt;
            for (int i = 0; i < colCnt; ++i) {
                out.write("<![CDATA[".getBytes());
                if (rset.getBytes(i + 1) != null) {
                    out.write(DataTypesUtil.stringValue(rset.getObject(i + 1), rset.getStatement().getConnection()).getBytes(this.m_scriptRunnerContext.getEncoding()));
                }
                out.write("]]>".getBytes());
            }
            this.checkCanProceed();
        }
        out.write("</results>".getBytes());
        if (!ResultSetFormatter.maxRowsSpoolOnly(this.m_scriptRunnerContext) && cnt == this.getMaxRows() && rset.next()) {
            this.logMaxReached(out);
        }
        return cnt;
    }

    public int rset2html(ResultSet rset, BufferedOutputStream out) throws IOException, SQLException {
        int cnt = 0;
        int colCnt = rset.getMetaData().getColumnCount();
        out.write("<html>\n<body>\n<table>\n".getBytes());
        while (ResultSetFormatter.replaceNext(cnt, this.getMaxRows(), this.m_scriptRunnerContext, out, rset, null, null) && (cnt < this.getMaxRows() || ResultSetFormatter.maxRowsSpoolOnly(this.m_scriptRunnerContext))) {
            out.write("<tr>\n".getBytes());
            ++cnt;
            for (int i = 0; i < colCnt; ++i) {
                out.write("<td>".getBytes());
                if (rset.getBytes(i + 1) != null) {
                    out.write(DataTypesUtil.stringValue(rset.getObject(i + 1), rset.getStatement().getConnection()).toString().getBytes(this.m_scriptRunnerContext.getEncoding()));
                }
                out.write("</td>".getBytes());
            }
            out.write("</tr>\n".getBytes());
        }
        out.write("</table></body></html>".getBytes());
        if (!ResultSetFormatter.maxRowsSpoolOnly(this.m_scriptRunnerContext) && cnt == this.getMaxRows() && rset.next()) {
            this.logMaxReached(out);
        }
        return cnt;
    }

    public void logMaxReached(Object out) throws IOException {
        if (out instanceof BufferedOutputStream) {
            this.logMaxReached((BufferedOutputStream)out);
        } else if (out instanceof StringBuffer) {
            ResultSetFormatter.logMaxReached((StringBuffer)out, this.m_scriptRunnerContext);
        }
    }

    public void logMaxReached(BufferedOutputStream out) throws IOException {
        String msg = MessageFormat.format(Messages.getString("ResultSetFormatter.30"), this.getMaxRows());
        out.write(msg.getBytes(this.m_scriptRunnerContext.getEncoding()));
    }

    public static void logMaxReached(StringBuffer buf, ScriptRunnerContext ctx) throws IOException {
        buf.append(MessageFormat.format(Messages.getString("ResultSetFormatter.31"), ResultSetFormatter.getMaxRows(ctx)));
    }

    public static void setMaxLines(int maxLines) {
        s_maxLines = maxLines;
    }

    public static int getMaxLines() {
        return s_maxLines;
    }

    public static void main(String[] args) {
        ResultSetFormatter rsf = new ResultSetFormatter();
        System.out.println(rsf.getTableName("select * from scott.emp e"));
        System.out.println(rsf.getTableName("select * from (select * from emp) e"));
    }

    public static boolean setSpoolOnlyIfWrapped(ScriptRunnerContext ctx, Object out, ResultSet rset, StringBuffer errBuf, IResultFormatter iResFor) {
        block10: {
            Boolean truncSpool = (Boolean)ctx.getProperty("sqlcl.script.maxrowsspooltruncate");
            if (!ResultSetFormatter.maxRowsSpoolOnly(ctx) && ctx.getProperty("Spool.out.buffer") != null && (truncSpool == null || truncSpool.equals(Boolean.FALSE)) && out instanceof WrapListenBufferOutputStream) {
                try {
                    if (!rset.next()) break block10;
                    ctx.putProperty("sqlcl.spool.nexttrue", Boolean.TRUE);
                    try {
                        if (errBuf != null) {
                            ResultSetFormatter.logMaxReached(errBuf, ctx);
                        } else {
                            if (iResFor != null) {
                                if (iResFor.getOutWriter() != null) {
                                    iResFor.getOutWriter().flush();
                                }
                                if (iResFor.getOutputStream() != null) {
                                    iResFor.getOutputStream().flush();
                                }
                            }
                            WrapListenBufferOutputStream theWrap = (WrapListenBufferOutputStream)out;
                            theWrap.flush();
                            String msg = MessageFormat.format(Messages.getString("ResultSetFormatter.32"), ResultSetFormatter.getMaxRows(ctx));
                            theWrap.writeToNotSpool(("\n" + msg).getBytes(ctx.getEncoding()));
                            theWrap.flush();
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger(ResultSetFormatter.class.getName()).log(Level.WARNING, "IO ERROR", e);
                    }
                    ctx.putProperty("sqlcl.spool.spoolonly", Boolean.TRUE);
                    return true;
                }
                catch (SQLException e) {
                    Logger.getLogger(ResultSetFormatter.class.getName()).log(Level.WARNING, "Rset.next failed", e);
                }
            }
        }
        return false;
    }

    public static void clearSpoolOnly(ScriptRunnerContext ctx, Object out, Boolean wasToSpoolOnly, Boolean wasCacheNext) {
        if (ResultSetFormatter.maxRowsSpoolOnly(ctx) && out instanceof WrapListenBufferOutputStream) {
            try {
                ((WrapListenBufferOutputStream)out).flush();
            }
            catch (IOException e) {
                Logger.getLogger(ResultSetFormatter.class.getName()).log(Level.WARNING, "IO ERROR", e);
            }
        }
        ctx.putProperty("sqlcl.spool.spoolonly", wasToSpoolOnly);
        ctx.putProperty("sqlcl.spool.nexttrue", wasCacheNext);
    }

    public static Boolean cachedNext(ScriptRunnerContext ctx) {
        Boolean curVal = (Boolean)ctx.getProperty("sqlcl.spool.nexttrue");
        if (curVal == null) {
            return Boolean.FALSE;
        }
        ctx.putProperty("sqlcl.spool.nexttrue", Boolean.FALSE);
        return curVal;
    }

    public static boolean maxRowsSpoolOnly(ScriptRunnerContext ctx) {
        Boolean isSet = (Boolean)ctx.getProperty("sqlcl.spool.spoolonly");
        if (isSet == null) {
            isSet = Boolean.FALSE;
        }
        return isSet;
    }

    public static boolean continueIfPossible(long cnt, long s_maxRows, ScriptRunnerContext m_scriptRunnerContext, Object out, ResultSet rset, StringBuffer errbuf, IResultFormatter iResFor) {
        return m_scriptRunnerContext.getProperty("sqlcl.spool.spoolonly") != null && m_scriptRunnerContext.getProperty("sqlcl.spool.spoolonly").equals(Boolean.TRUE) || cnt == s_maxRows && cnt > 1L && ResultSetFormatter.setSpoolOnlyIfWrapped(m_scriptRunnerContext, out, rset, errbuf, iResFor);
    }

    public static boolean replaceNext(long cnt, long s_maxRows, ScriptRunnerContext m_scriptRunnerContext, Object out, ResultSet rset, StringBuffer errbuf, IResultFormatter iResFor) throws SQLException {
        if (s_maxRows == 0L || cnt < s_maxRows || m_scriptRunnerContext.getProperty("sqlcl.spool.spoolonly") != null && m_scriptRunnerContext.getProperty("sqlcl.spool.spoolonly").equals(Boolean.TRUE)) {
            return rset.next();
        }
        return cnt == s_maxRows && cnt > 1L && ResultSetFormatter.setSpoolOnlyIfWrapped(m_scriptRunnerContext, out, rset, errbuf, iResFor) && ResultSetFormatter.cachedNext(m_scriptRunnerContext) != null;
    }

    static {
        fontMetricsException = false;
        m_logger = Logger.getLogger(ResultSetFormatter.class.getName());
    }
}

