/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class NekotRexel {
    public static final int QuotedStrings = 1;
    public static final int SqlPlusComments = 2;
    public static final int PlSqlMacros = 4;
    static long incr = 0L;

    private static LinkedList<LexerToken> tokenize(String sourceExpr, int flags, String extraOper, InterruptedException interrupted) throws InterruptedException {
        LinkedList<LexerToken> ret = new LinkedList<LexerToken>();
        String operation = "(){}[]^-|!*+.><='\",;:%@?/\\#~" + extraOper;
        String ws = " \n\r\t";
        String delimStr = operation + " \n\r\t";
        int[] delims = null;
        for (int i = 0; i < delimStr.length(); ++i) {
            delims = Array.insert(delims, delimStr.charAt(i));
        }
        int pos = 0;
        boolean isWrapped = false;
        String aggr = "";
        for (int i = sourceExpr.length() - 1; 0 <= i; --i) {
            String token;
            int curI;
            char match;
            if (interrupted != null && Thread.interrupted()) {
                throw interrupted;
            }
            char cur = sourceExpr.charAt(i);
            if (cur != (match = (char)delims[curI = Array.indexOf(delims, cur)])) {
                aggr = cur + aggr;
                continue;
            }
            if (aggr.length() == 0) {
                token = new String(new char[]{cur});
            } else {
                token = aggr.toString();
                aggr = "";
                ++i;
            }
            pos += token.length();
            LexerToken last = null;
            if (ret.size() > 0) {
                last = ret.getLast();
            }
            if (isWrapped) {
                if ("/".equals(token) && last != null && "\n".equals(last.content)) {
                    String marker = "\"/\"";
                    ret.add(new LexerToken("\"/\"", pos - "\"/\"".length(), pos, Token.IDENTIFIER));
                    isWrapped = false;
                    continue;
                }
                if ("\n".equals(token)) {
                    ret.add(new LexerToken(token, pos - token.length(), pos, Token.WS));
                    continue;
                }
                if (!"\n".equals(last.content)) continue;
                last.content = "?";
                continue;
            }
            if (last != null && last.type == Token.COMMENT && (!last.content.endsWith("*/") || last.content.equals("/*/"))) {
                last.content = "*".equals(token) || "/".equals(token) ? last.content + token : "/* ... ";
                last.end = pos;
                if (last == null || last.type != Token.COMMENT || !last.content.endsWith("*/") || last.content.equals("/*/")) continue;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (last != null && last.type == Token.LINE_COMMENT && !"\n".equals(token)) {
                if ("\r".equals(token)) continue;
                last.content = last.content + token;
                continue;
            }
            if (last != null && last.type == Token.LINE_COMMENT && "\n".equals(token)) {
                last.end = pos - token.length();
                last.end = last.begin + last.content.length();
            }
            if (last != null && last.type == Token.QUOTED_STRING && !last.isStandardLiteral() && !last.isAltLiteral()) {
                last.content = last.content + token;
                last.end = last.begin + last.content.length();
                continue;
            }
            if (!(last == null || last.type != Token.DQUOTED_STRING || "\"".equals(token) || last.content.endsWith("\"") && last.content.length() > 1)) {
                last.content = last.content + token;
                last.end = last.begin + last.content.length();
                continue;
            }
            if (last != null && last.type == Token.DQUOTED_STRING && "\"".equals(token)) {
                last.end = pos;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (last != null && last.type == Token.BQUOTED_STRING && !"`".equals(token) && (!last.content.endsWith("`") || last.content.length() <= 1)) continue;
            if (last != null && last.type == Token.BQUOTED_STRING && "`".equals(token)) {
                last.end = pos;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if ("*".equals(token) && last != null && "/".equals(last.content)) {
                last.content = last.content + token;
                last.end = last.begin + last.content.length();
                last.type = Token.COMMENT;
                continue;
            }
            if (LexerToken.lineCommentSymbol.equals(token) && last != null && LexerToken.lineCommentSymbol.equals(last.content)) {
                last.content = last.content + token;
                last.type = Token.LINE_COMMENT;
                continue;
            }
            if ((flags & 2) == 2 && ("rem".equalsIgnoreCase(token) || "rema".equalsIgnoreCase(token) || "remar".equalsIgnoreCase(token) || "remark".equalsIgnoreCase(token) || "pro".equalsIgnoreCase(token) || "prom".equalsIgnoreCase(token) || "promp".equalsIgnoreCase(token) || "prompt".equalsIgnoreCase(token)) && (last == null || "\n".equals(last.content) || "\r".equals(last.content))) {
                ret.add(new LexerToken(token, pos - token.length(), -9, Token.LINE_COMMENT));
                continue;
            }
            if ((flags & 4) == 4 && ("$IF".equalsIgnoreCase(token) || "$ELSIF".equalsIgnoreCase(token) || "$ELSE".equalsIgnoreCase(token) || "$END".equalsIgnoreCase(token) || "$ERROR".equalsIgnoreCase(token))) {
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.MACRO_SKIP));
                continue;
            }
            String lastUpper = "N/A";
            if (last != null) {
                lastUpper = last.content.toUpperCase();
            }
            if (last != null && last.type == Token.MACRO_SKIP && lastUpper.startsWith("$IF") && lastUpper.endsWith("$THEN")) {
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.MACRO_SKIP));
                continue;
            }
            if (last != null && last.type == Token.MACRO_SKIP && (lastUpper.startsWith("$IF") || lastUpper.startsWith("$ELSIF") || lastUpper.startsWith("$ELSE") || lastUpper.startsWith("$ERROR"))) {
                last.content = last.content + token;
                last.end += token.length();
                continue;
            }
            if (last != null && last.type == Token.IDENTIFIER && last.end == -11 && last.content.startsWith("@") && !"\n".equals(token) && !"\r".equals(token)) {
                last.content = last.content + token;
                continue;
            }
            if (last != null && last.type == Token.IDENTIFIER && last.end == -11 && last.content.startsWith("@") && ("\n".equals(token) || "\r".equals(token))) {
                last.end = pos - 1;
                ret.add(new LexerToken(token, pos - 1, pos, Token.WS));
                continue;
            }
            if ((flags & 1) == 1 && "'".equals(token)) {
                if (last != null && ("q".equalsIgnoreCase(last.content) || "N".equalsIgnoreCase(last.content) || "u".equalsIgnoreCase(last.content) || "nq".equalsIgnoreCase(last.content))) {
                    last.content = last.content + token;
                    last.type = Token.QUOTED_STRING;
                    continue;
                }
                ret.add(new LexerToken(token, pos - 1, -10, Token.QUOTED_STRING));
                continue;
            }
            if ((flags & 1) == 1 && "\"".equals(token)) {
                ret.add(new LexerToken(token, pos - 1, -11, Token.DQUOTED_STRING));
                continue;
            }
            if ("`".equals(token) && 0 <= operation.indexOf(96)) {
                ret.add(new LexerToken(token, pos - 1, -11, Token.BQUOTED_STRING));
                continue;
            }
            if (operation.contains(token)) {
                ret.add(new LexerToken(token, pos - 1, pos, Token.OPERATION));
                continue;
            }
            if (" \n\r\t".contains(token)) {
                ret.add(new LexerToken(token, pos - 1, pos, Token.WS));
                continue;
            }
            if ('0' <= token.charAt(0) && token.charAt(0) <= '9') {
                if (NekotRexel.fixedExponent(token, ret, pos - token.length())) continue;
                if (token.charAt(token.length() - 1) == 'K' || token.charAt(token.length() - 1) == 'k' || token.charAt(token.length() - 1) == 'M' || token.charAt(token.length() - 1) == 'm' || token.charAt(token.length() - 1) == 'G' || token.charAt(token.length() - 1) == 'g' || token.charAt(token.length() - 1) == 'T' || token.charAt(token.length() - 1) == 't' || token.charAt(token.length() - 1) == 'P' || token.charAt(token.length() - 1) == 'p' || token.charAt(token.length() - 1) == 'E' || token.charAt(token.length() - 1) == 'e') {
                    ret.add(new LexerToken(token.substring(0, token.length() - 1), pos - token.length(), pos - 1, Token.DIGITS));
                    ret.add(new LexerToken(token.substring(token.length() - 1), pos - 1, pos, Token.DIGITS));
                    continue;
                }
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                continue;
            }
            if ("WRAPPED".equalsIgnoreCase(token) && last != null) {
                Iterator<LexerToken> descIter = ret.descendingIterator();
                boolean sawId = false;
                while (descIter.hasNext()) {
                    LexerToken t = descIter.next();
                    if (sawId && ("PROCEDURE".equalsIgnoreCase(t.content) || "FUNCTION".equalsIgnoreCase(t.content) || "TRIGGER".equalsIgnoreCase(t.content) || "TYPE".equalsIgnoreCase(t.content) || "PACKAGE".equalsIgnoreCase(t.content) || "BODY".equalsIgnoreCase(t.content))) {
                        isWrapped = true;
                        break;
                    }
                    if (t.type == Token.WS || t.type == Token.COMMENT) continue;
                    if (t.type != Token.IDENTIFIER) break;
                    sawId = true;
                }
            }
            ret.add(new LexerToken(token, pos - token.length(), pos, Token.IDENTIFIER));
        }
        LexerToken.lineCommentSymbol = LexerToken.defaultLineCommentSymbol;
        return ret;
    }

    private static boolean fixedExponent(String input, List<LexerToken> ret, int pos) {
        if (!(input.contains("e") || input.contains("f") || input.contains("d"))) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(input, "efd", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            pos += token.length();
            if ('0' <= token.charAt(0) && token.charAt(0) <= '9') {
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                continue;
            }
            ret.add(new LexerToken(token, pos - token.length(), pos, Token.IDENTIFIER));
        }
        return true;
    }

    public static List<LexerToken> parse(String input) {
        return NekotRexel.parse(input, false);
    }

    public static List<LexerToken> parse(String input, String extraOper) {
        ArrayList<LexerToken> ret = new ArrayList<LexerToken>();
        try {
            NekotRexel.parse(input, false, 7, extraOper, ret, null);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"parse(...,interrupted==false) has thrown InterruptedException");
        }
        return ret;
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS) {
        return NekotRexel.parse(input, keepWSandCOMMENTS, 7);
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS, int flags) {
        try {
            return NekotRexel.parse(input, keepWSandCOMMENTS, flags, null);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"parse(...,interrupted==false) has thrown InterruptedException");
        }
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS, int flags, InterruptedException interrupted) throws InterruptedException {
        ArrayList<LexerToken> ret = new ArrayList<LexerToken>();
        NekotRexel.parse(input, keepWSandCOMMENTS, flags, "", ret, interrupted);
        return ret;
    }

    private static void parse(String input, boolean keepWSandCOMMENTS, int flags, String extraOper, List<LexerToken> ret, InterruptedException interrupted) throws InterruptedException {
        LexerToken last = null;
        for (LexerToken token : NekotRexel.tokenize(input, flags, extraOper, interrupted)) {
            if (token.type == Token.QUOTED_STRING) {
                if (last != null && last.type == Token.QUOTED_STRING) {
                    last.content = last.content + token.content;
                    last.end = token.end;
                    continue;
                }
                if (last != null && last.type == Token.IDENTIFIER && "n".equalsIgnoreCase(last.content) && last.end == token.begin) {
                    last.begin = token.begin;
                    last.end = token.end;
                    last.type = token.type;
                    last.content = token.content;
                    continue;
                }
            }
            if (token.content.startsWith("@")) {
                token.end = token.begin + token.content.length();
            }
            if ("#".equals(token.content) && last != null && last.type == Token.IDENTIFIER) {
                ++last.end;
                last.content = last.content + "#";
                continue;
            }
            if ((token.type == Token.IDENTIFIER || token.type == Token.DIGITS) && last != null && last.content.endsWith("#") && last.type == Token.IDENTIFIER) {
                last.end += token.content.length();
                last.content = last.content + token.content;
                continue;
            }
            if (keepWSandCOMMENTS || token.type != Token.WS && token.type != Token.COMMENT && token.type != Token.LINE_COMMENT && token.type != Token.MACRO_SKIP && token.type != Token.SQLPLUSLINECONTINUE_SKIP) {
                ret.add(token);
            }
            last = token;
        }
    }

    private static void testInput(String input) throws IOException {
        long h = System.nanoTime();
        List<LexerToken> out = NekotRexel.parse(input, true);
        incr += System.nanoTime() - h;
        if (out.size() < 1000) {
            LexerToken.print(out);
        }
        System.out.println("-------------");
    }

    public static void main(String[] args) throws Exception {
        String[] inputs = new String[]{Service.readFile(NekotRexel.class, "test.sql"), Service.readFile(SqlEarley.class, "MSC_CL_PRE_PROCESS.pkgbdy")};
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < inputs.length; ++i) {
            NekotRexel.testInput(inputs[i]);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Lexer time = " + (t2 - t1));
        System.out.println("Nano time = " + incr);
    }
}

