/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.TreeMap;
import oracle.dbtools.util.Service;

public class Substitutions {
    private String input;
    protected TreeMap<Long, String> substitutions = new TreeMap();

    public Substitutions(String input) {
        this.input = input;
    }

    public void put(int X, int Y, String replacement) {
        for (long candidate : this.substitutions.keySet()) {
            if (X <= Service.lX(candidate) && Service.lX(candidate) < Y || X < Service.lY(candidate) && Service.lY(candidate) <= Y) {
                throw new AssertionError((Object)("[" + X + "," + Y + ") overlaps with [" + X + "," + Y + ")"));
            }
        }
        this.substitutions.put(Service.lPair(X, Y), replacement);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        int lastPos = 0;
        for (long key : this.substitutions.keySet()) {
            int begin = Service.lX(key);
            int end = Service.lY(key);
            if (lastPos < begin) {
                ret.append(this.input.substring(lastPos, begin));
            }
            ret.append("\n---\n");
            ret.append(this.input.substring(begin, end));
            ret.append("\n--->>>\n");
            ret.append(this.substitutions.get(key));
            ret.append("\n---\n");
            lastPos = end;
        }
        ret.append(this.input.substring(lastPos));
        return ret.toString();
    }

    public String transformInput() {
        StringBuilder ret = new StringBuilder();
        int lastPos = 0;
        for (long key : this.substitutions.keySet()) {
            int begin = Service.lX(key);
            int end = Service.lY(key);
            if (lastPos < begin) {
                ret.append(this.input.substring(lastPos, begin));
            }
            ret.append(this.substitutions.get(key));
            lastPos = end;
        }
        ret.append(this.input.substring(lastPos));
        return ret.toString();
    }

    public boolean equals(Object obj) {
        String match;
        Substitutions cmp = (Substitutions)obj;
        for (Long key : this.substitutions.keySet()) {
            match = cmp.substitutions.get(key);
            if (match == null) {
                return false;
            }
            if (!match.equals(this.substitutions.get(key))) continue;
            return false;
        }
        for (Long key : cmp.substitutions.keySet()) {
            match = this.substitutions.get(key);
            if (match != null) continue;
            return false;
        }
        return true;
    }

    public String diff(Object obj) {
        String match;
        Substitutions cmp = (Substitutions)obj;
        for (Long key : this.substitutions.keySet()) {
            match = cmp.substitutions.get(key);
            if (match == null) {
                return "no match for " + Service.lX(key) + "," + Service.lY(key) + " `" + this.substitutions.get(key) + "`";
            }
            if (!match.equals(this.substitutions.get(key))) continue;
            return "" + Service.lX(key) + "," + Service.lY(key) + " `" + this.substitutions.get(key) + "` != `" + match + "`";
        }
        for (Long key : cmp.substitutions.keySet()) {
            match = this.substitutions.get(key);
            if (match != null) continue;
            return "no match for " + Service.lX(key) + "," + Service.lY(key) + " `" + cmp.substitutions.get(key) + "`";
        }
        return "=";
    }

    public String[] lines() {
        String[] ret = new String[this.substitutions.size()];
        int pos = -1;
        for (long key : this.substitutions.keySet()) {
            ret[++pos] = "" + Service.lX(key) + "," + Service.lY(key) + " `" + this.substitutions.get(key) + "`";
        }
        return ret;
    }

    public static void main(String[] args) {
        Substitutions repl = new Substitutions("0123456789012345");
        repl.put(1, 2, "[1,2)");
        repl.put(11, 12, "[11,12)");
        System.out.println("**** repl.toString():");
        System.out.println(repl.toString());
        System.out.println("**** repl.transformInput():");
        System.out.println(repl.transformInput());
    }
}

