/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;

public class TreeBuilder {
    private Matrix matrix;
    private Earley parser;

    public TreeBuilder(Matrix matrix, Earley parser) {
        this.matrix = matrix;
        this.parser = parser;
    }

    public ParseNode build() {
        ParseNode root;
        Cell cell = this.matrix.get(0, this.matrix.lastY());
        if (cell != null && 0 < cell.size() && (root = this.treeForACell(cell, 0, this.matrix.lastY())) != null) {
            return root;
        }
        throw new AssertionError((Object)"TODO");
    }

    private ParseNode treeForACell(Cell cellXY, int x, int y) {
        int mid = (y - x) / 2;
        int incr = 0;
        while (mid + incr < y && x <= mid - incr - 1) {
            ParseNode root;
            int split = mid + incr;
            if (split < y && (root = this.treeForACell(cellXY, x, y, mid)) != null) {
                return root;
            }
            split = mid - incr - 1;
            if (x <= split && (root = this.treeForACell(cellXY, x, y, mid)) != null) {
                return root;
            }
            ++incr;
        }
        return null;
    }

    private ParseNode treeForACell(Cell cellXY, int x, int y, int mid) {
        Cell pre = this.matrix.get(x, mid);
        if (pre != null && 0 < pre.size()) {
            for (int i = 0; i < pre.size(); ++i) {
                int rulePre = pre.getRule(i);
                int posPre = pre.getPosition(i);
                for (int j = 0; j < cellXY.size(); ++j) {
                    ParseNode rgt;
                    int pos;
                    int rule = cellXY.getRule(j);
                    if (rule != rulePre || (pos = cellXY.getPosition(j)) != posPre + 1) continue;
                    String symbol = this.parser.allSymbols[pos];
                    if (mid + 1 == y && (symbol.charAt(0) == '\'' || "identifier".equals(symbol) || "digits".equals(symbol) || "string_literal".equals(symbol))) {
                        ParseNode ret;
                        ParseNode branch = this.treeForACell(pre, x, mid);
                        if (branch == null) continue;
                        ret.lft.parent = ret = null;
                        ret.rgt = branch;
                        ret.rgt.parent = ret;
                        return ret;
                    }
                    ParseNode lft = this.treeForACell(pre, x, mid);
                    if (lft == null || (rgt = this.treeForACell(pre, x, mid)) == null) continue;
                    ParseNode ret = null;
                    ret.lft = lft;
                    ret.lft.parent = ret;
                    ret.rgt = rgt;
                    ret.rgt.parent = ret;
                    return ret;
                }
            }
        }
        return null;
    }
}

