/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class Yelrae
extends Parser {
    public static final String PARSE_WITH_ERRORS = "parse with errors";
    public Earley employee;
    private static Visual visual = null;
    private static Yelrae sqlInstance = null;

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(SqlEarley.class, "test.sql");
        List<LexerToken> src = LexerToken.parse(input);
        visual = new Visual(src, Yelrae.sqlYelraeInstance());
        ParseNode root = Yelrae.sqlYelraeInstance().parse(src);
        root.printTree();
    }

    private static void testOnSimpleGrammar() {
        String input = "1+2+3*4";
        List<LexerToken> src = LexerToken.parse(input);
        System.out.println("src.size()=" + src.size());
        TreeSet<RuleTuple> wiki = new TreeSet<RuleTuple>();
        wiki.add(new RuleTuple("P", new String[]{"S"}));
        wiki.add(new RuleTuple("S", new String[]{"S", "'+'", "M"}));
        wiki.add(new RuleTuple("S", new String[]{"M"}));
        wiki.add(new RuleTuple("M", new String[]{"T", "'*'", "M"}));
        wiki.add(new RuleTuple("M", new String[]{"T"}));
        wiki.add(new RuleTuple("T", new String[]{"'('", "P", "')'"}));
        wiki.add(new RuleTuple("T", new String[]{"digits"}));
        wiki.add(new RuleTuple("T", new String[]{"identifier"}));
        wiki.add(new RuleTuple("T", new String[]{"string_literal"}));
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        rules = wiki;
        Yelrae yel = new Yelrae(new Earley(rules)){};
        Matrix matrix = new Matrix(yel.employee);
        Visual visual = null;
        visual = new Visual(Yelrae.inverseSrc(src), yel.employee);
        long t1 = System.currentTimeMillis();
        ParseNode out = yel.parse(src, matrix);
        long t2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (t2 - t1));
        System.out.println("#tokens=" + src.size());
        out.printTree();
        if (visual != null) {
            visual.draw(matrix);
        } else {
            System.out.println(matrix.toString());
        }
    }

    public static Yelrae sqlYelraeInstance() {
        if (sqlInstance == null) {
            SqlEarley earley = SqlEarley.partialRecognizer(new String[]{"sql_statements", "subprg_body", "expr", "fml_part", "paren_expr_list", "basic_decl_item_list"});
            sqlInstance = new Yelrae(earley);
        }
        return sqlInstance;
    }

    public synchronized ParseNode parse(List<LexerToken> src, Matrix matrix) {
        ArrayList<LexerToken> crs = Yelrae.inverseSrc(src);
        if (visual != null) {
            matrix.visual = visual = new Visual(crs, this.employee);
            Yelrae.visual.matrix = matrix;
        }
        this.employee.parse(crs, matrix);
        if (visual != null) {
            visual.draw();
        }
        ParseNode out = this.employee.forest(crs, matrix, true);
        this.invert(src.size(), out);
        return out;
    }

    private void invert(int length, ParseNode node) {
        int morf = length - node.from;
        node.from = length - node.to;
        node.to = morf;
        if (node.lft != null) {
            this.invert(length, node.lft);
        }
        if (node.rgt != null) {
            this.invert(length, node.rgt);
        }
        if (node.rgt != null && node.lft != null) {
            ParseNode tmp = node.rgt;
            node.rgt = node.lft;
            node.lft = tmp;
        }
        if (node.topLevel != null) {
            TreeSet<ParseNode> topLevel = new TreeSet<ParseNode>();
            for (ParseNode c : node.topLevel) {
                this.invert(length, c);
                topLevel.add(c);
            }
            node.topLevel = topLevel;
        }
    }

    private synchronized void recognise(List<LexerToken> src, Matriceable m) {
        ArrayList<LexerToken> crs = Yelrae.inverseSrc(src);
        this.employee.parse(crs, m);
    }

    public static ArrayList<LexerToken> inverseSrc(List<LexerToken> src) {
        ArrayList<LexerToken> crs = new ArrayList<LexerToken>();
        int size = src.size();
        for (int i = 0; i < size; ++i) {
            crs.add(src.get(size - i - 1));
        }
        return crs;
    }

    public Yelrae(Earley template) {
        this.employee = template;
        this.employee.rules = template.invertRules();
        this.allSymbols = template.allSymbols;
        this.symbolIndexes = template.symbolIndexes;
        this.rules = this.employee.rules;
    }

    @Override
    public ParseNode parse(List<LexerToken> src) {
        Matrix matrix = new Matrix(this.employee);
        return this.parse(src, matrix);
    }

    public static ParseNode duplexParse(List<LexerToken> src, Matrix forward) {
        ParseNode root = SqlEarley.getInstance().forest(src, forward, true);
        int endOdParse = 0;
        for (ParseNode child : root.children()) {
            endOdParse = child.to;
        }
        if (root.to == endOdParse) {
            return root;
        }
        ParseNode addendum = Yelrae.sqlYelraeInstance().parse(src);
        if (addendum.topLevel != null) {
            for (ParseNode child : addendum.topLevel) {
                root.addTopLevel(child);
            }
        }
        return root;
    }

    @Override
    ParseNode treeForACell(List<LexerToken> src, Matrix m, Cell cell, int x, int y, Map<Long, ParseNode> explored) {
        throw new AssertionError((Object)"Abstract method");
    }

    @Override
    void parse(List<LexerToken> src, Matriceable matrix) {
        throw new AssertionError((Object)"Abstract method");
    }

    @Override
    void toHtml(int ruleNo, int pos, boolean selected, int x, int mid, int y, Matriceable matrix, StringBuffer sb) {
        throw new AssertionError((Object)"Abstract method");
    }
}

