/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.util.Service;

public class PlsqlRules {
    public static void main(String[] args) throws Exception {
        throw new AssertionError((Object)"VT: broken");
    }

    public static Set<RuleTuple> parseBNFtext(String input) throws Exception {
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        List<LexerToken> src1 = LexerToken.parse(input, false, 1);
        ArrayList<LexerToken> src = new ArrayList<LexerToken>();
        for (LexerToken t : src1) {
            if (t.content.charAt(0) != '.' && t.content.charAt(0) != '_' && t.content.charAt(t.content.length() - 1) == '_' && t.content.toUpperCase().equals(t.content)) {
                t.content = "'" + t.content.substring(0, t.content.length() - 1).toUpperCase() + "'";
            }
            src.add(t);
        }
        ParseNode root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, ret);
        PlsqlRules.substitute(ret, "expr", "pls_expr");
        return ret;
    }

    private static void substitute(Set<RuleTuple> ret, String expr, String subst) {
        TreeSet<RuleTuple> delete = new TreeSet<RuleTuple>();
        TreeSet<RuleTuple> add = new TreeSet<RuleTuple>();
        boolean replace = false;
        for (RuleTuple r : ret) {
            RuleTuple clone = new RuleTuple(r.head, new String[r.rhs.length]);
            if (r.head.equals(expr)) {
                clone.head = subst;
                replace = true;
            }
            for (int i = 0; i < r.rhs.length; ++i) {
                if (r.rhs[i].equals(expr)) {
                    clone.rhs[i] = subst;
                    replace = true;
                    continue;
                }
                clone.rhs[i] = r.rhs[i];
            }
            if (!replace) continue;
            delete.add(r);
            add.add(clone);
        }
        ret.removeAll(delete);
        ret.addAll(add);
    }

    static void fixIdentifierIsOrAs(Set<RuleTuple> ret) {
        TreeSet<RuleTuple> more = new TreeSet<RuleTuple>();
        for (RuleTuple t : ret) {
            int i;
            RuleTuple t1;
            if (3 <= t.rhs.length && ("'PACKAGE'".equals(t.rhs[0]) || "'TYPE'".equals(t.rhs[0]) || "'PROCEDURE'".equals(t.rhs[0]) || "'FUNCTION'".equals(t.rhs[0]) || "'TRIGGER'".equals(t.rhs[0])) && "identifier".equals(t.rhs[1])) {
                t1 = new RuleTuple(t.head, new String[t.rhs.length + 2]);
                t1.rhs[0] = t.rhs[0];
                t1.rhs[1] = "identifier";
                t1.rhs[2] = "'.'";
                for (i = 1; i < t.rhs.length; ++i) {
                    t1.rhs[i + 2] = t.rhs[i];
                }
                more.add(t1);
                continue;
            }
            if (4 > t.rhs.length || !"'BODY'".equals(t.rhs[1]) || !"identifier".equals(t.rhs[2])) continue;
            t1 = new RuleTuple(t.head, new String[t.rhs.length + 2]);
            t1.rhs[0] = t.rhs[0];
            t1.rhs[1] = t.rhs[1];
            t1.rhs[2] = "identifier";
            t1.rhs[3] = "'.'";
            for (i = 2; i < t.rhs.length; ++i) {
                t1.rhs[i + 2] = t.rhs[i];
            }
            more.add(t1);
        }
        ret.addAll(more);
    }

    public static Set<String> getKeywords(Set<RuleTuple> rules) {
        TreeSet<String> ret = new TreeSet<String>();
        for (RuleTuple rule : rules) {
            for (String token : rule.rhs) {
                if (!token.startsWith("'")) continue;
                ret.add(token);
            }
        }
        return ret;
    }

    static String readBNFfile() throws Exception {
        String rulesTxt = Service.readFile("/Users/dim/Documents/plsql.grammar");
        String startPattern = "/*---------------------------- Start of Rules -------------------------------*/";
        rulesTxt = rulesTxt.substring(rulesTxt.indexOf("/*---------------------------- Start of Rules -------------------------------*/") + "/*---------------------------- Start of Rules -------------------------------*/".length());
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "/*", "*/");
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = rulesTxt.replace("ASSIGN_", "':' '='");
        rulesTxt = rulesTxt.replace("LTEQ_", "'<' '='");
        rulesTxt = rulesTxt.replace("GTEQL_", "'>' '='");
        rulesTxt = rulesTxt.replace("NOTEQL_", "'!' '='");
        rulesTxt = rulesTxt.replace("BOX_", "'<' '>'");
        rulesTxt = rulesTxt.replace("CAT_", "'|' '|'");
        rulesTxt = rulesTxt.replace(" DBLDOT_ ", " '.' '.' ");
        rulesTxt = rulesTxt.replace("ARROW_", "'=' '>'");
        rulesTxt = rulesTxt.replace("EXP_ pri", "'*' '*' pri");
        rulesTxt = rulesTxt.replace("L_LBL_", "'<' '<'");
        rulesTxt = rulesTxt.replace("R_LBL_", "'>' '>'");
        rulesTxt = rulesTxt.replace("bind_var INDICATOR_ id", "bind_var INDICATOR_ identifier");
        rulesTxt = rulesTxt.replace("')'", " ')' ");
        rulesTxt = rulesTxt.replace("'('", " '(' ");
        rulesTxt = rulesTxt.replace("%%", "");
        rulesTxt = rulesTxt.replace("bind_var.INDICATOR_id.", "\"bind_var.INDICATOR_id.\"");
        rulesTxt = rulesTxt.replace("...from_table_reference_or_subquery..", "\"...from_table_reference_or_subquery..\"");
        return rulesTxt;
    }

    static String removeNestedBlock(String src, String br1, String br2) {
        int len1 = br1.length();
        int len2 = br2.length();
        int beg = 0;
        int end = 0;
        StringBuffer out = new StringBuffer();
        while (beg < src.length()) {
            beg = src.indexOf(br1, end);
            int beg1 = src.indexOf(br1, beg + len1);
            int end1 = src.indexOf(br2, beg + len1) + len2;
            if (beg > 0 && beg < beg1 && beg1 < end1) {
                out.append(src.substring(end, beg + len1));
                end = beg + len1;
                continue;
            }
            if (beg < 0) {
                beg = src.length();
            }
            out.append(src.substring(end, beg));
            end = src.indexOf(br2, beg + len1) + len2;
            if (end >= len2) continue;
            out.append(src.substring(beg));
            break;
        }
        return out.toString();
    }
}

