/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.net.URI;
import java.sql.Connection;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionReference;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionWrapper;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtensionManager;
import oracle.dbtools.raptor.datatypes.DataTypeProvider;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.AbstractDataTypeConnectionProviderImpl;
import oracle.dbtools.raptor.datatypes.impl.DataTypeConnectionProviderImpl;
import oracle.dbtools.raptor.datatypes.impl.DataTypeConnectionReferenceImpl;
import oracle.dbtools.raptor.datatypes.impl.DataTypeContextImpl;

public abstract class AbstractDataTypeFactoryExtensionImpl
implements DataTypeFactoryExtension {
    private final DataTypeFactoryExtensionManager.ExtensionManagerAccess extensionManagerAccess;
    private final DataTypeFactoryExtension.ExtensionAccess superExtensionAccess;

    public AbstractDataTypeFactoryExtensionImpl(DataTypeFactoryExtensionManager.ExtensionManagerAccess extensionManagerAccess, DataTypeFactoryExtension.ExtensionAccess superExtensionAccess) {
        this.extensionManagerAccess = extensionManagerAccess;
        this.superExtensionAccess = superExtensionAccess;
    }

    protected DataTypeFactoryExtensionManager.ExtensionManagerAccess getExtensionManagerAccess() {
        return this.extensionManagerAccess;
    }

    protected abstract DataTypeFactoryExtension.ExtensionAccess getExtensionAccess();

    @Override
    public final DataTypeFactoryExtensionManager getDataTypeFactoryExtensionManager() {
        return this.extensionManagerAccess.getDataTypeFactoryExtensionManager();
    }

    @Override
    public final DataTypeFactory getDataTypeFactory() {
        return this.extensionManagerAccess.getDataTypeFactory();
    }

    protected final DataTypeFactoryExtension.ExtensionAccess getSuperExtensionAccess() {
        return this.superExtensionAccess;
    }

    protected final DataTypeFactoryExtension getSuperExtension() {
        return this.superExtensionAccess != null ? this.superExtensionAccess.getDataTypeFactoryExtension() : null;
    }

    @Override
    public final boolean handles(Class<?> clazz) {
        DataTypeFactoryExtension superExtension;
        boolean handles = this.handlesExplicitly(clazz);
        if (!handles && (superExtension = this.getSuperExtension()) != null) {
            handles = superExtension.handles(clazz);
        }
        return handles;
    }

    @Override
    public boolean handlesExplicitly(Class<?> clazz) {
        return false;
    }

    @Override
    public abstract DataTypeProvider getDataTypeProvider();

    protected DataType resolveDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        return this.getDataTypeProvider().getDataType(context, typeMetadata);
    }

    protected DataTypeProvider lookupDataTypeProvider(URI dataTypeProviderURI) {
        DataTypeProvider provider = this.getDataTypeProvider();
        if (provider != null && provider.getDataTypeProviderURI().equals(dataTypeProviderURI)) {
            return provider;
        }
        return null;
    }

    protected DataTypeProvider resolveDataTypeProvider(URI dataTypeProviderURI) {
        DataTypeFactoryExtension.ExtensionAccess superExtensionAccess;
        DataTypeProvider provider = this.lookupDataTypeProvider(dataTypeProviderURI);
        if (provider == null && (superExtensionAccess = this.getSuperExtensionAccess()) != null) {
            provider = superExtensionAccess.resolveDataTypeProvider(dataTypeProviderURI);
        }
        return provider;
    }

    @Override
    public DataTypeFactoryExtension.Extendable.Builder builder(Class<?> clazz, Object ... obj) {
        DataTypeFactoryExtension.Extendable.Builder builder;
        block7: {
            AbstractDataTypeConnectionProviderImpl.Builder candidate;
            block11: {
                DataTypeConnectionWrapper nlsWrapper;
                block10: {
                    DataTypeConnectionReference connectionReference;
                    block9: {
                        block8: {
                            builder = null;
                            DataTypeFactoryExtension superExtension = this.getSuperExtension();
                            if (superExtension != null) {
                                builder = superExtension.builder(clazz, obj);
                            }
                            if (builder != null) break block7;
                            if (clazz != DataTypeContext.ContextAccess.class) break block8;
                            if (obj != null && obj.length == 1 && DataTypeConnectionProvider.ConnectionProviderAccess.class.isAssignableFrom(obj[0].getClass())) {
                                builder = DataTypeContextImpl.builder((DataTypeConnectionProvider.ConnectionProviderAccess)obj[0]);
                            }
                            break block7;
                        }
                        if (clazz != DataTypeConnectionProvider.ConnectionProviderAccess.class || obj == null) break block7;
                        candidate = null;
                        if (obj.length < 1) break block7;
                        if (!Connection.class.isAssignableFrom(obj[0].getClass())) break block9;
                        candidate = DataTypeConnectionProviderImpl.builder(Connection.class).setDataTypeConnectionReference(new DataTypeConnectionReferenceImpl<Connection>(Connection.class, (Connection)obj[0]));
                        break block10;
                    }
                    if (!DataTypeConnectionReference.class.isAssignableFrom(obj[0].getClass()) || !Connection.class.isAssignableFrom((connectionReference = (DataTypeConnectionReference)obj[0]).getConnectionClass())) break block7;
                    candidate = DataTypeConnectionProviderImpl.builder(Connection.class).setDataTypeConnectionReference(connectionReference);
                }
                if (obj.length == 1) break block11;
                if (obj.length != 2) break block7;
                if (obj[1] == null) break block11;
                if (!DataTypeConnectionWrapper.class.isAssignableFrom(obj[1].getClass()) || !Connection.class.isAssignableFrom((nlsWrapper = (DataTypeConnectionWrapper)obj[1]).getConnectionClass())) break block7;
                ((DataTypeConnectionProviderImpl.Builder)candidate).setNLSConnectionWrapper(nlsWrapper);
            }
            builder = candidate;
        }
        if (builder != null) {
            builder = builder.setExtensionAccess(this.getExtensionAccess());
        }
        return builder;
    }

    public static abstract class Builder
    implements DataTypeFactoryExtension.Builder {
        private final URI extensionURI;
        private URI superExtensionURI;
        private DataTypeFactoryExtensionManager.ExtensionManagerAccess extensionManagerAccess;
        private DataTypeProvider.Builder dataTypeProvider;

        protected Builder(URI extensionURI) {
            this.extensionURI = extensionURI;
            this.superExtensionURI = null;
            this.dataTypeProvider = null;
        }

        @Override
        public URI getExensionURI() {
            return this.extensionURI;
        }

        @Override
        public URI getSuperExensionURI() {
            return this.superExtensionURI;
        }

        @Override
        public Builder setSuperExtensionURI(URI superExtensionURI) {
            this.superExtensionURI = superExtensionURI;
            return this;
        }

        @Override
        public Builder setExtensionManagerAccess(DataTypeFactoryExtensionManager.ExtensionManagerAccess extensionManagerAccess) {
            this.extensionManagerAccess = extensionManagerAccess;
            return this;
        }

        @Override
        public DataTypeFactoryExtensionManager.ExtensionManagerAccess getExtensionManagerAccess() {
            return this.extensionManagerAccess;
        }

        @Override
        public DataTypeProvider.Builder getDataTypeProvider() {
            return this.dataTypeProvider;
        }

        @Override
        public Builder setDataTypeProvider(DataTypeProvider.Builder dataTypeprovider) {
            this.dataTypeProvider = dataTypeprovider;
            return this;
        }
    }

    protected class DefaultExtensionAccess
    implements DataTypeFactoryExtension.ExtensionAccess {
        @Override
        public DataTypeFactory getDataTypeFactory() {
            return AbstractDataTypeFactoryExtensionImpl.this.getDataTypeFactory();
        }

        @Override
        public DataTypeFactoryExtensionManager.ExtensionManagerAccess getExtensionManagerAccess() {
            return AbstractDataTypeFactoryExtensionImpl.this.getExtensionManagerAccess();
        }

        @Override
        public DataTypeFactoryExtension getDataTypeFactoryExtension() {
            return AbstractDataTypeFactoryExtensionImpl.this;
        }

        @Override
        public DataTypeProvider lookupDataTypeProvider(URI dataTypeProviderURI) {
            return AbstractDataTypeFactoryExtensionImpl.this.lookupDataTypeProvider(dataTypeProviderURI);
        }

        @Override
        public DataTypeProvider resolveDataTypeProvider(URI dataTypeProviderURI) {
            return AbstractDataTypeFactoryExtensionImpl.this.resolveDataTypeProvider(dataTypeProviderURI);
        }

        @Override
        public DataTypeContext.ContextAccess getContextAccess(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
            return this.getExtensionManagerAccess().getContextAccess(connectionProviderAccess);
        }

        @Override
        public DataTypeContext.ContextAccess peekContextAccess(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
            return this.getExtensionManagerAccess().peekContextAccess(connectionProviderAccess);
        }

        @Override
        public DataType resolveDataType(DataTypeContext context, TypeMetadata typeMetadata) {
            return AbstractDataTypeFactoryExtensionImpl.this.resolveDataType(context, typeMetadata);
        }
    }
}

