/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.ClobDatum;
import oracle.dbtools.raptor.datatypes.objects.LongBinary;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.jdbc.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public class BlobDatum
extends LongBinary {
    public BlobDatum() {
    }

    protected BlobDatum(BlobDatum source) {
        super(source);
    }

    protected BlobDatum(Object object) {
        super(object);
    }

    public BlobDatum(Blob value) throws SQLException {
        super(value);
    }

    public BlobDatum(byte[] value) {
        super(value);
    }

    public BlobDatum(File value) {
        super(value);
    }

    public BlobDatum(InputStream istream) throws IOException {
        this(istream, 32768);
    }

    public BlobDatum(InputStream istream, int cutOverLen) throws IOException {
        this(BlobDatum.getBuilder(EncodingType.ENCODING_NONE, cutOverLen).write(istream).build());
    }

    public BlobDatum(CharSequence hex) throws IOException, EncodingException {
        this(hex, 32768);
    }

    public BlobDatum(CharSequence hex, int cutOverLen) throws IOException, EncodingException {
        this(BlobDatum.getBuilder(EncodingType.ENCODING_HEX, cutOverLen).write(new StringReader(hex.toString())).build());
    }

    public BlobDatum(char[] chars) throws IOException, EncodingException {
        this(chars, 32768);
    }

    public BlobDatum(char[] chars, int cutOverLen) throws IOException, EncodingException {
        this(BlobDatum.getBuilder(EncodingType.ENCODING_HEX, cutOverLen).write(new CharArrayReader(chars)).build());
    }

    public BlobDatum(Reader reader) throws IOException, EncodingException {
        this(reader, 32768);
    }

    public BlobDatum(Reader reader, int cutOverLen) throws IOException, EncodingException {
        this(BlobDatum.getBuilder(EncodingType.ENCODING_HEX, cutOverLen).write(reader).build());
    }

    public static BlobDatum constructFrom(Object value) throws IOException, SQLException, EncodingException {
        if (value instanceof Blob) {
            return new BlobDatum((Blob)value);
        }
        if (value instanceof byte[]) {
            return new BlobDatum((byte[])value);
        }
        if (value instanceof InputStream) {
            return new BlobDatum((InputStream)value);
        }
        if (value instanceof char[]) {
            return new BlobDatum(String.valueOf((char[])value));
        }
        if (value instanceof CharSequence) {
            return new BlobDatum((CharSequence)value);
        }
        if (value instanceof File) {
            return new BlobDatum((File)value);
        }
        if (value instanceof Reader) {
            return new BlobDatum((Reader)value);
        }
        if (value instanceof Datum) {
            Datum datumValue = (Datum)value;
            return new BlobDatum(datumValue.stringValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getLength() throws SQLException {
        if (this.getValue() instanceof Blob) {
            Blob blob = (Blob)this.getValue();
            if (BlobDatum.isEmptyLob(blob)) {
                return 0L;
            }
            return ((Blob)this.getValue()).length();
        }
        return super.getLength();
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = isEqual = this == obj;
        if (!isEqual && obj instanceof BlobDatum) {
            isEqual = super.equals(obj);
        }
        return isEqual;
    }

    @Override
    public InputStream getInputStream() throws IOException, SQLException {
        if (this.getValue() instanceof Blob) {
            Blob blob = (Blob)this.getValue();
            if (BlobDatum.isEmptyLob(blob)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            return blob.getBinaryStream();
        }
        return super.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) throws IOException, SQLException {
        Object value = this.getValue();
        switch (valueType) {
            case DATUM: {
                if (value instanceof Blob) {
                    return value;
                }
                Blob tempBlob = BlobDatum.getTemporaryBlob(connectionProvider.getValidDataTypeConnection());
                BlobDatum.open(tempBlob, 1);
                try {
                    OutputStream ostream = tempBlob.setBinaryStream(1L);
                    BlobDatum.copyBytes(this.getInputStream(), ostream);
                    ostream.close();
                }
                finally {
                    try {
                        BlobDatum.close(tempBlob);
                    }
                    catch (SQLException e) {
                        Logger.getLogger(ClobDatum.class.getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                return tempBlob;
            }
        }
        return super.customTypedValue(connectionProvider, valueType, target);
    }

    public static BlobDatumBuilder getBuilder() {
        return BlobDatum.getBuilder(32768);
    }

    public static BlobDatumBuilder getBuilder(EncodingType encoding, int cutOverLen) {
        return new BlobDatum().getBuilder0(encoding, cutOverLen);
    }

    public static BlobDatumBuilder getBuilder(EncodingType encoding) {
        return BlobDatum.getBuilder(encoding, 32768);
    }

    public static BlobDatumBuilder getBuilder(int cutOverLen) {
        return new BlobDatum().getBuilder0(EncodingType.ENCODING_BASE64, cutOverLen);
    }

    private BlobDatumBuilder getBuilder0(EncodingType encoding, int cutOverLen) {
        return new BlobDatumBuilder(encoding, cutOverLen);
    }

    protected static Blob getTemporaryBlob(Connection connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            return BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
        }
        return connection.createBlob();
    }

    protected static Blob getEmptyBlob(Connection connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            return BLOB.getEmptyBLOB();
        }
        return BlobDatum.getTemporaryBlob(connection);
    }

    protected static boolean isEmptyLob(Blob blob) throws SQLException {
        if (blob instanceof BLOB) {
            return ((BLOB)blob).isEmptyLob();
        }
        return false;
    }

    protected static void open(Blob blob, int mode) throws SQLException {
        BLOB oraBLOB;
        if (blob instanceof BLOB && !(oraBLOB = (BLOB)blob).isEmptyLob() && !oraBLOB.isOpen()) {
            oraBLOB.open(mode);
        }
    }

    protected static void close(Blob blob) throws SQLException {
        BLOB oraBLOB;
        if (blob instanceof BLOB && !(oraBLOB = (BLOB)blob).isEmptyLob() && oraBLOB.isOpen()) {
            oraBLOB.close();
        }
    }

    protected static void free(Blob blob) throws SQLException {
        BLOB oraBLOB;
        if (blob instanceof BLOB && (oraBLOB = (BLOB)blob).isTemporary() && !oraBLOB.isOpen()) {
            oraBLOB.freeTemporary();
        }
        blob.free();
    }

    public class BlobDatumBuilder
    extends LongBinary.LongBinaryBuilder {
        protected BlobDatumBuilder(EncodingType encodingType, int cutOverLen) {
            super(encodingType, cutOverLen);
        }

        @Override
        public BlobDatumBuilder write(Reader reader) throws IOException, EncodingException {
            return (BlobDatumBuilder)super.write(reader);
        }

        @Override
        public BlobDatumBuilder write(InputStream istream) throws IOException {
            return (BlobDatumBuilder)super.write(istream);
        }

        @Override
        public BlobDatum build() throws IOException {
            super.build();
            return BlobDatum.this;
        }
    }
}

