/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.plsql;

import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.plsql.PLSQLDatum;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingBOOLEAN;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.DataValueMapped;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class BOOLEAN
extends PLSQLDatum {
    private final DataType numberType;
    private DataValue trueValue;
    private DataValue falseValue;

    protected BOOLEAN(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
        DataTypeFactory factory = context.getDataTypeFactory();
        TypeMetadata numberMetadata = factory.getTypeMetadata(context.getDataTypeConnectionProvider(), (Integer)2);
        this.numberType = factory.getDataType(context, numberMetadata);
        this.trueValue = null;
        this.falseValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataValue getTrueValue() {
        DataValue value = this.trueValue;
        if (value == null) {
            BOOLEAN bOOLEAN = this;
            synchronized (bOOLEAN) {
                value = this.trueValue;
                if (value == null) {
                    this.trueValue = value = this.getDataValue(Boolean.TRUE);
                }
            }
        }
        return this.trueValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataValue getFalseValue() {
        DataValue value = this.falseValue;
        if (value == null) {
            BOOLEAN bOOLEAN = this;
            synchronized (bOOLEAN) {
                value = this.falseValue;
                if (value == null) {
                    this.falseValue = value = this.getDataValue(Boolean.FALSE);
                }
            }
        }
        return this.falseValue;
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        return new StringValue(this.internalStringValue(value.getInternalValue()));
    }

    private String internalStringValue(Object value) {
        String stringValue = DataTypesUtil.stringValue(value, null);
        if (stringValue != null) {
            Boolean boolValue = null;
            try {
                int intValue = Integer.parseInt(stringValue);
                boolValue = intValue != 0;
            }
            catch (NumberFormatException e) {
                boolValue = Boolean.valueOf(stringValue);
            }
            stringValue = DataTypesUtil.stringValue(boolValue, null);
        }
        return stringValue;
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return Boolean.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 16;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        return Boolean.valueOf(this.internalStringValue(value));
    }

    @Override
    protected String customPlainDataTypeString() {
        return "BOOLEAN";
    }

    @Override
    protected String customBaseDataTypeString() {
        return "PL/SQL BOOLEAN";
    }

    @Override
    protected DataValue customDataValue(Object object) {
        DataValue typedDataValue = super.customDataValue(object);
        Boolean boolValue = (Boolean)typedDataValue.getTypedValue(ValueType.DEFAULT);
        Integer bitValue = boolValue == null ? null : Integer.valueOf(boolValue == true ? 1 : 0);
        DataValue bindingDataValue = this.numberType.getDataValue(bitValue);
        return new DataValueMapped(typedDataValue, bindingDataValue);
    }

    @Override
    public boolean isEnumeration() {
        return true;
    }

    @Override
    public List<DataValue> getEnumerationValues() {
        final DataValue trueValue = this.getTrueValue();
        final DataValue falseValue = this.getFalseValue();
        return new LinkedList<DataValue>(){
            {
                this.add(trueValue);
                this.add(falseValue);
            }
        };
    }

    @Override
    public <P extends DataBinding> BindingStrategy getBind(BindContext context, P param) {
        return new CallableBindingBOOLEAN(context, param, this.numberType);
    }
}

