/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.sql.CHAR;

public abstract class CharacterDatum
extends Datum {
    protected CharacterDatum(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        String stringValue = (String)internalValue;
        try {
            switch (valueType) {
                case DATUM: {
                    return new CHAR(stringValue, CHAR.DEFAULT_CHARSET);
                }
            }
            return super.customTypedValue(connectionProvider, value, valueType, target);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return CHAR.class;
            }
            case DEFAULT: {
                return String.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 1;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof CHAR) {
            CHAR charString = (CHAR)value;
            return charString.stringValue();
        }
        return String.valueOf(value);
    }

    @Override
    protected String customDataTypeString() {
        String _plain_type = this.getPlainDataTypeString();
        String _char_used = this.typeMetadata.get_char_used();
        Integer _char_length = this.typeMetadata.get_char_length();
        return this.buildConstraintedString(_plain_type, _char_used, _char_length);
    }

    @Override
    protected String customConstrainedDataTypeString() {
        Integer _char_length = this.typeMetadata.get_char_length();
        if (_char_length == null || 0 == _char_length) {
            return this.customUnconstrainedDataTypeString();
        }
        return super.customConstrainedDataTypeString();
    }

    @Override
    protected String customUnconstrainedDataTypeString() {
        String _char_used = this.typeMetadata.get_char_used();
        return this.buildConstraintedString(this.getPlainDataTypeString(), _char_used, 2000);
    }

    private String buildConstraintedString(String typeString, String charUsed, Integer charLength) {
        if (typeString != null && charLength != null) {
            StringBuffer buffer = new StringBuffer(typeString);
            if (charUsed != null && "B".equals(charUsed)) {
                buffer.append("(").append(charLength).append(" BYTES").append(")");
            } else if (charUsed != null && "C".equals(charUsed)) {
                buffer.append("(").append(charLength).append(" CHARS").append(")");
            } else {
                buffer.append("(").append(charLength).append(")");
            }
            return buffer.toString();
        }
        return typeString;
    }
}

