/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeEncodingException;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.objects.LongBinary;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingLONGBINARY;
import oracle.dbtools.raptor.datatypes.strategies.preparedstatement.PrepareBindingLONGBINARY;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.util.encoding.EncodingException;
import org.xml.sax.SAXException;

public class LONGBINARY
extends Datum {
    protected LONGBINARY(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        LongBinary longBinary = (LongBinary)value.getInternalValue();
        return longBinary.getStringValue(stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        LongBinary longBinary = (LongBinary)internalValue;
        try {
            switch (valueType) {
                case JDBC: 
                case DATUM: 
                case TARGET: {
                    return longBinary.getTypedValue(connectionProvider, valueType, target);
                }
            }
            return super.customTypedValue(connectionProvider, value, valueType, target);
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
        catch (IOException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return InputStream.class;
            }
            case DEFAULT: {
                return LongBinary.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -4;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            if (value == null) {
                return new LongBinary();
            }
            if (value instanceof LongBinary) {
                return value;
            }
            return LongBinary.constructFrom(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (EncodingException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (IOException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
    }

    @Override
    public <P extends DataBinding> BindingStrategy getBind(BindContext context, P param) {
        if (CallableStatement.class.isAssignableFrom(context.getEffectiveStatementClass())) {
            return new CallableBindingLONGBINARY(context, param);
        }
        return new PrepareBindingLONGBINARY(context, param);
    }

    @Override
    protected void customMarshal(DataTypeConnectionProvider connectionProvider, DataValueInternal value, DataValueMarshalHandler hd, String name) throws SAXException {
        LongBinary longBinary = (LongBinary)value.getInternalValue();
        longBinary.marshal(this, hd, name);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return LongBinary.getBuilder();
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
        LongBinary.LongBinaryBuilder builder = (LongBinary.LongBinaryBuilder)value.getValue();
        try {
            builder.write(ch, start, length);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
        catch (EncodingException e) {
            throw new DataTypeEncodingException(e);
        }
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        LongBinary.LongBinaryBuilder builder = (LongBinary.LongBinaryBuilder)value.getValue();
        try {
            return this.getDataValue(builder != null ? builder.build() : null);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
    }
}

