/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.DataTypeProvider;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.AbstractDataTypeProviderImpl;
import oracle.dbtools.raptor.datatypes.metadata.ArgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.MetadataLoader;
import oracle.dbtools.raptor.datatypes.oracle.sql.ARRAY;
import oracle.dbtools.raptor.datatypes.oracle.sql.BINARY_DOUBLE;
import oracle.dbtools.raptor.datatypes.oracle.sql.BINARY_FLOAT;
import oracle.dbtools.raptor.datatypes.oracle.sql.BLOB;
import oracle.dbtools.raptor.datatypes.oracle.sql.CHAR;
import oracle.dbtools.raptor.datatypes.oracle.sql.CLOB;
import oracle.dbtools.raptor.datatypes.oracle.sql.CURSOR;
import oracle.dbtools.raptor.datatypes.oracle.sql.DATE;
import oracle.dbtools.raptor.datatypes.oracle.sql.FLOAT;
import oracle.dbtools.raptor.datatypes.oracle.sql.INTEGER;
import oracle.dbtools.raptor.datatypes.oracle.sql.INTERVALDS;
import oracle.dbtools.raptor.datatypes.oracle.sql.INTERVALYM;
import oracle.dbtools.raptor.datatypes.oracle.sql.LONGBINARY;
import oracle.dbtools.raptor.datatypes.oracle.sql.LONGVARCHAR;
import oracle.dbtools.raptor.datatypes.oracle.sql.NUMBER;
import oracle.dbtools.raptor.datatypes.oracle.sql.RAW;
import oracle.dbtools.raptor.datatypes.oracle.sql.ROWID;
import oracle.dbtools.raptor.datatypes.oracle.sql.STRUCT;
import oracle.dbtools.raptor.datatypes.oracle.sql.TIMESTAMP;
import oracle.dbtools.raptor.datatypes.oracle.sql.TIMESTAMPLTZ;
import oracle.dbtools.raptor.datatypes.oracle.sql.TIMESTAMPTZ;
import oracle.dbtools.raptor.datatypes.oracle.sql.VARCHAR;
import oracle.dbtools.raptor.datatypes.oracle.sql.XMLTYPE;

public final class OracleSQLDataTypeFactory
extends AbstractDataTypeProviderImpl {
    private final SQLDataTypeProviderAccess providerAccess = new SQLDataTypeProviderAccess();
    private static final String TABLE = "TABLE";
    private static final String ARRAY = "ARRAY";
    private static final String VARRAY = "VARRAY";
    private static final String VARYING_ARRAY = "VARYING ARRAY";
    private static final Map<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> typeMetadataProps = new HashMap<String, NamedValue<Map<TypeMetadata.Attribute, Object>>>(){
        {
            this.put("NUMBER", new NamedValue<1>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 2);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, NUMBER.class);
                    this.put(TypeMetadata.Attribute.DATA_LENGTH, 22);
                    this.put(TypeMetadata.Attribute.DATA_RADIX, 10);
                }
            }));
            this.put("NUMERIC", new NamedValue<2>("NUMBER", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "NUMERIC");
                }
            }));
            this.put("DECIMAL", new NamedValue<3>("NUMERIC", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 3);
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "DECIMAL");
                }
            }));
            this.put("DEC", new NamedValue<Object>("DECIMAL", null));
            this.put("NUMBER(38)", new NamedValue<4>("NUMBER", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.DATA_PRECISION, 38);
                    this.put(TypeMetadata.Attribute.DATA_SCALE, 0);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, INTEGER.class);
                }
            }));
            this.put("INTEGER", new NamedValue<5>("NUMBER(38)", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 4);
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "INTEGER");
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, INTEGER.class);
                }
            }));
            this.put("INT", new NamedValue<Object>("INTEGER", null));
            this.put("SMALLINT", new NamedValue<6>("INTEGER", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 5);
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "SMALLINT");
                }
            }));
            this.put("FLOAT", new NamedValue<7>("NUMBER", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 6);
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "FLOAT");
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, FLOAT.class);
                }
            }));
            this.put("FLOAT(63)", new NamedValue<8>("FLOAT", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.DATA_PRECISION, 63);
                }
            }));
            this.put("FLOAT(126)", new NamedValue<9>("FLOAT", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.DATA_PRECISION, 126);
                }
            }));
            this.put("DOUBLE PRECISION", new NamedValue<10>("FLOAT(126)", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 8);
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "DOUBLE PRECISION");
                }
            }));
            this.put("REAL", new NamedValue<11>("FLOAT(63)", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 7);
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "REAL");
                }
            }));
            this.put("BINARY_FLOAT", new NamedValue<12>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 100);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, BINARY_FLOAT.class);
                    this.put(TypeMetadata.Attribute.DATA_LENGTH, 4);
                    this.put(TypeMetadata.Attribute.DATA_RADIX, 10);
                }
            }));
            this.put("BINARY_DOUBLE", new NamedValue<13>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 101);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, BINARY_DOUBLE.class);
                    this.put(TypeMetadata.Attribute.DATA_LENGTH, 8);
                    this.put(TypeMetadata.Attribute.DATA_RADIX, 10);
                }
            }));
            this.put("CHAR", new NamedValue<14>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 1);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, CHAR.class);
                }
            }));
            this.put("CHARACTER", new NamedValue<Object>("CHAR", null));
            this.put("VARCHAR", new NamedValue<15>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 12);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, VARCHAR.class);
                }
            }));
            this.put("VARCHAR2", new NamedValue<16>("VARCHAR", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "VARCHAR2");
                }
            }));
            this.put("CHAR VARYING", new NamedValue<17>("VARCHAR", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "CHAR VARYING");
                }
            }));
            this.put("CHARACTER VARYING", new NamedValue<Object>("CHAR VARYING", null));
            this.put("LONG", new NamedValue<18>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -1);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, LONGVARCHAR.class);
                }
            }));
            this.put("NCHAR", new NamedValue<19>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -15);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, CHAR.class);
                }
            }));
            this.put("NATIONAL CHAR", new NamedValue<Object>("NCHAR", null));
            this.put("NATIONAL CHARACTER", new NamedValue<Object>("NCHAR", null));
            this.put("NVARCHAR", new NamedValue<20>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -9);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, VARCHAR.class);
                }
            }));
            this.put("NVARCHAR2", new NamedValue<21>("NVARCHAR", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "NVARCHAR2");
                }
            }));
            this.put("NCHAR VARYING", new NamedValue<22>("NVARCHAR", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "NCHAR VARYING");
                }
            }));
            this.put("NATIONAL CHAR VARYING", new NamedValue<Object>("NCHAR VARYING", null));
            this.put("NATIONAL CHARACTER VARYING", new NamedValue<Object>("NCHAR VARYING", null));
            this.put("DATE", new NamedValue<23>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 91);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, DATE.class);
                    this.put(TypeMetadata.Attribute.DATA_LENGTH, 7);
                }
            }));
            this.put("TIMESTAMP", new NamedValue<24>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 93);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, TIMESTAMP.class);
                    this.put(TypeMetadata.Attribute.DATA_LENGTH, 11);
                    this.put(TypeMetadata.Attribute.DATA_SCALE, 6);
                }
            }));
            this.put("TIMESTAMP(6)", new NamedValue<Object>("TIMESTAMP", null));
            this.put("TIMESTAMP WITH TIME ZONE", new NamedValue<25>("TIMESTAMP", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -101);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, TIMESTAMPTZ.class);
                    this.put(TypeMetadata.Attribute.DATA_LENGTH, 13);
                    this.put(TypeMetadata.Attribute.DATA_SCALE, 6);
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "TIMESTAMP WITH TIME ZONE");
                }
            }));
            this.put("TIMESTAMP(6) WITH TIME ZONE", new NamedValue<Object>("TIMESTAMP WITH TIME ZONE", null));
            this.put("TIMESTAMP WITH LOCAL TIME ZONE", new NamedValue<26>("TIMESTAMP", new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -102);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, TIMESTAMPLTZ.class);
                    this.put(TypeMetadata.Attribute.DATA_LENGTH, 11);
                    this.put(TypeMetadata.Attribute.DATA_SCALE, 6);
                    this.put(TypeMetadata.Attribute.BASE_TYPE, "TIMESTAMP WITH LOCAL TIME ZONE");
                }
            }));
            this.put("TIMESTAMP(6) WITH LOCAL TIME ZONE", new NamedValue<Object>("TIMESTAMP WITH LOCAL TIME ZONE", null));
            this.put("INTERVAL YEAR TO MONTH", new NamedValue<27>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -103);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, INTERVALYM.class);
                    this.put(TypeMetadata.Attribute.DATA_PRECISION, 2);
                    this.put(TypeMetadata.Attribute.DATA_SCALE, 0);
                }
            }));
            this.put("INTERVAL YEAR(2) TO MONTH", new NamedValue<Object>("INTERVAL YEAR TO MONTH", null));
            this.put("INTERVALYM", new NamedValue<Object>("INTERVAL YEAR TO MONTH", null));
            this.put("INTERVAL DAY TO SECOND", new NamedValue<28>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -104);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, INTERVALDS.class);
                    this.put(TypeMetadata.Attribute.DATA_LENGTH, 11);
                    this.put(TypeMetadata.Attribute.DATA_PRECISION, 2);
                    this.put(TypeMetadata.Attribute.DATA_SCALE, 6);
                }
            }));
            this.put("INTERVAL DAY(2) TO SECOND(6)", new NamedValue<Object>("INTERVAL DAY TO SECOND", null));
            this.put("INTERVALDS", new NamedValue<Object>("INTERVAL DAY TO SECOND", null));
            this.put("ROWID", new NamedValue<29>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -8);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, ROWID.class);
                    this.put(TypeMetadata.Attribute.DATA_LENGTH, 10);
                }
            }));
            this.put("RAW", new NamedValue<30>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -3);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, RAW.class);
                }
            }));
            this.put("LONG RAW", new NamedValue<31>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -4);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, LONGBINARY.class);
                }
            }));
            this.put(OracleSQLDataTypeFactory.ARRAY, new NamedValue<32>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.BASE_TYPE, OracleSQLDataTypeFactory.VARRAY);
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 2003);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, ARRAY.class);
                    this.put(TypeMetadata.Attribute.TYPE_COMPONENTS, null);
                }
            }));
            this.put(OracleSQLDataTypeFactory.VARYING_ARRAY, new NamedValue<Object>(OracleSQLDataTypeFactory.ARRAY, null));
            this.put(OracleSQLDataTypeFactory.VARRAY, new NamedValue<Object>(OracleSQLDataTypeFactory.VARYING_ARRAY, null));
            this.put(OracleSQLDataTypeFactory.TABLE, new NamedValue<33>(OracleSQLDataTypeFactory.VARRAY, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.BASE_TYPE, OracleSQLDataTypeFactory.TABLE);
                }
            }));
            this.put("CLOB", new NamedValue<34>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 2005);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, CLOB.class);
                }
            }));
            this.put("NCLOB", new NamedValue<35>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 2011);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, CLOB.class);
                }
            }));
            this.put("BLOB", new NamedValue<36>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 2004);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, BLOB.class);
                }
            }));
            this.put("STRUCT", new NamedValue<37>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 2002);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, STRUCT.class);
                    this.put(TypeMetadata.Attribute.TYPE_COMPONENTS, null);
                }
            }));
            this.put("OBJECT", new NamedValue<Object>("STRUCT", null));
            this.put("CURSOR", new NamedValue<38>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, -10);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, CURSOR.class);
                }
            }));
            this.put("REF CURSOR", new NamedValue<Object>("CURSOR", null));
            this.put("XMLTYPE", new NamedValue<39>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                {
                    this.put(TypeMetadata.Attribute.TYPE_CODE, 2007);
                    this.put(TypeMetadata.Attribute.IMPL_CLASS, XMLTYPE.class);
                }
            }));
        }
    };

    @Override
    protected SQLDataTypeProviderAccess getDataTypeProviderAccess() {
        return this.providerAccess;
    }

    public static Builder builder(URI dataTypeProviderURI) {
        return new Builder(dataTypeProviderURI);
    }

    private OracleSQLDataTypeFactory(DataTypeFactoryExtension.ExtensionAccess extensionAccess, URI dataTypeProviderURI, DataTypeProvider next, Map<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> typeMetadataProps) {
        super(extensionAccess, dataTypeProviderURI, next, typeMetadataProps);
    }

    protected boolean isStructuredType(String typeName) {
        return TABLE.equals(typeName) || ARRAY.equals(typeName) || VARRAY.equals(typeName) || VARYING_ARRAY.equals(typeName);
    }

    @Override
    protected boolean customSupportedType(TypeMetadata typeMetadata) {
        return super.customSupportedType(typeMetadata) && typeMetadata.get_type_subname() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TypeMetadata customRefineTypeMetadata(DataTypeContext context, TypeMetadata typeMetadata) {
        TypeMetadata candidate;
        block38: {
            candidate = typeMetadata;
            boolean triedSynonym = false;
            while (true) {
                HashMap<TypeMetadata.Attribute, Object> attributeMap;
                DataTypeConnectionProvider provider;
                Object conn;
                String type_owner;
                if ((type_owner = candidate.get_type_owner()) == null) {
                    return candidate;
                }
                String type_name = candidate.get_type_name();
                if (type_name == null || candidate.get_type_link() != null) {
                    return candidate;
                }
                String data_type = candidate.get_data_type();
                if (data_type == null) {
                    HashMap<TypeMetadata.Attribute, Object> attributeMap2 = new HashMap<TypeMetadata.Attribute, Object>();
                    if ("SYS".equals(type_owner)) {
                        if ("XMLTYPE".equals(type_name)) {
                            data_type = type_name;
                            attributeMap2.put(TypeMetadata.Attribute.DATA_TYPE, data_type);
                        }
                    } else if ("PUBLIC".equals(type_owner) && ("CLOB".equals(type_name) || "BLOB".equals(type_name))) {
                        data_type = type_name;
                        attributeMap2.put(TypeMetadata.Attribute.DATA_TYPE, data_type);
                    }
                    if (!attributeMap2.isEmpty()) {
                        return DataTypeFactory.getTypeMetadata(candidate, attributeMap2);
                    }
                    DataTypeConnectionProvider provider2 = context.getDataTypeConnectionProvider();
                    conn = provider2.getDataTypeConnection();
                    if (conn != null) {
                        provider2.lockDataTypeConnection();
                        try {
                            new MetadataLoader((Connection)conn).loadSQLType(attributeMap2, type_owner, type_name);
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            provider2.unlockDataTypeConnection();
                        }
                    }
                    if (!attributeMap2.isEmpty()) {
                        candidate = DataTypeFactory.getTypeMetadata(candidate, attributeMap2);
                        data_type = candidate.get_data_type();
                    }
                }
                if ("COLLECTION".equals(data_type)) {
                    provider = context.getDataTypeConnectionProvider();
                    attributeMap = new HashMap<TypeMetadata.Attribute, Object>();
                    conn = provider.getDataTypeConnection();
                    if (conn != null) {
                        provider.lockDataTypeConnection();
                        try {
                            LinkedList<ArgMetadata> loadStack = new LinkedList<ArgMetadata>();
                            new MetadataLoader((Connection)conn).loadSQLCollection(loadStack, type_owner, type_name, 0);
                            if (!loadStack.isEmpty()) {
                                ArgMetadata collArgMetadata = (ArgMetadata)loadStack.pop();
                                String collType = (String)((Map)collArgMetadata.getValue()).get((Object)TypeMetadata.Attribute.DATA_TYPE);
                                attributeMap.put(TypeMetadata.Attribute.DATA_TYPE, collType);
                                List<NamedValue<TypeMetadata>> typeComponents = candidate.get_type_components();
                                if (typeComponents == null) {
                                    LinkedList<NamedValue<TypeMetadata>> components = new LinkedList<NamedValue<TypeMetadata>>();
                                    while (!loadStack.isEmpty() && ((ArgMetadata)loadStack.peek()).getIdentifier().getLevel() == 1) {
                                        ArgMetadata componentArgMetadata = (ArgMetadata)loadStack.pop();
                                        TypeMetadata componentTypeMetadata = context.getDataTypeFactory().getTypeMetadata((Map)componentArgMetadata.getValue());
                                        components.add(new NamedValue<TypeMetadata>(componentArgMetadata.getName(), componentTypeMetadata));
                                    }
                                    if (components.size() > 0) {
                                        attributeMap.put(TypeMetadata.Attribute.TYPE_COMPONENTS, components);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            provider.unlockDataTypeConnection();
                        }
                    }
                    if (!attributeMap.isEmpty()) {
                        return DataTypeFactory.getTypeMetadata(candidate, attributeMap);
                    }
                } else if (data_type != null) break block38;
                if (candidate != typeMetadata) break block38;
                if (triedSynonym) {
                    return candidate;
                }
                triedSynonym = true;
                provider = context.getDataTypeConnectionProvider();
                attributeMap = new HashMap();
                conn = provider.getDataTypeConnection();
                if (conn != null) {
                    provider.lockDataTypeConnection();
                    try {
                        new MetadataLoader((Connection)conn).followSQLSynonym(attributeMap, type_owner, type_name);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        provider.unlockDataTypeConnection();
                    }
                }
                if (attributeMap.isEmpty()) break;
                candidate = DataTypeFactory.getTypeMetadata(candidate, attributeMap);
            }
            return candidate;
        }
        return candidate;
    }

    @Override
    public void close() throws IOException {
    }

    public static final class Builder
    extends AbstractDataTypeProviderImpl.Builder {
        public static final URI ID;

        private Builder(URI dataTypeProviderURI) {
            super(dataTypeProviderURI);
        }

        @Override
        public SQLDataTypeProviderAccess build() {
            OracleSQLDataTypeFactory datatypeFactory = new OracleSQLDataTypeFactory(this.getExtensionAccess(), this.getDataTypeProviderURI(), this.getExtensionAccess().resolveDataTypeProvider(this.getSuperDataTypeProviderURI()), typeMetadataProps);
            return datatypeFactory.getDataTypeProviderAccess();
        }

        @Override
        public Builder setExtensionAccess(DataTypeFactoryExtension.ExtensionAccess extensionAccess) {
            super.setExtensionAccess(extensionAccess);
            return this;
        }

        @Override
        public Builder setSuperDataTypeProviderURI(URI superDataTypeProvider) {
            super.setSuperDataTypeProviderURI(superDataTypeProvider);
            return this;
        }

        static {
            URI tmpURI = null;
            try {
                tmpURI = new URI("http://www.oracle.com/raptor/datatypes/providers/sql/");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            ID = tmpURI;
        }
    }

    public class SQLDataTypeProviderAccess
    implements DataTypeProvider.DataTypeProviderAccess {
        protected SQLDataTypeProviderAccess() {
        }

        @Override
        public DataTypeProvider getDataTypeProvider() {
            return OracleSQLDataTypeFactory.this;
        }

        @Override
        public DataTypeFactoryExtension.ExtensionAccess getExtensionAccess() {
            return OracleSQLDataTypeFactory.this.getExtensionAccess();
        }

        @Override
        public DataTypeFactory getDataTypeFactory() {
            return this.getExtensionAccess().getDataTypeFactory();
        }
    }
}

