/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Closeables;
import oracle.jdbc.OracleResultSet;

public class ResultSetFormatterWrapper
extends ResultsFormatterWrapper {
    private ResultSet m_rs;
    private ResultSetMetaData m_meta;
    private String m_sql;
    private int[] m_dataTypes;
    private ObjectType m_objectType = ObjectType.PROPRIETARY;
    private int _maxRows = 0;
    private ArrayList<Integer> m_exportCols = null;

    protected ResultSetFormatterWrapper() {
        this.m_objectType = ObjectType.PROPRIETARY;
    }

    public ResultSetFormatterWrapper(ResultSet rs, int maxRows) {
        this(rs, ObjectType.PROPRIETARY);
        this._maxRows = maxRows;
    }

    public ResultSetFormatterWrapper(ResultSet rs, ObjectType objectType) {
        this.setResultSet(rs, objectType);
    }

    public ResultSetFormatterWrapper(ResultSet rs, ArrayList<Integer> exportCols, List<String> exportColNames, int[] exportSizes, int[] exportDataTypes, String sql) {
        this.m_rs = rs;
        this.m_sql = sql;
        this.m_exportCols = exportCols;
        this.setColumnNames(exportColNames);
        this.setColumnSizes(exportSizes);
        this.setPrecisions(exportSizes);
        this.m_dataTypes = exportDataTypes;
    }

    public ResultSetFormatterWrapper(ResultSet rs, ArrayList<Integer> exportCols, String sql) {
        this.m_sql = sql;
        this.m_exportCols = exportCols;
        this.setResultSet(rs);
    }

    public ResultSetFormatterWrapper(ResultSet rs, ArrayList<Integer> exportCols) {
        this.m_exportCols = exportCols;
        this.setResultSet(rs);
    }

    protected void setResultSet(ResultSet rs) {
        this.m_rs = rs;
        String columnName = "";
        try {
            this.m_meta = this.m_rs.getMetaData();
            int[] colSizes = this.m_exportCols == null ? new int[this.m_meta.getColumnCount() + 1] : new int[this.m_exportCols.size() + 1];
            int[] precisions = this.m_exportCols == null ? new int[this.m_meta.getColumnCount() + 1] : new int[this.m_exportCols.size() + 1];
            int[] scales = this.m_exportCols == null ? new int[this.m_meta.getColumnCount() + 1] : new int[this.m_exportCols.size() + 1];
            ArrayList<String> colNames = new ArrayList<String>();
            int colCount = 0;
            colCount = this.m_exportCols == null ? this.m_meta.getColumnCount() : this.m_exportCols.size();
            for (int i = 0; i < colCount; ++i) {
                if (this.m_exportCols == null) {
                    columnName = this.m_meta.getColumnName(i + 1);
                    colNames.add(columnName);
                    switch (this.m_meta.getColumnType(i + 1)) {
                        case 91: 
                        case 92: 
                        case 93: {
                            colSizes[i] = 25;
                            break;
                        }
                        default: {
                            colSizes[i] = columnName.length();
                        }
                    }
                    scales[i] = this.m_meta.getScale(i + 1);
                    precisions[i] = this.m_meta.getPrecision(i + 1);
                    continue;
                }
                columnName = this.m_meta.getColumnName(this.m_exportCols.get(i) + 1);
                colNames.add(columnName);
                switch (this.m_meta.getColumnType(this.m_exportCols.get(i) + 1)) {
                    case 91: 
                    case 92: 
                    case 93: {
                        colSizes[i] = 25;
                        break;
                    }
                    default: {
                        colSizes[i] = columnName.length();
                    }
                }
                scales[i] = this.m_meta.getScale(this.m_exportCols.get(i) + 1);
                precisions[i] = this.m_meta.getPrecision(this.m_exportCols.get(i) + 1);
            }
            this.setColumnNames(colNames);
            this.setColumnSizes(colSizes);
            this.setScales(scales);
            this.setPrecisions(precisions);
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
    }

    protected void setResultSet(ResultSet rs, ObjectType objectType) {
        this.m_objectType = objectType;
        this.setResultSet(rs);
    }

    @Override
    public Connection getConnection() {
        Connection conn = null;
        try {
            conn = this.m_rs.getStatement().getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return conn;
    }

    @Override
    public int getDataType(int col) throws SQLException {
        if (this.m_exportCols == null) {
            String colTypeName = this.m_meta.getColumnTypeName(col + 1);
            return this.m_meta.getColumnType(col + 1);
        }
        if (this.m_dataTypes == null) {
            return this.m_meta.getColumnType(this.m_exportCols.get(col) + 1);
        }
        return this.m_dataTypes[col];
    }

    @Override
    public String getDataTypeName(int col) throws SQLException {
        if (this.m_exportCols == null) {
            String colTypeName = this.m_meta.getColumnTypeName(col + 1);
            return colTypeName;
        }
        if (this.m_dataTypes == null) {
            return this.m_meta.getColumnTypeName(this.m_exportCols.get(col) + 1);
        }
        return this.m_meta.getColumnTypeName(this.m_dataTypes[col] + 1);
    }

    @Override
    public int print() throws IOException {
        int ret = 0;
        try {
            ret = this.print(null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public String getSQL() {
        return this.m_sql;
    }

    @Override
    public int print(IRaptorTaskProgressUpdater updater) throws IOException, ExecutionException {
        int ret = 0;
        this.m_formatter.start();
        try {
            this.m_rowNum = 0L;
            while (this.m_rs != null && (this.m_formatter.isCandidateForSpoolMax().booleanValue() && ResultSetFormatter.replaceNext(this.m_rowNum, this._maxRows, this.m_formatter.getScriptContext(), this.m_formatter.getOutputStream(), this.m_rs, null, this.m_formatter) || !this.m_formatter.isCandidateForSpoolMax().booleanValue() && this.m_rs.next()) && (this._maxRows == 0 || this.m_rowNum < (long)this._maxRows || ResultSetFormatter.maxRowsSpoolOnly(this.m_formatter.getScriptContext()))) {
                int ii;
                if (updater != null) {
                    updater.checkCanProceed();
                } else if (this.isInterrupted()) {
                    this.m_rs.getStatement().cancel();
                    break;
                }
                ++this.m_rowNum;
                this.m_formatter.log(Messages.getString("ResultSetFormatterWrapper.1") + this.m_rs.getRow());
                this.m_formatter.startRow();
                Object o = null;
                if (this.m_exportCols == null) {
                    for (ii = 0; ii < this.m_meta.getColumnCount(); ++ii) {
                        if (this.m_objectType == ObjectType.PROPRIETARY && this.m_rs instanceof OracleResultSet) {
                            try {
                                o = ScriptUtils.getOracleObjectWrap((OracleResultSet)this.m_rs, ii + 1);
                            }
                            catch (SQLException e) {
                                o = this.m_rs.getObject(ii + 1);
                            }
                        } else {
                            o = this.m_rs.getObject(ii + 1);
                        }
                        this.m_formatter.printColumn(o, ii, ii);
                    }
                } else {
                    for (ii = 0; ii < this.m_exportCols.size(); ++ii) {
                        o = this.m_objectType == ObjectType.PROPRIETARY && this.m_rs instanceof OracleResultSet ? ScriptUtils.getOracleObjectWrap((OracleResultSet)this.m_rs, this.m_exportCols.get(ii) + 1) : this.m_rs.getObject(this.m_exportCols.get(ii) + 1);
                        this.m_formatter.printColumn(o, ii, ii);
                    }
                }
                if (o instanceof ResultSet) {
                    Closeables.close((ResultSet)o);
                }
                this.m_formatter.endRow();
                ret = this.m_rs.getRow();
            }
        }
        catch (ExecutionException e) {
            try {
                if (this.m_rs != null) {
                    this.m_rs.getStatement().cancel();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        this.m_formatter.end();
        return ret;
    }

    @Override
    public void close() {
        if (this.m_rs != null) {
            DBUtil.closeResultSet(this.m_rs);
        }
    }

    public static enum ObjectType {
        GENERIC,
        PROPRIETARY;

    }
}

