/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.IResultsFormatterWrapper;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.util.ZipOutputHandler;

public abstract class ResultsFormatter
implements IResultFormatter {
    private static final Logger LOGGER = Logger.getLogger(ResultsFormatter.class.getName());
    protected final int FLUSH_EVERY_N_WRITE = 20;
    public static final int CONTINUE = 0;
    public static final int CANCEL_WITH_MSG = 1;
    public static final int CANCEL = 2;
    protected int _writeTracker = 0;
    protected ResultsFormatterWrapper m_wrapper;
    protected int _format;
    protected Writer _out;
    protected ZipOutputHandler _zipper;
    private ArrayList<String> m_addToControllingFile = new ArrayList();
    protected String _type;
    protected String _filter;
    protected String _ext;
    protected Boolean _prompt = false;
    protected Object _dbObject;
    protected String _EOLChars;
    protected String _EOLCharsString;
    protected String _delimiter;
    protected boolean _isEnclosed = true;
    protected String _enclosureLeft = "\"";
    protected String _enclosureRight;
    protected String _replacableEnclosureRight = this._enclosureRight = "\"";
    protected boolean _isEnclosureRightDoubled = true;
    protected String _nullValue = "";
    protected String _validationMessage;
    private OutputStream _outStream;
    private String _enc;
    private String _fileName;
    private boolean _isDeployCloud;
    private IRaptorTaskProgressUpdater _updater;
    private ScriptRunnerContext _scriptCtx;
    private static final String MIME = "text/plain";

    @Override
    public Object getDbObject() {
        return this._dbObject;
    }

    @Override
    public void setDbObject(Object dbobject) {
        this._dbObject = dbobject;
    }

    public ResultsFormatter(String type, String filter, String ext) {
        this._type = type;
        this._ext = ext;
        this._filter = filter;
    }

    @Override
    public String getMimeType() {
        return MIME;
    }

    @Override
    public void startExport() {
    }

    @Override
    public void finishExport() {
    }

    @Override
    public boolean isColumnListFilterable() {
        return true;
    }

    @Override
    public boolean isTextEditorReadable() {
        return true;
    }

    @Override
    public boolean isStandardEncodings() {
        return true;
    }

    @Override
    public String[] getEncodings() {
        return null;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    @Override
    public String getEncode() {
        return this._enc;
    }

    @Override
    public void setEncode(String enc) {
        this._enc = enc;
    }

    @Override
    public boolean isDeployCloud() {
        return this._isDeployCloud;
    }

    @Override
    public void isDeployCloud(boolean isDeployCloud) {
        this._isDeployCloud = isDeployCloud;
    }

    @Override
    public Boolean getPromptForTable() {
        return this._prompt;
    }

    @Override
    public void setPromptForTable(Boolean prompt) {
        this._prompt = prompt;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getExt() {
        return this._ext;
    }

    @Override
    public String getFilter() {
        return this._filter;
    }

    @Override
    public void setDataProvider(IResultsFormatterWrapper wrapper) {
        this.m_wrapper = (ResultsFormatterWrapper)wrapper;
        this.m_wrapper.setParent(this);
    }

    protected ResultsFormatterWrapper getWrapper() {
        return this.m_wrapper;
    }

    protected String getColumnName(int col) {
        return this.m_wrapper.getColumnName(col);
    }

    protected int getColumnSize(int col) {
        return this.m_wrapper.getColumnSize(col);
    }

    protected int getPrecision(int col) {
        return this.m_wrapper.getPrecision(col);
    }

    protected int getScale(int col) {
        return this.m_wrapper.getScale(col);
    }

    protected int getColumnCount() {
        return this.m_wrapper.getColumnCount();
    }

    public void print(Writer out) {
        this.print(out, null);
    }

    public void print(Writer out, IRaptorTaskProgressUpdater taskUpdater) {
        this._out = out;
        this._updater = taskUpdater;
        this.print();
    }

    @Override
    public boolean isStreamHandler() {
        return false;
    }

    @Override
    public void flushStream() {
    }

    @Override
    public void closeStream() {
    }

    @Override
    public int validateOptions() {
        return 0;
    }

    @Override
    public String getValidationMessage() {
        return this._validationMessage;
    }

    @Override
    public void setValidationMessage(String value) {
        this._validationMessage = value;
    }

    @Override
    public boolean allowsLobs() {
        return false;
    }

    @Override
    public boolean isHeaderOptionSupported() {
        return false;
    }

    @Override
    public void isHeader(boolean isHeader) {
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public String getHeaderConfigKey() {
        return "";
    }

    @Override
    public boolean isSeparateDataFileSupported() {
        return false;
    }

    @Override
    public boolean isSeparateDataFile() {
        return false;
    }

    @Override
    public void isSeparateDataFile(boolean value) {
    }

    @Override
    public String getSeparateDataFileConfigKey() {
        return "";
    }

    @Override
    public boolean isCommitSupported() {
        return false;
    }

    @Override
    public boolean isCommit() {
        return false;
    }

    public int getCommitRows() {
        return 0;
    }

    public void setCommitRows(int value) {
    }

    @Override
    public void isCommit(boolean value) {
    }

    @Override
    public String getCommitConfigKey() {
        return "";
    }

    @Override
    public String getCommitRowsConfigKey() {
        return "";
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return false;
    }

    @Override
    public void setLineTerminator(String terminator) {
        this._EOLChars = terminator;
    }

    public void setLineTerminatorString(String terminator) {
        this._EOLCharsString = terminator;
    }

    public String getLineTerminatorString() {
        return this._EOLCharsString;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return "";
    }

    @Override
    public boolean isDelimiterSupported() {
        return false;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return false;
    }

    @Override
    public String getDefaultDelimiter() {
        return "";
    }

    @Override
    public String getDelimiter() {
        return this._delimiter;
    }

    @Override
    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    @Override
    public String getDelimiterConfigKey() {
        return "";
    }

    @Override
    public boolean isEnclosuresSupported() {
        return false;
    }

    public void setEnclosures(boolean isEnclosed, String enclosureLeft, String enclosureRight, boolean isEnclosureRightDoubled) {
        this._isEnclosed = isEnclosed;
        this._enclosureLeft = enclosureLeft;
        this._enclosureRight = enclosureRight;
        this._replacableEnclosureRight = this.handleSpecialEnclosure(enclosureRight);
        this._isEnclosureRightDoubled = isEnclosureRightDoubled;
    }

    @Override
    public void isEnclosed(boolean isEnclosed) {
        this._isEnclosed = isEnclosed;
    }

    @Override
    public boolean isEnclosed() {
        return this._isEnclosed;
    }

    @Override
    public String getEnclosureLeft() {
        return this._enclosureLeft;
    }

    @Override
    public void setEnclosureLeft(String enclosureLeft) {
        this._enclosureLeft = enclosureLeft;
    }

    @Override
    public String getEnclosureRight() {
        return this._enclosureRight;
    }

    @Override
    public void setEnclosureRight(String enclosureRight) {
        this._enclosureRight = enclosureRight;
    }

    @Override
    public String getEnclosuresConfigKey() {
        return "";
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return "";
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return "";
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return "";
    }

    @Override
    public boolean isEnclosureRightDoubleConfigurable() {
        return true;
    }

    @Override
    public boolean isTableNameSupported() {
        return false;
    }

    @Override
    public boolean isDataNameSupported() {
        return false;
    }

    @Override
    public String getDataName() {
        return "";
    }

    @Override
    public void setDataName(String name) {
    }

    @Override
    public String getDataNameConfigKey() {
        return "";
    }

    @Override
    public boolean isQuerySupported() {
        return false;
    }

    @Override
    public boolean isQuerySaved() {
        return false;
    }

    @Override
    public void isQuerySaved(boolean value) {
    }

    @Override
    public String getQueryName() {
        return "";
    }

    @Override
    public void setQueryName(String name) {
    }

    @Override
    public String getQueryConfigKey() {
        return "";
    }

    @Override
    public String getQueryNameConfigKey() {
        return "";
    }

    public boolean isTruncateSupported() {
        return false;
    }

    public boolean isTruncate() {
        return false;
    }

    public void isTruncate(boolean value) {
    }

    @Override
    public int print() {
        int ret = 0;
        try {
            if (this.getScriptContext() != null && this.getScriptContext().getTaskProgressUpdater() != null && this._updater == null) {
                this._updater = this.getScriptContext().getTaskProgressUpdater();
            }
            ret = this._updater != null ? this.m_wrapper.print(this._updater) : this.m_wrapper.print();
        }
        catch (ExecutionException e1) {
            if (e1.getCause() instanceof CancellationException) {
                LOGGER.log(Level.INFO, Messages.getString("ResultsFormatter.15"));
            } else {
                LOGGER.log(Level.WARNING, e1.getStackTrace()[0].toString(), e1);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        finally {
            if (this._out != null) {
                try {
                    this._out.flush();
                }
                catch (IOException e1) {}
            }
        }
        return ret;
    }

    protected void write(String s) throws IOException {
        if (s != null) {
            if (this._zipper != null) {
                this._zipper.writeEntryText(s);
            } else if (this._out != null) {
                this._out.write(s);
            }
            this.checkAndFlush();
        }
    }

    protected void checkAndFlush() throws IOException {
        if (this._writeTracker < 20) {
            ++this._writeTracker;
        } else {
            if (this._out != null) {
                this._out.flush();
            }
            this._writeTracker = 0;
        }
    }

    protected void addToControllingFile(String fileName) {
        this.m_addToControllingFile.add(fileName);
    }

    public ArrayList<String> getAddToControllingFile() {
        ArrayList<String> rtn = this.m_addToControllingFile;
        this.m_addToControllingFile = new ArrayList();
        return rtn;
    }

    @Override
    public void log(String s) {
        if (this._updater != null) {
            this._updater.getDescriptor().setMessage(s);
        }
    }

    @Override
    public Writer getOutWriter() {
        return this._out;
    }

    @Override
    public void setOutWriter(Writer out) {
        this._zipper = null;
        this._out = out;
    }

    @Override
    public OutputStream getOutputStream() {
        return this._outStream;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this._outStream = out;
        if (this._out == null && this._enc != null) {
            try {
                this._out = new OutputStreamWriter(out, this._enc);
            }
            catch (UnsupportedEncodingException e) {
                this._out = new OutputStreamWriter(out);
            }
        }
    }

    @Override
    public void setZipper(ZipOutputHandler zipper) {
        this._zipper = zipper;
        this._out = null;
    }

    @Override
    public ZipOutputHandler getZipper() {
        return this._zipper;
    }

    public void setUpdater(IRaptorTaskProgressUpdater updater) {
        this._updater = updater;
    }

    public void interrupt() {
    }

    public ResultsFormatterWrapper getResultsFormatterWrapper() {
        return this.m_wrapper;
    }

    protected Object getValue(Object obj) {
        return this.m_wrapper.getValue(obj);
    }

    public int getDataType(int colIdx) {
        int ret = -1;
        try {
            ret = this.m_wrapper.getDataType(colIdx);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return ret;
    }

    public String getDataTypeName(int colIdx) {
        String ret = "";
        try {
            ret = this.m_wrapper.getDataTypeName(colIdx);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return ret;
    }

    public String getTimeStampFormat() {
        return NLSUtils.getTimeStampFormat(this.m_wrapper.getConnection());
    }

    public String getTimeStampTZFormat() {
        return NLSUtils.getTimeStampWithTimeZoneFormat(this.m_wrapper.getConnection());
    }

    public String getDateFormat() {
        return NLSUtils.getDateFormat(this.m_wrapper.getConnection());
    }

    public String getFormattedDATE(Object obj) {
        return NLSUtils.format(this.m_wrapper.getConnection(), obj);
    }

    public String enclosureRightDouble(String value) {
        return value.replaceAll(this._replacableEnclosureRight, this._replacableEnclosureRight + this._replacableEnclosureRight);
    }

    public String handleSpecialEnclosure(String value) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char thisChar = value.charAt(i);
            if (thisChar == ')') {
                sb.append('\\');
                sb.append(thisChar);
                continue;
            }
            sb.append(thisChar);
        }
        return sb.toString();
    }

    public Connection getConnection() {
        return this.m_wrapper.getConnection();
    }

    @Override
    public String getLineTerminator() {
        if (this._EOLChars == null) {
            this._EOLChars = FormatRegistry.getLineTerminator();
        }
        return this._EOLChars;
    }

    public boolean doPrint(IRaptorTaskProgressUpdater taskProgressUpdater) {
        ResultsFormatter finalFormatter = this;
        boolean success = false;
        try {
            finalFormatter.setUpdater(taskProgressUpdater);
            if (taskProgressUpdater != null) {
                taskProgressUpdater.checkCanProceed();
            }
            finalFormatter.print();
        }
        catch (ExecutionException e1) {
            if (e1.getCause() instanceof CancellationException) {
                LOGGER.log(Level.INFO, Messages.getString("ResultsFormatter.15"));
            }
            LOGGER.log(Level.WARNING, e1.getStackTrace()[0].toString(), e1);
        }
        return success;
    }

    public String cleanString(String str) {
        StringBuilder newStr = new StringBuilder("");
        Character qt = Character.valueOf('\"');
        for (int i = 0; i < str.length(); ++i) {
            Character ch = Character.valueOf(str.charAt(i));
            newStr = ch.equals(qt) ? newStr.append("\"\"") : newStr.append(ch);
        }
        return newStr.toString();
    }

    public void close() {
        if (this.m_wrapper != null) {
            this.m_wrapper.close();
        }
    }

    @Override
    public void setScriptContext(ScriptRunnerContext scriptRunnerContext) {
        this._scriptCtx = scriptRunnerContext;
    }

    @Override
    public ScriptRunnerContext getScriptContext() {
        return this._scriptCtx;
    }

    @Override
    public boolean isInternalOnly() {
        return false;
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return false;
    }
}

