/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.logging.Timer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.compiler.OraSubmitResults;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.SQL;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.SetServerOutput;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Service;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;

public class PLSQL
extends SQLCommandRunner {
    SQLWarning warn = null;
    public boolean errorToWorksheet = false;
    private int doubleBindPrepareErrorOffset = 0;
    private Map<Integer, Integer> doubleBindAdjustmentsOffsets = new HashMap<Integer, Integer>();
    private String type = null;
    private String name = null;
    private String owner = null;

    public PLSQL(ISQLCommand cmd, BufferedOutputStream out) {
        super(cmd, out);
    }

    public void run() {
        if (!LockManager.lock(this.conn)) {
            return;
        }
        Debug.debug(Messages.getString("PLSQL.0") + this.cmd.getSql());
        this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", null);
        try {
            Timer timer = new Timer();
            timer.start();
            this.errorToWorksheet = false;
            if (this.cmd.isCreatePLSQLCmd()) {
                this.runCreatePLSQL();
                this.reportfinish();
            } else {
                this.runNonCreatePLSQL();
            }
            Debug.debug(Messages.getString("PLSQL.1"));
            timer.end();
            this.cmd.setTiming(timer.duration());
        }
        catch (SQLException e) {
            this.cmd.setFail();
            this.handleException(e);
        }
        finally {
            if (this.cstmt != null) {
                try {
                    this.cstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.callStmt != null) {
                try {
                    this.callStmt.close();
                }
                catch (SQLException sQLException) {}
            }
            LockManager.unlock(this.conn);
        }
    }

    private void handleException(SQLException e) {
        this.cmd.setFail();
        String toSend = e.getMessage();
        ExceptionHandler.handleException((Exception)e, this.connName, true, false);
        this.getScriptRunnerContext().putProperty("sqldev.error", Boolean.TRUE);
        this.getScriptRunnerContext().putProperty("script.runner.autocommit.errorFlag", Boolean.TRUE);
        this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", e.getMessage());
        this.getScriptRunnerContext().putProperty("sqldev.last.err.sqlcode", e.getErrorCode());
        this.doWhenever(true);
        toSend = this.adjustColError(toSend);
        this.getScriptRunnerContext().putProperty("sqldev.last.err.message.forsqlcode", toSend);
        if (this.conn instanceof OracleConnection) {
            try {
                Oerr oerr = new Oerr();
                toSend = toSend + oerr.oerr(toSend);
            }
            catch (OerrException oerr) {
                // empty catch block
            }
        }
        if (this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString())) {
            String[] lines = this.cmd.getSQLOrig().split("\n");
            String line = null;
            int lineNo = this.getLineNo(toSend);
            int colNo = this.getColNo(toSend);
            boolean isExecStmt = false;
            if (this.checkForExecuteStmt(lines)) {
                line = this.cmd.getModifiedSQL();
                lines = this.cmd.getModifiedSQL().split("\n");
                isExecStmt = true;
            } else {
                line = this.cmd.getSQLOrig();
            }
            if (lines.length > 0 && lineNo > 0 && lineNo <= lines.length) {
                line = lines[lineNo - 1];
            }
            String asterix = "";
            if (colNo <= 1) {
                asterix = "*";
            } else {
                asterix = new String(new char[colNo]).replace('\u0000', ' ');
                asterix = asterix.substring(0, asterix.length() - 1) + "*";
            }
            asterix = "\n" + asterix + "\n";
            String msg = Messages.getString("PLSQL.9") + lineNo + ":\n" + this.adjustColError(e.getMessage()) + "\n";
            if (!isExecStmt) {
                this.report(this.getScriptRunnerContext(), line + asterix + msg);
            } else {
                this.report(this.getScriptRunnerContext(), line + "\n" + asterix + msg);
            }
        } else {
            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), toSend, this.getScriptRunnerContext()));
        }
        this.getScriptRunnerContext().errorLog(this.getScriptRunnerContext().getSourceRef(), e.getMessage(), this.cmd.getSql());
    }

    private boolean checkForExecuteStmt(String[] lines) {
        String exec = lines[0];
        return exec.trim().toLowerCase().startsWith("exec") || exec.trim().toLowerCase().startsWith("execute");
    }

    private String adjustColError(String msg) {
        String sqlOrig = this.cmd.getSQLOrig();
        String[] linesOrig = sqlOrig.split("\n");
        String origLine = sqlOrig;
        String sqlMod = this.cmd.getModifiedSQL();
        String[] linesMod = sqlMod.split("\n");
        String modLine = sqlMod;
        List<Long> lineCols = this.getLineCols(msg);
        for (long lineCol : lineCols) {
            int lineNo = Service.lX(lineCol);
            int colNo = Service.lY(lineCol);
            if (linesOrig.length > 0 && lineNo > 0 && lineNo <= linesOrig.length) {
                origLine = linesOrig[lineNo - 1];
            }
            if (linesMod.length > 0 && lineNo > 0 && lineNo <= linesMod.length) {
                modLine = linesMod[lineNo - 1];
            }
            if (colNo < modLine.length()) {
                modLine = modLine.substring(0, colNo);
            }
            int adjust = PLSQL.calcAdjValue(origLine, modLine);
            int fixedCol = colNo + adjust;
            if (this.doubleBindPrepareErrorOffset < colNo + adjust) {
                fixedCol -= this.doubleBindPrepareErrorOffset;
                fixedCol = this.calcDoubleBindAdjustmentOffset(fixedCol);
            }
            msg = msg.replace("line " + lineNo + ", column " + colNo, "line " + lineNo + ", column " + fixedCol);
        }
        return msg;
    }

    private static int calcAdjValue(String origLine, String modLine) {
        List<LexerToken> orig = LexerToken.parse(origLine);
        List<LexerToken> mod = LexerToken.parse(modLine);
        int mpos = 0;
        int opos = -1;
        int adjust = 0;
        for (LexerToken ot : orig) {
            ++opos;
            if (mod.size() <= mpos) break;
            LexerToken mt = mod.get(mpos);
            if (mt.content.equals(ot.content)) {
                ++mpos;
                continue;
            }
            int start = mt.begin;
            if (mod.size() <= (mpos += 4)) break;
            mt = mod.get(mpos);
            adjust = ot.content.length() - (mt.end - start);
            ++mpos;
        }
        return adjust;
    }

    private int getLineNo(String message) {
        String[] bits;
        String[] lines = message.split("\n");
        if (lines.length > 0 && lines[0].contains("ORA-06550") && lines[0].contains("line") && (bits = lines[0].split("\\s+")).length > 3 && bits[2].endsWith(",")) {
            String lineString = bits[2].substring(0, bits[2].length() - 1);
            try {
                int x = Integer.parseInt(lineString);
                return x;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    private int getColNo(String message) {
        String[] bits;
        String[] lines = message.split("\n");
        if (lines.length > 0 && lines[0].contains("ORA-06550") && lines[0].contains("column") && (bits = lines[0].split("\\s+")).length > 4 && bits[2].endsWith(",")) {
            String lineString = bits[4].substring(0, bits[4].length() - 1);
            try {
                int y = Integer.parseInt(lineString);
                return y;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    private List<Long> getLineCols(String message) {
        String[] lines;
        LinkedList<Long> ret = new LinkedList<Long>();
        for (String line : lines = message.split("\n")) {
            String[] bits;
            if (!line.contains("ORA-06550") || !line.contains("column") || !line.contains("line") || (bits = line.split("\\s+")).length <= 4 || !bits[2].endsWith(",")) continue;
            String lineString = bits[2].substring(0, bits[2].length() - 1);
            String colString = bits[4].substring(0, bits[4].length() - 1);
            try {
                int x = Integer.parseInt(lineString);
                int y = Integer.parseInt(colString);
                ret.add(Service.lPair(x, y));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    private void reportfinish() {
        String objectType = "anon";
        String objectName = null;
        this.parseNameAndType(this.cmd.getSql());
        objectType = this.type != null ? this.type : objectType;
        objectName = this.name;
        if (this.getScriptRunnerContext().isSQLPlusClassic() && objectType.toLowerCase().startsWith("java")) {
            objectType = "Java";
        }
        boolean errors = false;
        if (objectType.equals("anon") && this.getScriptRunnerContext().getFeedback() != -2) {
            this.report(this.getScriptRunnerContext(), Messages.getString("PLSQL.4"));
        } else if (this.getScriptRunnerContext().getFeedback() != -2) {
            if (this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString())) {
                if (this.warn != null) {
                    this.report(this.getScriptRunnerContext(), MessageFormat.format(Messages.getString("PLSQL.101"), StringUtils.initCap(objectType)));
                } else {
                    this.report(this.getScriptRunnerContext(), MessageFormat.format(Messages.getString("PLSQL.102"), StringUtils.initCapSingle(objectType)));
                }
                if (objectName != null && !objectName.equals("")) {
                    errors = ScriptUtils.isHttpCon(this.getConn(), this.getScriptRunnerContext()) ? false : this.reportErrors(objectName, true);
                }
                return;
            }
            if (objectType.toUpperCase().equals("JAVA SOURCE")) {
                this.report(this.getScriptRunnerContext(), MessageFormat.format(Messages.getString("PLSQL.5Created"), StringUtils.initCap(objectType), objectName));
            } else {
                this.report(this.getScriptRunnerContext(), MessageFormat.format(Messages.getString("PLSQL.5"), StringUtils.initCap(objectType), objectName));
            }
            if (objectName != null && !objectName.equals("") && !ScriptUtils.isHttpCon(this.getConn(), this.getScriptRunnerContext())) {
                errors = this.reportErrors(objectName, true);
            }
        } else if (objectName != null && !objectName.equals("")) {
            errors = this.reportErrors(objectName, false);
        }
        if (errors) {
            this.report(this.getScriptRunnerContext(), Messages.getString("PLSQL.29"));
        } else if (!(this.warn == null || ConnectionResolver.isOracle(this.conn) && this.warn.getErrorCode() == 17110 || this.warn.getMessage() == null)) {
            this.reportWarning(this.warn);
        }
    }

    void checkForDoubleBind(String text) {
        DBUtil dbUtil = DBUtil.getInstance(this.conn);
        List<String> binds = DBUtil.getBindNames(text, true);
        HashSet uniqueBinds = new HashSet();
        HashSet<String> doubleBindsLocal = new HashSet<String>();
        boolean doubleBindFound = false;
        if (this.cmd.getBinds() != null && this.cmd.getBinds().size() > 0) {
            this.doubleBinds = null;
            return;
        }
        for (String bind : binds) {
            doubleBindFound = true;
            doubleBindsLocal.add(bind.toUpperCase(Locale.US));
        }
        if (doubleBindFound) {
            this.doubleBinds = doubleBindsLocal;
        }
    }

    protected String getBindType(String bindName) throws SQLException {
        boolean setBind = true;
        String type = null;
        String typeBracket = null;
        boolean bindSetInCommand = false;
        boolean bindIdx = true;
        Map popupVars = (Map)this.getScriptRunnerContext().getProperty("f9.popup.binds");
        Map<String, Bind> vars = this.getScriptRunnerContext().getVarMap();
        HashMap externalVars = (HashMap)this.getScriptRunnerContext().getProperty("BINDMAP");
        if (externalVars == null) {
            externalVars = new HashMap();
        }
        boolean external = false;
        boolean local = false;
        boolean popup = false;
        if (popupVars.containsKey(bindName)) {
            popup = true;
        }
        if (vars.containsKey(bindName.toUpperCase())) {
            local = true;
        }
        if (externalVars.containsKey(bindName)) {
            external = true;
        }
        if (popup || local || external) {
            Bind bind = null;
            String value = null;
            if (popup) {
                value = popupVars.get(bindName).equals(DBUtil.NULL_VALUE) ? null : (String)popupVars.get(bindName);
                type = "VARCHAR2";
            } else if (local) {
                bind = vars.get(bindName.toUpperCase());
                type = bind.getType();
                typeBracket = bind.getBracket();
                if (typeBracket != null) {
                    type = typeBracket;
                }
                value = bind.getValue();
            } else {
                bind = (Bind)externalVars.get(bindName);
                type = bind.getType();
                typeBracket = bind.getBracket();
                if (typeBracket != null) {
                    type = typeBracket;
                }
                value = bind.getValue();
            }
            if (type != null && type.indexOf("(") == -1) {
                if (type.toUpperCase().indexOf("NCHAR") > -1) {
                    type = "NVARCHAR2(32767)";
                } else if (type.toUpperCase().indexOf("CHAR") > -1 && type.toUpperCase().indexOf("CHAR2") == -1) {
                    type = "VARCHAR2(32767)";
                } else if (type.toUpperCase().indexOf("NCHAR") > -1 || type.toUpperCase().indexOf("NVARCHAR") > -1 || type.toUpperCase().indexOf("CHAR") > -1 || type.toUpperCase().indexOf("VARCHAR") > -1) {
                    type = type + "(32767)";
                } else if (type.toUpperCase().equals("REFCURSOR")) {
                    type = "SYS_REFCURSOR";
                }
            }
        } else {
            type = null;
        }
        return type;
    }

    public void setMyUniq(String anonPLSQL) {
        String localMyUniq = this.myUniq.toUpperCase(Locale.US);
        String anonUpper = anonPLSQL.toUpperCase(Locale.US);
        int count = 1;
        while (anonUpper.contains(localMyUniq + count + "Z")) {
            ++count;
        }
        this.myUniq = this.myUniq + count + "Z";
    }

    public final String doubleBindPrepareOracleSql(String query) throws SQLException {
        this.setMyUniq(query);
        ArrayList<Bind> parserdBinds = Parser.getInstance().getBinds(query, true);
        HashMap<String, Integer> lookUpCount = new HashMap<String, Integer>();
        String sql = query;
        int count = 1;
        HashSet<String> alreadySkipped = new HashSet<String>();
        String header = "DECLARE ";
        String footer = "";
        if (parserdBinds != null) {
            for (int curBind = parserdBinds.size() - 1; curBind >= 0; --curBind) {
                Bind b = (Bind)parserdBinds.get(curBind);
                String bString = b.getName();
                String bindUpper = bString.toUpperCase(Locale.US);
                if (this.doubleBinds.contains(bindUpper)) {
                    if (alreadySkipped.add(bindUpper)) {
                        lookUpCount.put(bindUpper, count);
                        String bindType = this.getBindType(bString);
                        if (bindType == null) {
                            this.doubleBindPrepareErrorOffset = 0;
                            return null;
                        }
                        if (bindType.equalsIgnoreCase("sys_refcursor")) {
                            header = header + this.myUniq + "_" + count + " " + bindType + ":=null; ";
                        } else {
                            header = header + this.myUniq + "_" + count + " " + bindType + ":=:" + this.myUniq + "Init" + count + "; ";
                            this.lookUpMangle.put(this.myUniq + "Init" + count, bString);
                        }
                        footer = footer + ":" + b.getName() + ":=" + this.myUniq + "_" + count + "; ";
                    }
                    sql = this.replaceBind(b, " " + this.myUniq + "_" + lookUpCount.get(bindUpper), sql);
                }
                ++count;
            }
        }
        String ret = header + " BEGIN " + sql + " " + footer + " END;";
        this.doubleBindPrepareErrorOffset = ret.indexOf(sql);
        return ret;
    }

    private int calcDoubleBindAdjustmentOffset(int pos) {
        int ret = pos;
        for (int p : this.doubleBindAdjustmentsOffsets.keySet()) {
            if (p >= pos) continue;
            ret -= this.doubleBindAdjustmentsOffsets.get(p).intValue();
        }
        return ret;
    }

    private String replaceBind(Bind b, String replacement, String sql) {
        this.doubleBindAdjustmentsOffsets.put(b.getBegin(), replacement.length() - (b.getEnd() - b.getBegin() + 1));
        if (sql.length() == b.getEnd()) {
            return sql.substring(0, b.getBegin()) + replacement;
        }
        return sql.substring(0, b.getBegin()) + replacement + sql.substring(b.getEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNonCreatePLSQL() throws SQLException {
        DBUtil dbUtil = DBUtil.getInstance(this.conn);
        if (this.conn instanceof OracleConnection || ScriptUtils.isHttpCon(this.conn, this.getScriptRunnerContext())) {
            this.checkForDoubleBind(this.cmd.getSql());
            String alteredSql = null;
            if (this.doubleBinds != null) {
                this.altSQL = this.doubleBindPrepareOracleSql(this.cmd.getSql());
                if (this.altSQL == null) {
                    this.doubleBinds = null;
                } else {
                    alteredSql = this.altSQL;
                }
            }
            if (this.doubleBinds == null) {
                alteredSql = dbUtil.prepareOracleSql(this.cmd.getSql());
            }
            this.callStmt = this.conn.prepareCall(alteredSql);
        } else {
            this.callStmt = this.conn.prepareCall(dbUtil.prepareNonOracleSql(this.cmd.getSql()));
        }
        this.callStmt.setEscapeProcessing(false);
        List<String> binds = null;
        if (this.cmd.getSql().indexOf(":") > 0) {
            binds = DBUtil.getBindNames(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        }
        if (binds != null && binds.size() > 0) {
            if (this.setBinds(this.callStmt)) {
                this.registerOutParameters();
                this.callStmt.getParameterMetaData().getParameterCount();
                try {
                    this.callStmt.execute();
                    this.fetchOutputParameterValues();
                }
                finally {
                    SetServerOutput.coreEndWatcher(this.conn, this.getScriptRunnerContext(), this.cmd);
                }
                this.reportfinish();
            }
        } else {
            try {
                this.callStmt.execute();
            }
            finally {
                SetServerOutput.coreEndWatcher(this.conn, this.getScriptRunnerContext(), this.cmd);
            }
            this.reportfinish();
        }
        this.processImplicitResultSets(this.callStmt);
        this.warn = this.callStmt.getWarnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processImplicitResultSets(CallableStatement callStmt) {
        try {
            int i = 0;
            try {
                while (callStmt.getMoreResults()) {
                    this.report(this.getScriptRunnerContext(), "ResultSet #" + ++i + "\n");
                    ResultSet rs = null;
                    try {
                        rs = callStmt.getResultSet();
                        SQL sqlProcessing = new SQL(this.cmd, this.out);
                        sqlProcessing.setScriptRunnerContext(this.getScriptRunnerContext());
                        sqlProcessing.setConn(this.getConn());
                        sqlProcessing.processResultSet(rs);
                        if (rs == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (rs == null) throw throwable;
                        try {
                            rs.close();
                            throw throwable;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                    }
                }
                return;
            }
            catch (Exception ee) {
                if (ee instanceof SQLException) {
                    throw (SQLException)ee;
                }
                if (ee instanceof IOException) {
                    throw (IOException)ee;
                }
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ee.getStackTrace()[0].toString(), ee);
                return;
            }
        }
        catch (SQLException e) {
            this.cmd.setFail();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return;
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCreatePLSQL() throws SQLException {
        block33: {
            Statement pstmt = null;
            try {
                boolean useExecuteImmediate = false;
                SQLCommand.StmtSubType stmtId = this.cmd.getStmtId();
                if (stmtId == SQLCommand.StmtSubType.G_S_CREATE_FUNCTION || stmtId == SQLCommand.StmtSubType.G_S_CREATE_PROCEDURE || stmtId == SQLCommand.StmtSubType.G_S_CREATE_PACKAGE_BODY || stmtId == SQLCommand.StmtSubType.G_S_CREATE_PACKAGE_HEADER || stmtId == SQLCommand.StmtSubType.G_S_CREATE_JAVA || stmtId == SQLCommand.StmtSubType.G_S_CREATE_TRIGGER || stmtId == SQLCommand.StmtSubType.G_S_CREATE_TYPE) {
                    String localCmd = this.cmd.getSQLOrig();
                    if (localCmd.length() > 1001) {
                        localCmd = localCmd.substring(0, 999);
                    }
                    if ((localCmd = localCmd.toLowerCase()).indexOf("wrapped") != -1) {
                        localCmd = localCmd.replaceAll("\\s+or\\s+replace\\s+", " ");
                        localCmd = localCmd.replaceAll("\\s+noneditionable\\s+", " ");
                        String[] words = (localCmd = localCmd.replaceAll("\\s+editionable\\s+", " ")).trim().split("\\s+");
                        if (words != null && words.length > 5 && (words[3].equals("wrapped") || words[4].equals("wrapped") && words[2].equals("body"))) {
                            useExecuteImmediate = true;
                        }
                        if (!useExecuteImmediate) {
                            localCmd = ScriptUtils.stripFirstN(localCmd, 1000, this.cmd.getProperty("STRIPPED_CONTINUATION") == null, false);
                            localCmd = localCmd.replaceAll("\\s+or\\s+replace\\s+", " ");
                            localCmd = localCmd.replaceAll("\\s+noneditionable\\s+", " ");
                            words = (localCmd = localCmd.replaceAll("\\s+editionable\\s+", " ")).trim().split("\\s+");
                            if (words != null && words.length > 5 && (words[3].equals("wrapped") || words[4].equals("wrapped") && words[2].equals("body"))) {
                                useExecuteImmediate = true;
                            }
                        }
                    }
                }
                if (useExecuteImmediate && VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(this.conn)).compareTo(new Version("11.1")) < 0) {
                    CLOB oraclob = null;
                    try {
                        oraclob = CLOB.createTemporary((Connection)this.conn, (boolean)true, (int)10);
                        oraclob.open(1);
                        Writer targetWriter = oraclob.setCharacterStream(1L);
                        targetWriter.write(this.cmd.getSql() + "\n\n", 0, (this.cmd.getSql() + "\n\n").length());
                        targetWriter.flush();
                        targetWriter.close();
                        pstmt = this.conn.prepareStatement("  declare\n    v_large_sql  CLOB;\n    v_num        NUMBER := 0;\n    v_upperbound NUMBER;\n    v_sql        DBMS_SQL.VARCHAR2S;\n    v_cur        INTEGER;\n    v_ret        NUMBER;\n  begin\n    v_large_sql := :1;\n    v_upperbound := CEIL(DBMS_LOB.GETLENGTH(v_large_sql)/256);\n    FOR i IN 1..v_upperbound\n    LOOP\n      v_sql(i) := DBMS_LOB.SUBSTR(v_large_sql\n                                 ,256 -- amount\n                                 ,((i-1)*256)+1 -- offset\n                                 );\n    END LOOP;\n    v_cur := DBMS_SQL.OPEN_CURSOR;\n    DBMS_SQL.PARSE(v_cur, v_sql, 1, v_upperbound, FALSE, DBMS_SQL.NATIVE);\n    v_ret := DBMS_SQL.EXECUTE(v_cur);\n    DBMS_SQL.CLOSE_CURSOR(v_cur);\n  EXCEPTION   \n    when others then\n      dbms_sql.close_cursor(v_cur);\n    raise;\n  END;\n");
                        pstmt.setClob(1, (Clob)oraclob);
                        try {
                            pstmt.executeUpdate();
                        }
                        finally {
                            SetServerOutput.coreEndWatcher(this.conn, this.getScriptRunnerContext(), this.cmd);
                        }
                        this.warn = pstmt.getWarnings();
                        this.errorToWorksheet = true;
                        break block33;
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                        break block33;
                    }
                    finally {
                        try {
                            oraclob.freeTemporary();
                        }
                        catch (Exception e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                        }
                    }
                }
                this.cstmt = this.conn.createStatement();
                this.cstmt.setEscapeProcessing(false);
                try {
                    this.cstmt.executeUpdate(this.cmd.getSql());
                }
                finally {
                    SetServerOutput.coreEndWatcher(this.conn, this.getScriptRunnerContext(), this.cmd);
                }
                this.warn = this.cstmt.getWarnings();
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    private void reportWarning(SQLWarning warn) {
        this.getScriptRunnerContext().putProperty("sqldev.last.err.type", this.type == null ? "UNKNOWN" : this.type.toUpperCase());
        this.getScriptRunnerContext().putProperty("sqldev.last.err.name", this.name);
        this.report(this.getScriptRunnerContext(), warn.getMessage());
    }

    private String[] parseNameAndType(String sql) {
        String[] retVal = ScriptUtils.parseNameAndTypeUtil(sql);
        if (retVal != null) {
            this.owner = retVal[0];
            this.name = retVal[1];
            this.type = retVal[2];
            return new String[]{retVal[1], retVal[2]};
        }
        return new String[]{"", ""};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean reportErrors(String objectName, boolean feedbackWanted) {
        OraSubmitResults submitResults;
        block54: {
            ResultSet rset;
            block53: {
                int line;
                this.fireListenersRegister(this.getScriptRunnerContext());
                MetaResource mr = new MetaResource(QueryXMLSupport.class.getClassLoader(), "oracle/dbtools/raptor/compiler/source.xml");
                QueryXMLSupport s_xml = QueryXMLSupport.getQueryXMLSupport(mr);
                Query q = s_xml.getQuery("COMPILER_ERRORS", this.conn);
                HashMap<String, String> binds = new HashMap<String, String>();
                binds.put("NAME", this.name);
                binds.put("TYPE", this.type);
                if (this.owner == null) {
                    if (this.conn instanceof OracleConnection) {
                        this.owner = DBUtil.getInstance(this.conn).executeReturnOneCol("select UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')) from dual");
                    } else {
                        try {
                            this.owner = this.conn.getMetaData().getUserName();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                binds.put("OWNER", this.owner);
                rset = null;
                submitResults = new OraSubmitResults();
                DBUtil dbUtil = DBUtil.getInstance(this.conn);
                rset = dbUtil.executeQuery(q.getSql(), binds);
                boolean isEmpty = true;
                while (rset.next()) {
                    isEmpty = false;
                    line = rset.getInt(1);
                    int col = rset.getInt(2);
                    Iterator errMsg = rset.getString(3);
                    String attr = rset.getString(4);
                    boolean error = "ERROR".equals(attr);
                    submitResults.addError(new PlSqlErrorInfo(line, col, (String)((Object)errMsg), !error));
                }
                if (!isEmpty) break block53;
                line = 0;
                try {
                    if (rset != null) {
                        DBUtil.closeResultSet(rset);
                    }
                }
                catch (Exception col) {
                    // empty catch block
                }
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                }
                catch (Exception col) {
                    // empty catch block
                }
                return line != 0;
            }
            try {
                if (rset != null) {
                    DBUtil.closeResultSet(rset);
                }
            }
            catch (Exception dbUtil) {
                // empty catch block
            }
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                break block54;
            }
            catch (Exception dbUtil) {}
            break block54;
            catch (SQLException e2222222222) {
                try {
                    this.fireListenerOutputLog(MessageFormat.format(Messages.getString("PLSQL.19"), e2222222222.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        if (rset != null) {
                            DBUtil.closeResultSet(rset);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (this.stmt != null) {
                            this.stmt.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (rset != null) {
                        DBUtil.closeResultSet(rset);
                    }
                }
                catch (Exception e2222222222) {
                    // empty catch block
                }
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                }
                catch (Exception e2222222222) {}
            }
        }
        ArrayList<PlSqlErrorInfo> results = new ArrayList<PlSqlErrorInfo>();
        boolean warnings = false;
        boolean errors = false;
        List<PlSqlErrorInfo> resultList = submitResults.getErrorList();
        results.addAll(resultList);
        if (null != resultList) {
            if (this.errorToWorksheet && resultList.size() != 0) {
                this.report(this.getScriptRunnerContext(), MessageFormat.format(Messages.getString("CREATED"), this.type, this.name));
            }
            for (PlSqlErrorInfo ei : resultList) {
                if (ei.isWarning()) {
                    this.fireListenerWarning(ei.getLineNumber(), ei.getColumn(), 0, ei.getErrorMessage());
                    continue;
                }
                this.fireListenerError(ei.getLineNumber(), ei.getColumn(), 0, ei.getErrorMessage());
            }
            if (resultList.size() == 20) {
                this.fireListenerWarning(1, 1, 0, Messages.getString("PLSQL.20"));
            }
        }
        this.errorToWorksheet = false;
        for (PlSqlErrorInfo err : results) {
            if (!err.isWarning()) {
                errors = true;
                continue;
            }
            warnings = true;
        }
        this.fireListenerunRegisterAsynchronousLogPage();
        if (errors && warnings) {
            this.fireListenerOutputLog(MessageFormat.format(Messages.getString("PLSQL.21"), objectName));
        } else if (errors) {
            this.fireListenerOutputLog(MessageFormat.format(Messages.getString("PLSQL.22"), objectName));
        } else if (warnings) {
            this.fireListenerOutputLog(MessageFormat.format(Messages.getString("PLSQL.23"), objectName));
        } else {
            this.fireListenerOutputLog(MessageFormat.format(Messages.getString("PLSQL.24"), objectName));
        }
        if (!this.getScriptRunnerContext().isSQLPlusClassic()) {
            int maxLength = 8;
            for (PlSqlErrorInfo err : results) {
                int colNumLength;
                int lineNumLength = String.valueOf(err.getLineNumber()).length();
                if (maxLength >= lineNumLength + (colNumLength = String.valueOf(err.getColumn()).length())) continue;
                maxLength = lineNumLength + colNumLength;
            }
            if (results.size() > 0) {
                this.report(this.getScriptRunnerContext(), "LINE/COL  ERROR");
                this.report(this.getScriptRunnerContext(), this.rpad("", '-', maxLength) + " -------------------------------------------------------------");
            }
            for (PlSqlErrorInfo err : results) {
                this.report(this.getScriptRunnerContext(), this.rpad(err.getLineNumber() + "/" + err.getColumn(), ' ', maxLength) + " " + err.getErrorMessage());
            }
        }
        this.getScriptRunnerContext().putProperty("sqldev.last.err.type", this.type.toUpperCase());
        if (this.owner != null && !this.owner.equals("")) {
            this.getScriptRunnerContext().putProperty("sqldev.last.err.name", this.owner + "." + this.name);
        } else {
            this.getScriptRunnerContext().putProperty("sqldev.last.err.name", this.name);
        }
        return errors;
    }

    private String rpad(String stringToPad, char filler, int length) {
        if (stringToPad.length() >= length) {
            return stringToPad;
        }
        StringBuffer padding = new StringBuffer();
        for (int i = stringToPad.length(); i <= length; ++i) {
            padding.append(filler);
        }
        return stringToPad + padding.toString();
    }

    private void fetchOutputParameterValues() throws SQLException {
        int bindIdx = 1;
        Map<String, Bind> m1 = this.getScriptRunnerContext().getVarMap();
        Map m2 = (Map)this.getScriptRunnerContext().getProperty("f9.popup.binds");
        Map m3 = (Map)this.getScriptRunnerContext().getProperty("BINDMAP");
        List<String> al = DBUtil.getBindNames(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        bindIdx = al.size();
        if (m1.size() > 0 || m3 != null && m3.size() > 0) {
            for (int i = al.size() - 1; i >= 0; --i) {
                if (bindIdx <= 0) continue;
                String bindName = null;
                if (this.doubleBinds != null) {
                    bindName = (String)this.lookUpMangle.get(al.get(i));
                    if (bindName == null) {
                        bindName = al.get(i);
                    }
                    if (al.get(i).contains(this.myUniq + "Init")) {
                        --bindIdx;
                        continue;
                    }
                    if (bindName == null) {
                        bindName = al.get(i);
                    }
                } else {
                    bindName = al.get(i);
                }
                Bind bind = m1.get(bindName.toUpperCase());
                if (m3 != null && bind == null) {
                    bind = (Bind)m3.get(bindName);
                }
                if (bind == null && m2 != null && m2.containsKey(bindName)) {
                    --bindIdx;
                    continue;
                }
                if (bind == null) {
                    Exception e = new Exception(bindName);
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    --bindIdx;
                    continue;
                }
                String type = bind.getType();
                if (bind.getDataType() != null) {
                    if (bind.getMode() == Bind.Mode.OUT || bind.getMode() == Bind.Mode.INOUT) {
                        bind.setDataValue(bind.getDataType().getDataValue(this.callStmt.getObject(bindIdx)));
                    }
                } else if (type.toUpperCase().indexOf("CHAR") > -1) {
                    try {
                        bind.setValue(this.callStmt.getString(bindIdx));
                    }
                    catch (SQLException sQLException) {}
                } else if (type.toUpperCase().equals("NUMBER")) {
                    Object o = null;
                    try {
                        o = this.callStmt.getObject(bindIdx);
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    bind.setValue(o == null ? null : o.toString());
                } else if (type.toUpperCase().indexOf("CLOB") > -1) {
                    try {
                        bind.setValue(DataTypesUtil.stringValue(this.callStmt.getObject(bindIdx), this.conn, Integer.MAX_VALUE));
                    }
                    catch (SQLException o) {}
                } else if (type.toUpperCase().equals("REFCURSOR")) {
                    try {
                        ScriptRunnerContext.set_storedContext(this.getScriptRunnerContext());
                        bind.setValue(DataTypesUtil.stringValue(this.callStmt.getObject(bindIdx), this.conn));
                        ScriptRunnerContext.set_storedContext(null);
                    }
                    catch (SQLException o) {}
                } else if (type.toUpperCase().indexOf("BINARY_") > -1) {
                    try {
                        bind.setValue(DataTypesUtil.stringValue(this.callStmt.getObject(bindIdx), this.conn));
                    }
                    catch (SQLException o) {}
                } else if (type.toUpperCase().equals("BLOB")) {
                    Blob b = null;
                    try {
                        b = (Blob)this.callStmt.getObject(bindIdx);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    String s = null;
                    try {
                        if (b != null) {
                            byte[] bdata = null;
                            bdata = b.getBytes(1L, (int)b.length());
                            s = new String(ScriptUtils.bytesToHex(bdata)).toUpperCase();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    bind.setValue(s);
                    bind.setValueObj(b);
                }
                if (m1.containsKey(bindName.toUpperCase())) {
                    m1.put(bindName.toUpperCase(), bind);
                } else if (m3 != null && m3.containsKey(bindName)) {
                    m3.put(bindName, bind);
                }
                --bindIdx;
            }
        } else {
            List<Object> list = this.cmd.getBinds();
        }
    }

    private void registerOutParameters() throws SQLException {
        int bindIdx = 1;
        List<String> al = null;
        al = DBUtil.getBindNames(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        Map<String, Bind> m1 = this.getScriptRunnerContext().getVarMap();
        Map m2 = (Map)this.getScriptRunnerContext().getProperty("f9.popup.binds");
        Map m3 = (Map)this.getScriptRunnerContext().getProperty("BINDMAP");
        String bindName = null;
        for (int i = 0; i < al.size(); ++i) {
            bindName = null;
            if (this.doubleBinds != null && al.get(i).contains(this.myUniq + "Init")) {
                ++bindIdx;
                continue;
            }
            bindName = al.get(i);
            Bind bind = null;
            if (m1 != null && m1.containsKey(bindName.toUpperCase())) {
                bind = m1.get(bindName.toUpperCase());
            } else if (m3 != null && m3.containsKey(bindName)) {
                bind = (Bind)m3.get(bindName);
            } else if (m2 != null && m2.containsKey(bindName)) {
                ++bindIdx;
                continue;
            }
            if (bind == null) continue;
            if (bind.getMode() == Bind.Mode.OUT || bind.getMode() == Bind.Mode.INOUT || bind.getMode() == Bind.Mode.UNKNOWN) {
                String type = bind.getType();
                if (bind.getDataType() != null) {
                    this.callStmt.registerOutParameter(bindIdx, bind.getDataType().getSqlDataType(ValueType.JDBC));
                } else {
                    if (type.toUpperCase().indexOf("NCHAR") > -1 || type.toUpperCase().indexOf("NVARCHAR") > -1 || type.toUpperCase().indexOf("NCLOB") > -1) {
                        ((OracleCallableStatement)this.callStmt).setFormOfUse(bindIdx, (short)2);
                    }
                    if (type.toUpperCase().indexOf("CHAR") > -1) {
                        this.callStmt.registerOutParameter(bindIdx, 12);
                    } else if (type.toUpperCase().equals("NUMBER")) {
                        this.callStmt.registerOutParameter(bindIdx, 2);
                    } else if (type.toUpperCase().indexOf("CLOB") > -1) {
                        this.callStmt.registerOutParameter(bindIdx, 2005);
                    } else if (type.toUpperCase().equals("REFCURSOR")) {
                        this.callStmt.registerOutParameter(bindIdx, -10);
                    } else if (type.toUpperCase().equals("BFILE")) {
                        this.callStmt.registerOutParameter(bindIdx, -13);
                    } else if (type.toUpperCase().equals("BLOB")) {
                        this.callStmt.registerOutParameter(bindIdx, 2004);
                    } else if (type.toUpperCase().equals("BINARY_DOUBLE")) {
                        this.callStmt.registerOutParameter(bindIdx, 101);
                    } else if (type.toUpperCase().equals("BINARY_FLOAT")) {
                        this.callStmt.registerOutParameter(bindIdx, 100);
                    }
                }
            }
            ++bindIdx;
        }
    }

    private String capitalize(String line) {
        String[] arr = line.split(" ");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(Character.toUpperCase(arr[i].charAt(0))).append(arr[i].substring(1).toLowerCase()).append(" ");
        }
        return sb.toString().trim();
    }

    public static void main(String[] args) {
        String orig = "  dbms_output.put_line ('typ_e1 ' || ty.c1 || ty.c2);";
        String mod = "  dbms_output.put_line (TO_CHAR(:2) || ty.c1 || ty.";
        System.out.println(PLSQL.calcAdjValue(orig, mod));
    }
}

