/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.apex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import oracle.dbtools.raptor.newscriptrunner.apex.APEXExportSplitter;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleDriver;
import oracle.sql.CLOB;

public class APEXExport {
    private final String gStmt = "select application_id, application_name from apex_applications where workspace_id = ? and build_status <> 'Run and Hidden' union select application_id, application_name from apex_ws_applications where workspace_id = ? order by application_id";
    private final String gStmt2 = "select application_id, application_name from apex_applications where workspace_id = ? union select application_id, application_name from apex_ws_applications where workspace_id = ? order by application_id";
    private final String gStmtInstance = "select application_id, application_name from apex_applications where workspace_id <> 10 and build_status <> 'Run and Hidden' union select application_id, application_name from apex_ws_applications where workspace_id <> 10 order by application_id";
    private final String gStmtWorkspaces = "select workspace_id, workspace from apex_workspaces where workspace_id > 11 order by workspace_id";
    private final String gStmtWorkspacesFeedback = "select distinct workspace_id, workspace_name from apex_team_feedback where workspace_id > 11 order by workspace_id";
    private final String gStmtWorkspace = "select workspace from apex_workspaces where workspace_id = ?";
    private final String gStmtSetSGID = "begin wwv_flow_api.set_security_group_id(p_security_group_id=>?); end;";
    private final String gStmtGetSGID = "select v('FLOW_SECURITY_GROUP_ID') from sys.dual";
    private final String gStmtIsWS = "select count(*) from apex_ws_applications where application_id = ?";
    public boolean debug = false;
    public boolean skipDate = false;
    public boolean instance = false;
    public boolean pubReports = false;
    public boolean savedReports = false;
    public boolean IRNotifications = false;
    public boolean expWorkspace = false;
    public boolean expMinimal = false;
    public boolean expTeamdevdata = false;
    public boolean expFeedback = false;
    public boolean expTranslations = false;
    public boolean expFiles = false;
    public boolean expOriginalIds = false;
    public boolean expLocked = false;
    private Connection gConn;
    private BigDecimal workspaceID;
    private String deploymentSystem;
    private Date expFeedbackSince;
    private java.util.Date expFeedbackSinceU;
    private String url;
    private String userName;
    private String password;
    private BigDecimal appID;
    private boolean _valid = false;
    private OutputStream _out;
    private APEXExportSplitter splitter = null;
    private boolean _splitFlat = false;
    private boolean _split = false;
    private boolean _splitUpdate;
    private boolean _splitNoCheckSum;
    private String _cwd;

    private APEXExportSplitter getSplitter() {
        if (this.splitter == null) {
            this.splitter = new APEXExportSplitter();
        }
        this.splitter.setOptions(this._cwd, this._splitFlat, this._splitNoCheckSum, this.debug, this._splitUpdate);
        return this.splitter;
    }

    public void setCWD(String cwd) {
        this._cwd = cwd;
    }

    private void exportFiles(BigDecimal appIDToExport, BigDecimal workspaceID, String userName) throws Exception {
        if (this.instance) {
            String appName = null;
            PreparedStatement stmt = this.gConn.prepareStatement("select application_id, application_name from apex_applications where workspace_id <> 10 and build_status <> 'Run and Hidden' union select application_id, application_name from apex_ws_applications where workspace_id <> 10 order by application_id");
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                BigDecimal appID = result.getBigDecimal(1);
                appName = result.getString(2);
                this.write("Exporting Application " + appID + ":'" + appName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    this.write(" Start " + now + "\n");
                }
                this.exportFile(appID, true);
                now = new java.util.Date();
                this.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        } else if (workspaceID != null && workspaceID.longValue() != 0L) {
            BigDecimal securityGroupID = new BigDecimal(0);
            String appName = null;
            PreparedStatement stmt = this.gConn.prepareStatement("begin wwv_flow_api.set_security_group_id(p_security_group_id=>?); end;");
            stmt.setBigDecimal(1, workspaceID);
            stmt.executeUpdate();
            stmt.close();
            stmt = this.gConn.prepareStatement("select v('FLOW_SECURITY_GROUP_ID') from sys.dual");
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                securityGroupID = result.getBigDecimal(1);
            }
            result.close();
            stmt.close();
            if (!securityGroupID.equals(workspaceID)) {
                this.write("Invalid Workspace ID '" + workspaceID + "' for User '" + userName + "'\n");
                System.exit(1);
            }
            stmt = !this.expLocked ? this.gConn.prepareStatement("select application_id, application_name from apex_applications where workspace_id = ? and build_status <> 'Run and Hidden' union select application_id, application_name from apex_ws_applications where workspace_id = ? order by application_id") : this.gConn.prepareStatement("select application_id, application_name from apex_applications where workspace_id = ? union select application_id, application_name from apex_ws_applications where workspace_id = ? order by application_id");
            stmt.setBigDecimal(1, workspaceID);
            stmt.setBigDecimal(2, workspaceID);
            result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                BigDecimal appID = result.getBigDecimal(1);
                appName = result.getString(2);
                this.write("Exporting Application " + appID + ":'" + appName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    this.write(" Start " + now + "\n");
                }
                this.exportFile(appID, true);
                now = new java.util.Date();
                this.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        } else {
            java.util.Date now;
            this.write("Exporting application " + appIDToExport);
            if (this.debug) {
                now = new java.util.Date();
                this.write(" Start " + now + "\n");
            }
            this.exportFile(appIDToExport, false);
            now = new java.util.Date();
            this.write("  Completed at " + now + "\n");
        }
    }

    private void exportWorkspaces(BigDecimal workspaceID, boolean teamdevdata, boolean minimal) throws SQLException, IOException {
        if (workspaceID != null && workspaceID.longValue() != 0L) {
            String wkspName = null;
            PreparedStatement stmt = this.gConn.prepareStatement("select workspace from apex_workspaces where workspace_id = ?");
            stmt.setBigDecimal(1, workspaceID);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                wkspName = result.getString(1);
                this.write("Exporting Workspace " + workspaceID + ":'" + wkspName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    this.write(" Start " + now + "\n");
                }
                this.exportWorkspace(workspaceID, teamdevdata, minimal);
                now = new java.util.Date();
                this.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        } else {
            String wkspName = null;
            PreparedStatement stmt = this.gConn.prepareStatement("select workspace_id, workspace from apex_workspaces where workspace_id > 11 order by workspace_id");
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                BigDecimal wkspID = result.getBigDecimal(1);
                wkspName = result.getString(2);
                this.write("Exporting Workspace " + wkspID + ":'" + wkspName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    this.write(" Start " + now + "\n");
                }
                this.exportWorkspace(wkspID, teamdevdata, minimal);
                now = new java.util.Date();
                this.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        }
    }

    private void ExpFeed(BigDecimal workspaceID, String deploymentSystem, Date expFeedbackSince) throws SQLException, IOException {
        if (workspaceID != null && workspaceID.longValue() != 0L) {
            String wkspName = null;
            PreparedStatement stmt = this.gConn.prepareStatement("select workspace from apex_workspaces where workspace_id = ?");
            stmt.setBigDecimal(1, workspaceID);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                wkspName = result.getString(1);
                this.write("Exporting Feedback for Workspace " + workspaceID + ":'" + wkspName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    this.write(" Start " + now + "\n");
                }
                this.exportFeedback(workspaceID, deploymentSystem, expFeedbackSince);
                now = new java.util.Date();
                this.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        } else {
            String wkspName = null;
            PreparedStatement stmt = this.gConn.prepareStatement("select distinct workspace_id, workspace_name from apex_team_feedback where workspace_id > 11 order by workspace_id");
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                java.util.Date now;
                BigDecimal wkspID = result.getBigDecimal(1);
                wkspName = result.getString(2);
                this.write("Exporting Feedback for Workspace " + wkspID + ":'" + wkspName + "' \n");
                if (this.debug) {
                    now = new java.util.Date();
                    this.write(" Start " + now + "\n");
                }
                this.exportFeedback(wkspID, deploymentSystem, expFeedbackSince);
                now = new java.util.Date();
                this.write("  Completed at " + now + "\n");
            }
            result.close();
            stmt.close();
        }
    }

    public void exportFile(BigDecimal appID, boolean expPkgAppMapping) throws Exception {
        boolean firstTime = true;
        OracleCallableStatement cstmt = (OracleCallableStatement)this.gConn.prepareCall("begin\n    ? := wwv_flow_utilities.export_application_to_clob (\n             p_application_id            => ?,\n             p_export_ir_public_reports  => ?,\n             p_export_ir_private_reports => ?,\n             p_export_ir_notifications   => ?,\n             p_export_translations       => ?,\n             p_export_pkg_app_mapping    => ?,\n             p_with_original_ids         => case when ?='Y' then true else false end );\nend;");
        cstmt.registerOutParameter(1, 2005);
        cstmt.setBigDecimal(2, appID);
        cstmt.setString(3, this.pubReports ? "Y" : "N");
        cstmt.setString(4, this.savedReports ? "Y" : "N");
        cstmt.setString(5, this.IRNotifications ? "Y" : "N");
        cstmt.setString(6, this.expTranslations ? "Y" : "N");
        cstmt.setString(7, expPkgAppMapping ? "Y" : "N");
        cstmt.setString(8, this.expOriginalIds ? "Y" : "N");
        cstmt.execute();
        CLOB clob = cstmt.getCLOB(1);
        Reader instream = clob.getCharacterStream();
        int size = clob.getBufferSize();
        char[] buffer = new char[size];
        int length = -1;
        BigDecimal isWS = null;
        String isWSString = "1";
        PreparedStatement stmt = this.gConn.prepareStatement("select count(*) from apex_ws_applications where application_id = ?");
        stmt.setBigDecimal(1, appID);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            isWS = result.getBigDecimal(1);
            isWSString = isWS.toString();
        }
        result.close();
        stmt.close();
        String theFileName = isWSString.equals("0") ? "f" + appID + ".sql" : "ws" + appID + ".sql";
        File theFile = new File(this._cwd + File.separator + theFileName);
        theFile.delete();
        theFile.createNewFile();
        FileOutputStream foutstream = new FileOutputStream(theFile);
        OutputStreamWriter owstream = new OutputStreamWriter((OutputStream)foutstream, "UTF-8");
        BufferedReader in = new BufferedReader(instream);
        String line = null;
        while ((line = in.readLine()) != null) {
            line = line + "\n";
            if (firstTime) {
                if (line.indexOf("set define") != 0) continue;
                firstTime = false;
                owstream.write(line, 0, line.length());
                continue;
            }
            if (this.skipDate && line.indexOf("--   Date and Time:") == 0) continue;
            owstream.write(line, 0, line.length());
        }
        owstream.flush();
        if (this.debug) {
            this.write(" Wrote " + theFile.length() + " bytes to " + theFile.getAbsolutePath() + "\n");
        }
        if (this._split) {
            this.getSplitter().processFile(theFile.getAbsolutePath().toString());
        }
        instream.close();
        owstream.close();
        foutstream.close();
        cstmt.close();
    }

    public void exportWorkspace(BigDecimal workspaceID, boolean teamdevdata, boolean minimal) throws SQLException, IOException {
        boolean firstTime = true;
        String lstmt = null;
        lstmt = teamdevdata ? "begin ? := wwv_flow_utilities.export_workspace_to_clob(?, true" : "begin ? := wwv_flow_utilities.export_workspace_to_clob(?, false";
        lstmt = minimal ? lstmt + ",true); end;" : lstmt + "); end;";
        OracleCallableStatement cstmt = (OracleCallableStatement)this.gConn.prepareCall(lstmt);
        cstmt.setBigDecimal(2, workspaceID);
        cstmt.registerOutParameter(1, 2005);
        cstmt.execute();
        CLOB clob = cstmt.getCLOB(1);
        Reader instream = clob.getCharacterStream();
        int size = clob.getBufferSize();
        char[] buffer = new char[size];
        int length = -1;
        File theFile = new File(this._cwd + File.separator + "w" + workspaceID + ".sql");
        theFile.delete();
        theFile.createNewFile();
        FileOutputStream foutstream = new FileOutputStream(theFile);
        OutputStreamWriter owstream = new OutputStreamWriter((OutputStream)foutstream, "UTF-8");
        BufferedReader in = new BufferedReader(instream);
        String line = null;
        while ((line = in.readLine()) != null) {
            line = line + "\n";
            if (firstTime) {
                if (line.indexOf("set define") != 0) continue;
                firstTime = false;
                owstream.write(line, 0, line.length());
                continue;
            }
            if (this.skipDate && line.indexOf("--   Date and Time:") == 0) continue;
            owstream.write(line, 0, line.length());
        }
        owstream.flush();
        if (this.debug) {
            this.write(" Wrote " + theFile.length() + " bytes to " + theFile.getAbsolutePath());
        }
        instream.close();
        owstream.close();
        foutstream.close();
        cstmt.close();
    }

    public void exportStaticFiles(BigDecimal workspaceID) throws SQLException, IOException {
        boolean firstTime = true;
        String lstmt = null;
        lstmt = "begin ? := wwv_flow_utilities.export_files_to_clob(?); end;";
        OracleCallableStatement cstmt = (OracleCallableStatement)this.gConn.prepareCall(lstmt);
        cstmt.setBigDecimal(2, workspaceID);
        cstmt.registerOutParameter(1, 2005);
        cstmt.execute();
        CLOB clob = cstmt.getCLOB(1);
        Reader instream = clob.getCharacterStream();
        int size = clob.getBufferSize();
        char[] buffer = new char[size];
        int length = -1;
        File theFile = new File(this._cwd + File.separator + "files_" + workspaceID + ".sql");
        theFile.delete();
        theFile.createNewFile();
        FileOutputStream foutstream = new FileOutputStream(theFile);
        OutputStreamWriter owstream = new OutputStreamWriter((OutputStream)foutstream, "UTF-8");
        BufferedReader in = new BufferedReader(instream);
        String line = null;
        while ((line = in.readLine()) != null) {
            line = line + "\n";
            if (firstTime) {
                if (line.indexOf("set define") != 0) continue;
                firstTime = false;
                owstream.write(line, 0, line.length());
                continue;
            }
            if (this.skipDate && line.indexOf("--   Date and Time:") == 0) continue;
            owstream.write(line, 0, line.length());
        }
        owstream.flush();
        if (this.debug) {
            this.write(" Wrote " + theFile.length() + " bytes to " + theFile.getAbsolutePath() + "\n");
        }
        instream.close();
        owstream.close();
        foutstream.close();
        cstmt.close();
    }

    public void exportFeedback(BigDecimal workspaceID, String deploymentSystem, Date expFeedbackSince) throws SQLException, IOException {
        boolean firstTime = true;
        String lstmt = null;
        lstmt = deploymentSystem == null ? "begin ? := wwv_flow_utilities.export_feedback_to_development(?,?); end;" : "begin ? := wwv_flow_utilities.export_feedback_to_deployment(?,?,?); end;";
        OracleCallableStatement cstmt = (OracleCallableStatement)this.gConn.prepareCall(lstmt);
        if (deploymentSystem == null) {
            cstmt.setDate(3, expFeedbackSince);
            cstmt.setBigDecimal(2, workspaceID);
            cstmt.registerOutParameter(1, 2005);
        } else {
            cstmt.setDate(4, expFeedbackSince);
            cstmt.setString(3, deploymentSystem);
            cstmt.setBigDecimal(2, workspaceID);
            cstmt.registerOutParameter(1, 2005);
        }
        cstmt.execute();
        CLOB clob = cstmt.getCLOB(1);
        Reader instream = clob.getCharacterStream();
        int size = clob.getBufferSize();
        char[] buffer = new char[size];
        int length = -1;
        File theFile = new File(this._cwd + File.separator + "fb" + workspaceID + ".sql");
        theFile.delete();
        theFile.createNewFile();
        FileOutputStream foutstream = new FileOutputStream(theFile);
        OutputStreamWriter owstream = new OutputStreamWriter((OutputStream)foutstream, "UTF-8");
        BufferedReader in = new BufferedReader(instream);
        String line = null;
        while ((line = in.readLine()) != null) {
            line = line + "\n";
            if (firstTime) {
                if (line.indexOf("set define") != 0) continue;
                firstTime = false;
                owstream.write(line, 0, line.length());
                continue;
            }
            if (this.skipDate && line.indexOf("--   Date and Time:") == 0) continue;
            owstream.write(line, 0, line.length());
        }
        owstream.flush();
        if (this.debug) {
            this.write(" Wrote " + theFile.length() + " bytes to " + theFile.getAbsolutePath() + "\n");
        }
        instream.close();
        owstream.close();
        foutstream.close();
        cstmt.close();
    }

    public void export() throws Exception {
        if (this.expWorkspace) {
            this.exportWorkspaces(this.workspaceID, this.expTeamdevdata, this.expMinimal);
        } else if (this.expFeedback) {
            this.ExpFeed(this.workspaceID, this.deploymentSystem, this.expFeedbackSince);
        } else if (this.expFiles) {
            this.exportStaticFiles(this.workspaceID);
        } else {
            this.exportFiles(this.appID, this.workspaceID, this.userName);
        }
    }

    public String usage() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("    -applicationid:    ID for application to be exported\n");
        sb.append("    -workspaceid:      Workspace ID for which all applications to be exported or the workspace to be exported\n");
        sb.append("    -instance:         Export all applications\n");
        sb.append("    -expWorkspace:     Export workspace identified by -workspaceid or all workspaces if -workspaceid not specified\n");
        sb.append("    -expMinimal:       Only export workspace definition, users, and groups\n");
        sb.append("    -expFiles:         Export all workspace files identified by -workspaceid\n");
        sb.append("    -skipExportDate:   Exclude export date from application export files\n");
        sb.append("    -expPubReports:    Export all user saved public interactive reports\n");
        sb.append("    -expSavedReports:  Export all user saved interactive reports\n");
        sb.append("    -expIRNotif:       Export all interactive report notifications\n");
        sb.append("    -expTranslations:  Export the translation mappings and all text from the translation repository\n");
        sb.append("    -expFeedback:      Export team development feedback for all workspaces or identified by -workspaceid to development or deployment\n");
        sb.append("    -expTeamdevdata:   Export team development data for all workspaces or identified by -workspaceid\n");
        sb.append("    -deploymentSystem: Deployment system for exported feedback\n");
        sb.append("    -expFeedbackSince: Export team development feedback since date in the format YYYYMMDD\n");
        sb.append("    -expOriginalIds:   If specified, the application export will emit ids as they were when the application was imported\n");
        sb.append("    -split:            Split the exported file\n");
        sb.append("    -splitFlat:        Split with no directory strucure\n");
        sb.append("    -splitUpdate:      Generate update.sql file while splitting\n");
        sb.append("    -splitNoCheckSum:  Overwrite all files\n");
        sb.append("    \n");
        sb.append(" Application Example:            apex export -applicationid 31500 \n");
        sb.append(" Workspace Example:              apex export -workspaceid 9999\n ");
        sb.append(" Instance Example:               apex export -instance \n");
        sb.append(" Export All Workspaces Example:  apex export -expWorkspace \n");
        sb.append(" Export Feedback to development environment:\n");
        sb.append("         apex export -workspaceid 9999 -expFeedback \n");
        sb.append(" Export Feedback to deployment environment EA2 since 20100308:\n");
        sb.append("         apex export -workspaceid 9999 -expFeedback -deploymentSystem EA2 -expFeedbackSince 20100308 \n");
        return sb.toString();
    }

    public void processArgs(String[] args) throws Exception {
        this.validRequest(true);
        for (int i = 0; args != null && i < args.length && this.isValid(); ++i) {
            if (this.debug) {
                this.write("Parameter:" + args[i]);
            }
            if (args[i].equalsIgnoreCase("-db")) {
                this.url = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-user")) {
                this.userName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-password")) {
                this.password = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-workspaceid")) {
                this.workspaceID = new BigDecimal(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-applicationid")) {
                this.appID = new BigDecimal(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-skipExportDate")) {
                this.skipDate = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expPubReports")) {
                this.pubReports = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expSavedReports")) {
                this.savedReports = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expIRNotif")) {
                this.IRNotifications = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expTranslations")) {
                this.expTranslations = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-instance")) {
                this.instance = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expWorkspace")) {
                this.expWorkspace = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expMinimal")) {
                this.expMinimal = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expFiles")) {
                this.expFiles = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expFeedback")) {
                this.expFeedback = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expTeamdevdata")) {
                this.expTeamdevdata = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-deploymentSystem")) {
                this.deploymentSystem = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-splitNoCheckSum")) {
                this._splitNoCheckSum = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-splitUpdate")) {
                this._splitUpdate = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-splitFlat")) {
                this._splitFlat = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-split")) {
                this._split = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expFeedbackSince")) {
                SimpleDateFormat dtFmt = new SimpleDateFormat("yyyyMMdd");
                try {
                    this.expFeedbackSinceU = dtFmt.parse(args[++i]);
                    this.expFeedbackSince = new Date(this.expFeedbackSinceU.getTime());
                }
                catch (ParseException e) {
                    this.write("Invalid date format: " + args[++i]);
                }
                continue;
            }
            if (args[i].equalsIgnoreCase("-expOriginalIds")) {
                this.expOriginalIds = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expLocked")) {
                this.expLocked = true;
                continue;
            }
            this.write(this.usage());
            this.validRequest(false);
        }
        if (this.debug) {
            this.write(this.url);
            this.write(this.userName);
            this.write(this.password);
            this.write(this.workspaceID);
            this.write(this.appID);
            this.write(this.skipDate);
            this.write(this.pubReports);
            this.write(this.savedReports);
            this.write(this.IRNotifications);
            this.write(this.expTranslations);
            this.write(this.instance);
            this.write(this.expWorkspace);
            this.write(this.expMinimal);
            this.write(this.expFiles);
            this.write(this.expFeedback);
            this.write(this.expTeamdevdata);
            this.write(this.deploymentSystem);
            this.write(this.expFeedbackSinceU);
        }
        if (!(this.appID != null && this.appID.longValue() != 0L || this.workspaceID != null && this.workspaceID.longValue() != 0L)) {
            this.validRequest(false);
        } else {
            this.validRequest(true);
        }
    }

    private void write(Object o) throws UnsupportedEncodingException, IOException {
        this._out.write(o.toString().getBytes("UTF8"));
    }

    public void setOutStream(OutputStream out) {
        this._out = out;
    }

    private void validRequest(boolean b) {
        this._valid = b;
    }

    public boolean isValid() {
        return this._valid;
    }

    public void setConnection(Connection conn) {
        this.gConn = conn;
    }

    public static void main(String[] args) throws Exception {
        APEXExport t = new APEXExport();
        t.processArgs(args);
        t.setOutStream(System.out);
        DriverManager.registerDriver((Driver)new OracleDriver());
        t.gConn = DriverManager.getConnection("jdbc:oracle:thin:@" + t.url, t.userName, t.password);
        t.gConn.setAutoCommit(true);
        t.export();
        t.gConn.close();
        System.exit(0);
    }
}

