/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.apex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.HashSet;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;

public class APEXExportSplitter {
    private boolean flatten = false;
    private boolean checksum = true;
    private boolean debug = false;
    private boolean update = false;
    private String baseFolder;
    private FileOutputStream updateFile;

    public void setOptions(String baseFolder, boolean flat, boolean checksum, boolean debug, boolean update) {
        this.flatten = flat;
        this.checksum = checksum;
        this.debug = debug;
        this.update = update;
        this.baseFolder = baseFolder;
    }

    private void printUpdate(String s) throws Exception {
        if (this.update) {
            if (this.updateFile == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(Calendar.getInstance().get(2));
                sb.append("-");
                sb.append(Calendar.getInstance().get(5));
                sb.append("-");
                sb.append(Calendar.getInstance().get(1));
                sb.append("-");
                sb.append(Calendar.getInstance().get(11));
                sb.append("-");
                sb.append(Calendar.getInstance().get(12));
                sb.append("-");
                sb.append(Calendar.getInstance().get(13));
                String f = this.baseFolder + File.separator + "update-" + sb.toString() + ".sql";
                if (this.flatten) {
                    f = f.replaceAll("/", "_");
                }
                this.updateFile = new FileOutputStream(new File(f));
                this.updateFile.write("@init.sql \r\n".getBytes());
                this.updateFile.write("@env.sql \r\n".getBytes());
            }
            this.updateFile.write(("@" + s + " \r\n").getBytes());
        }
    }

    private void log(String s) {
        if (this.debug) {
            System.out.print(s);
        }
    }

    private static void copy(File src, File dst) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void checkFileForChanges(File file, String filename) throws Exception {
        File dest = new File(filename);
        boolean move = true;
        if (dest.exists() && this.checksum && APEXExportSplitter.getCheckSum(file) == APEXExportSplitter.getCheckSum(dest)) {
            move = false;
        }
        if (move || !this.checksum) {
            this.log("---Renaming... to " + filename + "\n");
            APEXExportSplitter.copy(file, dest);
            this.printUpdate(filename);
        }
        file.delete();
    }

    private static long getCheckSum(File file) {
        long checksum = 0L;
        try {
            CheckedInputStream cis = new CheckedInputStream(new FileInputStream(file), new Adler32());
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            checksum = cis.getChecksum().getValue();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return checksum;
    }

    public void processFile(String fileName) throws IOException, Exception {
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String line = null;
        File tmpFile = null;
        this.baseFolder = fileName.substring(0, fileName.indexOf("."));
        String initFileName = "application/init.sql";
        if (this.flatten) {
            initFileName = initFileName.replaceAll("/", "_");
        }
        StringBuffer runScript = new StringBuffer("@" + initFileName + "\n");
        initFileName = this.baseFolder + "/" + initFileName;
        String currentFileName = null;
        OutputStreamWriter currentWriter = null;
        StringBuffer init = new StringBuffer();
        String currentDir = "";
        HashSet<String> currentDirFiles = new HashSet<String>(100);
        while ((line = in.readLine()) != null) {
            if (line.indexOf("prompt --application") == 0 || line.indexOf("--application") == 0) {
                if (currentWriter != null) {
                    currentWriter.flush();
                    currentWriter.close();
                    this.checkFileForChanges(tmpFile, currentFileName);
                }
                if (!currentDir.equals((currentFileName = line.substring(line.indexOf("--") + 2).trim().replaceAll("\\.", "").replaceAll(" ", "_")).substring(0, currentFileName.lastIndexOf("/")))) {
                    currentDir = currentFileName.substring(0, currentFileName.lastIndexOf("/"));
                    currentDirFiles.clear();
                }
                String baseFileName = currentFileName;
                int i = 1;
                while (currentDirFiles.contains(currentFileName)) {
                    currentFileName = baseFileName + "_" + ++i;
                }
                currentDirFiles.add(currentFileName);
                currentFileName = currentFileName + ".sql";
                if (this.flatten) {
                    currentFileName = currentFileName.replaceAll("/", "_");
                }
                currentFileName = this.baseFolder + "/" + currentFileName;
                File dir = new File(currentFileName.substring(0, currentFileName.lastIndexOf("/")));
                dir.mkdirs();
                runScript.append("@" + currentFileName.substring(currentFileName.indexOf("/") + 1) + "\n");
                tmpFile = File.createTempFile("apex", ".sql");
                this.log("--Processing:" + currentFileName + "\n");
                currentWriter = new FileWriter(tmpFile);
            }
            if (currentWriter != null) {
                currentWriter.write(line + "\n");
                continue;
            }
            init.append(line + "\n");
        }
        currentWriter.flush();
        currentWriter.close();
        this.checkFileForChanges(tmpFile, currentFileName);
        FileWriter file = new FileWriter(initFileName);
        file.write(init.toString());
        file.flush();
        file.close();
        String installFileName = "install.sql";
        if (this.flatten) {
            installFileName = installFileName.replaceAll("/", "_");
        }
        file = new FileWriter(this.baseFolder + "/" + installFileName);
        file.write(runScript.toString());
        file.flush();
        file.close();
        if (this.updateFile != null) {
            this.updateFile.close();
        }
    }

    public static void usage() {
        System.out.println("-help       : < print this syntax >");
        System.out.println("-flat       : < flat file structure >");
        System.out.println("-debug      : < print debug info >");
        System.out.println("-update     : < create update file >");
        System.out.println("-nochecksum : < don't check for changes >");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        String arg;
        int i;
        if (args.length == 0) {
            APEXExportSplitter.usage();
        }
        APEXExportSplitter s = new APEXExportSplitter();
        for (i = 0; i < args.length; ++i) {
            arg = args[i];
            if (arg.equals("-flat")) {
                s.flatten = true;
                System.out.println("Using flat structure");
                continue;
            }
            if (arg.equals("-nochecksum")) {
                s.checksum = false;
                continue;
            }
            if (arg.equals("-debug")) {
                s.debug = true;
                continue;
            }
            if (arg.equals("-update")) {
                s.update = true;
                continue;
            }
            if (!arg.equals("-help")) continue;
            APEXExportSplitter.usage();
        }
        for (i = 0; i < args.length; ++i) {
            arg = args[i];
            if (arg.indexOf("-") != -1) continue;
            try {
                System.out.println("Processing:" + arg);
                s.processFile(arg);
                continue;
            }
            catch (Exception e) {
                System.err.println("Could not process:" + arg);
                System.err.println(e.getMessage());
                if (!s.debug) continue;
                e.printStackTrace();
            }
        }
    }
}

