/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.net.ns.NSProtocol;

@Restricted(level=Restricted.Level.R4)
public class PingCmd
extends CommandListener
implements IHelp {
    public static long UNKNOWN = -2L;
    public static long DOWN = -1L;
    private static Logger LOGGER = Logger.getLogger(PingCmd.class.getName());
    private static Class<? extends NSProtocol> s_protCls;

    @Override
    public String getCommand() {
        return "TNSPING";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (PingCmd.matches("tnsping", cmd.getSql())) {
            String rawName;
            String string = rawName = cmd.getSql().indexOf(" ") > 0 ? cmd.getSql().substring(cmd.getSql().indexOf(" ")).trim() : null;
            if (rawName != null) {
                ctx.write(" ping:" + PingCmd.ping(ctx, rawName) + "ms\n");
            } else {
                ctx.write(this.getHelp());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long ping(ScriptRunnerContext ctx, String tns) {
        long ret = UNKNOWN;
        String retMsg = null;
        long start = System.currentTimeMillis();
        Properties props = new Properties();
        props.put("oracle.net.CONNECT_TIMEOUT", "2000");
        props.put("oracle.net.networkCompression", "off");
        props.put("oracle.net.networkCompressionThreshold", "1024");
        props.put("oracle.net.networkCompressionLevels", "(high)");
        props.put("oracle.net.DOWN_HOSTS_TIMEOUT", "600");
        String translated = null;
        String urlString = tns;
        if (urlString.indexOf("jdbc") == 0) {
            String jdbc = "";
            translated = urlString.substring(urlString.indexOf("@"));
        } else {
            translated = tns;
            for (TCPTNSEntry entry : TNSHelper.getTNSEntries()) {
                if (!entry.getName().equalsIgnoreCase(tns)) continue;
                tns = entry.getHostname() + ":" + entry.getPortno();
                tns = entry.getSid() != null ? tns + ":" + entry.getSid() : tns + "/" + entry.getServicename();
                if (tns.length() <= 0) break;
                translated = tns;
                break;
            }
        }
        NSProtocol nsp = PingCmd.createProtocolInstance();
        if (nsp != null) {
            try {
                try {
                    nsp.connect(translated, props);
                }
                catch (Exception e) {
                    String msg = e.getLocalizedMessage();
                    int idx = msg.indexOf("ORA-");
                    if (idx > 0) {
                        retMsg = msg = msg.substring(idx);
                        ctx.write(msg + "\n");
                    }
                    ret = DOWN;
                    throw e;
                }
                ret = System.currentTimeMillis() - start;
            }
            catch (Exception e) {
                LOGGER.finest(e.getMessage());
            }
            finally {
                if (nsp != null) {
                    try {
                        nsp.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return ret;
    }

    private static NSProtocol createProtocolInstance() {
        if (s_protCls == null) {
            try {
                s_protCls = Class.forName("oracle.net.ns.NSProtocolStream");
            }
            catch (ClassNotFoundException e) {
                s_protCls = NSProtocol.class;
            }
        }
        NSProtocol prot = null;
        if (s_protCls != null) {
            try {
                prot = s_protCls.newInstance();
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }
        return prot;
    }
}

