/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.JSONWrapBufferedOutputStream;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.IOnConnection;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class SetServerOutput
extends AForAllStmtsCommand
implements IOnConnection {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_SERVEROUTPUT;
    private static Hashtable<Connection, Boolean> m_enableHashFlag = new Hashtable();
    private boolean isDbmsOn = false;

    public SetServerOutput() {
        super(m_cmdStmtSubType);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean noConn = false;
        super.beginEvent(conn, ctx, cmd);
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            noConn = true;
        }
        if (cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SHOW)) {
            boolean fromCall;
            Boolean amIOn = Boolean.FALSE;
            boolean bl = fromCall = ctx.getProperty("script.runner.serveroutputnologpending") != null && Boolean.valueOf(ctx.getProperty("script.runner.serveroutputnologpending").equals(Boolean.TRUE)) != false;
            if (!noConn) {
                fromCall = SetServerOutput.isEnabled(ctx.getCurrentConnection());
            }
            if (fromCall) {
                amIOn = Boolean.TRUE;
            }
            ctx.putProperty("script.runner.context.serveroutput", amIOn);
        }
        if (this instanceof IOnConnection && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_DISCONNECT)) {
            this.runOnDisconnect(conn, ctx, cmd);
        }
    }

    public static void coreEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block13: {
            block14: {
                block15: {
                    if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
                        return;
                    }
                    cmd.getStmtSubType();
                    if (cmd != null) {
                        if (cmd.getProperty("prop_dbms_output_called") != null) {
                            return;
                        }
                        cmd.setProperty("prop_dbms_output_called", Boolean.TRUE);
                    }
                    if (ctx == null || ctx.getProperty("sqlcl.serveroutput.optimized") == null || cmd == null || cmd.isFail() || cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_CALL || cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_EXECUTE) break block13;
                    if (cmd.getStmtType() != SQLCommand.StmtType.G_C_SQL && cmd.getStmtType() != SQLCommand.StmtType.G_C_PLSQL) break block14;
                    if (cmd.getStmtType() != SQLCommand.StmtType.G_C_SQL || cmd.getStmtSubType() == SQLCommand.StmtSubType.G_S_SELECT) break block15;
                    SQLCommand.StmtSubType stmtSubType = cmd.getStmtSubType();
                    cmd.getStmtSubType();
                    if (stmtSubType != SQLCommand.StmtSubType.G_S_WITH) break block14;
                }
                if (cmd.getStmtSubType() != SQLCommand.StmtSubType.G_S_ALTER && !cmd.isCreateCmd() && cmd.getExecutable() && !cmd.getLoweredTrimmedSQL().equals("begin\nnull;\nend;")) break block13;
            }
            return;
        }
        if (conn != null && conn instanceof OracleConnection) {
            String s = "\n";
            Boolean paneRegistered = (Boolean)ctx.getProperty("script.runner.dbmsouputpane");
            if ((SetServerOutput.isEnabled(conn) || paneRegistered != null && paneRegistered.equals(Boolean.TRUE)) && !ScriptUtils.isHttpCon(conn, ctx)) {
                s = SetServerOutput.format(ctx, DBUtil.getInstance(conn).getDBMSOUTPUT());
            }
            if (!s.equals("\n")) {
                try {
                    if (SetServerOutput.isEnabled(conn)) {
                        if (ctx.getOutputStream() instanceof JSONWrapBufferedOutputStream) {
                            ((JSONWrapBufferedOutputStream)ctx.getOutputStream()).addStmtInfo(SetServerOutput.getDBMSOUTPUTJSON(s));
                        }
                        ctx.getOutputStream().write(ctx.stringToByteArrayForScriptRunnerNonStatic(s));
                    }
                    ctx.pushDbmsOutput(s);
                }
                catch (IOException e) {
                    Logger.getLogger(new SetServerOutput().getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
    }

    private static String getDBMSOUTPUTJSON(String s) {
        return "\"dbmsOutput\":" + JSONWrapBufferedOutputStream.quote(s, true);
    }

    @Override
    protected void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        SetServerOutput.coreEndWatcher(conn, ctx, cmd);
    }

    private static boolean isEnabled(Connection conn) {
        if (conn != null) {
            if (m_enableHashFlag.get(conn) == null) {
                return false;
            }
            return m_enableHashFlag.get(conn);
        }
        return false;
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        boolean noConn = false;
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            noConn = true;
        }
        int flag = this.getSetServerOnOrOff(cmd);
        boolean retValue = false;
        switch (flag) {
            case 3: {
                ctx.removeProperty("sqlcl.serveroutput.optimized");
                break;
            }
            case 2: {
                ctx.putProperty("sqlcl.serveroutput.optimized", Boolean.TRUE);
                break;
            }
            case 1: {
                retValue = this.setServerOutputOn(conn, ctx, cmd, noConn);
                this.isDbmsOn = true;
                break;
            }
            case 0: {
                retValue = this.setServerOutputOnOrOff(conn, ctx, cmd, noConn, true);
                if (!noConn) {
                    ctx.enableDbmsOutput();
                }
                this.isDbmsOn = true;
                break;
            }
            default: {
                if (ctx.isSQLPlusClassic()) {
                    ctx.write(Messages.getString("SETSERVEROUTPUTONOROFF"));
                } else {
                    ctx.write(Messages.getString("SETSERVEROUTPUTONOROFFOPT"));
                }
                return false;
            }
        }
        return retValue;
    }

    private boolean setServerOutputOff(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        DBUtil.getInstance(conn).execute("BEGIN DBMS_OUTPUT.DISABLE(); END;", (List)null);
        m_enableHashFlag.put(conn, false);
        ctx.enableDbmsOutput();
        return true;
    }

    private boolean setServerOutputOn(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, boolean noConn) {
        return this.setServerOutputOnOrOff(conn, ctx, cmd, noConn, false);
    }

    private boolean setServerOutputOnOrOff(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, boolean noConn, boolean isOff) {
        FormatStyle toSet;
        block47: {
            String[] split;
            String theSqlLower;
            toSet = null;
            String theSql = cmd.getSql();
            if (isOff) {
                theSql = (theSql + " ").replaceFirst("(?i) off ", " on ").trim();
            }
            if ((theSqlLower = theSql.toLowerCase(Locale.US)).indexOf("for") != -1 && (split = theSqlLower.trim().split("\\s+")) != null && split.length > 1) {
                int forAt = -1;
                for (int word = split.length - 2; word > 1; --word) {
                    if (!split[word].matches("^fo(?:r|rm|rma|rmat)$")) continue;
                    forAt = word;
                    break;
                }
                if (forAt != -1) {
                    if (split[forAt + 1].matches("^wr(?:a|ap|app|appe|apped)$")) {
                        toSet = FormatStyle.WRAPPED;
                    } else if (split[forAt + 1].matches("^wo(?:r|rd|rd_|rd_w|rd_wr|rd_wra|rd_wrap|rd_wrap|rd_wrapp|rd_wrappe|rd_wrapped)$")) {
                        toSet = FormatStyle.WORD_WRAPPED;
                    } else if (split[forAt + 1].matches("^tr(?:u|un|unc|unca|uncat|uncate|uncated)$")) {
                        toSet = FormatStyle.TRUNCATED;
                    } else {
                        SetServerOutput.writeUsage(ctx);
                        return false;
                    }
                }
            }
            if (toSet == null) {
                toSet = (FormatStyle)((Object)ctx.getProperty("script.runner.serveroutformat"));
                if (toSet == null) {
                    toSet = FormatStyle.WORD_WRAPPED;
                }
            } else {
                theSql = theSql.replaceFirst("(?i)for[^\\s]*\\s\\s*[^\\s][^\\s]*", "");
            }
            String numberOrUnlimited = theSql.toLowerCase().replace("\n", " ").replace("-", "").replace("\\", " ").replaceAll("\\s+", " ").trim().replace("set serveroutput on size", "").replace("set serveroutpu on size", "").replace("set serveroutp on size", "").replace("set serverout on size", "").trim();
            DBUtil dbinst = null;
            if (!noConn) {
                dbinst = DBUtil.getInstance(conn);
                SetServerOutput.hackExceptionHandler(dbinst);
            }
            if (numberOrUnlimited.equals("unlimited") || numberOrUnlimited.equals("unl") || numberOrUnlimited.equals("unli") || numberOrUnlimited.equals("unlim") || numberOrUnlimited.equals("unlimi") || numberOrUnlimited.equals("unlimit") || numberOrUnlimited.equals("unlimite")) {
                if (!noConn) {
                    if (!isOff) {
                        dbinst.execute("begin dbms_output.enable(1000000); end;", (List)null);
                    } else {
                        dbinst.execute("begin dbms_output.disable(); end;", (List)null);
                    }
                }
                SQLException ex = null;
                if (!noConn) {
                    ex = dbinst.getLastException();
                }
                if (ex != null) {
                    System.out.println(ex.getLocalizedMessage());
                    return false;
                }
                ctx.putProperty("script.runner.lastsetserveroutput", new Integer(1000000));
                ctx.putProperty("script.runner.serveroutputunlimited", Boolean.TRUE);
                if (!noConn) {
                    if (isOff) {
                        m_enableHashFlag.put(conn, false);
                    } else {
                        this.flushOnSwitchOn(conn, ctx);
                        m_enableHashFlag.put(conn, true);
                    }
                }
            } else {
                try {
                    int i = new Integer(numberOrUnlimited);
                    if (i > 1999 && i < 1000001) {
                        if (!noConn) {
                            if (!isOff) {
                                dbinst.execute("begin dbms_output.enable(" + i + "); end;", (List)null);
                            } else {
                                dbinst.execute("begin dbms_output.disable(); end;", (List)null);
                            }
                        }
                        SQLException ex = null;
                        if (!noConn) {
                            ex = dbinst.getLastException();
                        }
                        if (ex != null) {
                            System.out.println(ex.getLocalizedMessage());
                            return false;
                        }
                        if (!noConn) {
                            if (isOff) {
                                m_enableHashFlag.put(conn, false);
                            } else {
                                this.flushOnSwitchOn(conn, ctx);
                                m_enableHashFlag.put(conn, true);
                            }
                        }
                    } else {
                        ctx.write(MessageFormat.format(Messages.getString("SERVEROUTPUT_ERROR"), numberOrUnlimited) + "\n");
                        return false;
                    }
                    ctx.putProperty("script.runner.lastsetserveroutput", new Integer(i));
                    ctx.putProperty("script.runner.serveroutputunlimited", Boolean.FALSE);
                }
                catch (NumberFormatException nfe) {
                    Integer prevNum = (Integer)ctx.getProperty("script.runner.lastsetserveroutput");
                    Boolean wasUnlimited = (Boolean)ctx.getProperty("script.runner.serveroutputunlimited");
                    Throwable ex = null;
                    if (!noConn) {
                        SetServerOutput.hackExceptionHandler(dbinst);
                        if (!isOff) {
                            if (prevNum != null) {
                                dbinst.execute("begin dbms_output.enable(" + prevNum + "); end;", (List)null);
                            } else {
                                dbinst.execute("begin dbms_output.enable(1000000); end;", (List)null);
                            }
                        } else {
                            dbinst.execute("begin dbms_output.disable(); end;", (List)null);
                        }
                        ex = dbinst.getLastException();
                    }
                    if (ex != null) {
                        System.out.println(ex.getLocalizedMessage());
                        return false;
                    }
                    if (prevNum == null) {
                        ctx.putProperty("script.runner.lastsetserveroutput", new Integer(1000000));
                    }
                    if (wasUnlimited == null) {
                        ctx.putProperty("script.runner.serveroutputunlimited", Boolean.TRUE);
                    }
                    if (!(numberOrUnlimited == null || numberOrUnlimited.equals("set serveroutput on") || numberOrUnlimited.equals("set serveroutput on") || numberOrUnlimited.equals("set serveroutpu on") || numberOrUnlimited.equals("set serveroutp on") || numberOrUnlimited.equals("set serverout on"))) {
                        SetServerOutput.writeUsage(ctx);
                    }
                    if (noConn) break block47;
                    if (isOff) {
                        m_enableHashFlag.put(conn, false);
                    }
                    this.flushOnSwitchOn(conn, ctx);
                    m_enableHashFlag.put(conn, true);
                }
            }
        }
        ctx.putProperty("script.runner.serveroutformat", (Object)toSet);
        if (noConn) {
            ctx.putProperty("script.runner.serveroutputnologpending", !isOff);
        }
        return true;
    }

    private static void writeUsage(ScriptRunnerContext ctx) {
        if (ctx.isSQLPlusClassic()) {
            ctx.write("Usage: SET SERVEROUTPUT { ON | OFF } [SIZE {n | UNL[IMITED]}] \n      [ FOR[MAT] { WRA[PPED] | WOR[D_WRAPPED] | TRU[NCATED] } ]\n");
        } else {
            ctx.write("Usage: SET SERVEROUTPUT { OPTIMIZED | UNOPTIMIZED | { ON | OFF } [SIZE {n | UNL[IMITED]}] \n      [ FOR[MAT] { WRA[PPED] | WOR[D_WRAPPED] | TRU[NCATED] } ]}\n");
        }
    }

    public static void hackExceptionHandler(DBUtil dbinst) {
        SQLException old = dbinst.getLastException();
        if (old != null) {
            System.out.println(old.getLocalizedMessage());
        }
        try {
            Method clearLastException = DBUtil.class.getDeclaredMethod("clearLastException", new Class[0]);
            clearLastException.setAccessible(true);
            clearLastException.invoke((Object)dbinst, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        MessageLogging.setMessageLogger(new MessageLogging(){

            @Override
            public void log(String txt) {
                System.out.println(txt);
            }
        });
    }

    private int getSetServerOnOrOff(ISQLCommand cmd) {
        String[] splitSql = cmd.getSql().toLowerCase().replaceFirst("set", " ").replaceFirst("serverout[a-z]*", " ").trim().split(" ");
        if (splitSql[0].equalsIgnoreCase("on")) {
            return 1;
        }
        if (splitSql[0].equalsIgnoreCase("off")) {
            return 0;
        }
        if (splitSql[0].equalsIgnoreCase("optimized") && splitSql.length == 1) {
            return 2;
        }
        if (splitSql[0].equalsIgnoreCase("unoptimized") && splitSql.length == 1) {
            return 3;
        }
        return -1;
    }

    @Override
    protected boolean isListenerOn(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.isDbmsOn;
    }

    @Override
    public void setCmdOn(boolean cmdOn) {
        super.setCmdOn(cmdOn);
        this.isDbmsOn = cmdOn;
    }

    protected void flushOnSwitchOn(Connection conn, ScriptRunnerContext ctx) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        if (conn instanceof OracleConnection && !SetServerOutput.isEnabled(conn)) {
            String s = "\n";
            DBUtil dbinst = DBUtil.getInstance(conn);
            if (!ScriptUtils.isHttpCon(conn, ctx)) {
                s = SetServerOutput.format(ctx, dbinst.getDBMSOUTPUT());
            }
            if (!s.equals("\n")) {
                ctx.pushDbmsOutput(s);
            }
        }
    }

    private static String format(ScriptRunnerContext ctx, String rawInString) {
        Integer linesize;
        if (rawInString == null) {
            return "";
        }
        FormatStyle formatStyle = (FormatStyle)((Object)ctx.getProperty("script.runner.serveroutformat"));
        StringBuffer retVal = null;
        StringBuffer rawIn = null;
        if (rawInString != null) {
            rawIn = new StringBuffer(rawInString);
        }
        if (formatStyle == null) {
            formatStyle = FormatStyle.WORD_WRAPPED;
        }
        if ((linesize = (Integer)ctx.getProperty("script.runner.setlinesize")) == null || linesize == -1) {
            linesize = Integer.MAX_VALUE;
        }
        switch (formatStyle) {
            case WRAPPED: {
                retVal = ScriptUtils.wrap(2005, linesize, rawIn);
                break;
            }
            case WORD_WRAPPED: {
                retVal = ScriptUtils.wordwrap(2005, linesize, rawIn, Integer.MAX_VALUE);
                break;
            }
            case TRUNCATED: {
                retVal = SetServerOutput.truncLines(rawIn, linesize);
            }
        }
        String retValString = null;
        if (retVal != null) {
            retValString = retVal.toString();
        }
        return retValString;
    }

    public static StringBuffer truncLines(StringBuffer buf, int linesize) {
        StringBuffer output = new StringBuffer();
        if (buf == null) {
            return output;
        }
        int intMax = buf.length();
        int curPos = -1;
        int nextPos = 0;
        while ((nextPos = buf.indexOf("\n", curPos + 1)) != -1) {
            int thislinesize = nextPos - (curPos + 1);
            if (thislinesize < linesize) {
                output.append(buf.substring(curPos + 1, nextPos + 1));
            } else {
                boolean wasr = false;
                if (nextPos > 0 && thislinesize != linesize) {
                    wasr = buf.charAt(nextPos - 1) == '\n';
                }
                output.append(buf.substring(curPos + 1, curPos + 1 + linesize));
                if (wasr) {
                    output.append("\r\n");
                } else {
                    output.append("\n");
                }
            }
            curPos = nextPos;
        }
        if (curPos + 1 < intMax) {
            if (intMax - curPos < linesize) {
                output.append(buf.substring(curPos + 1));
            } else {
                output.append(buf.substring(curPos + 1, curPos + 1 + linesize));
            }
        }
        return output;
    }

    public static String serverOutputFormatToString(ScriptRunnerContext ctx) {
        FormatStyle formatStyle = (FormatStyle)((Object)ctx.getProperty("script.runner.serveroutformat"));
        if (formatStyle == null) {
            formatStyle = FormatStyle.WORD_WRAPPED;
        }
        return "FORMAT " + formatStyle.toString();
    }

    @Override
    public boolean runOnConnect(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        conn = ctx.getCurrentConnection();
        Boolean wasFirstConnect = ctx.getProperty("script.runner.connectcalled") == null || Boolean.valueOf(ctx.getProperty("script.runner.connectcalled").equals(Boolean.TRUE)) == false;
        if (ctx.getProperty("script.runner.sqlplus.nolog") == null || !Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            ctx.putProperty("script.runner.connectcalled", Boolean.TRUE);
        }
        boolean closedOrError = false;
        try {
            closedOrError = conn == null || conn.isClosed() || ctx.getProperty("script.runner.serveroutputnologpending") == null || Boolean.valueOf(ctx.getProperty("script.runner.serveroutputnologpending").equals(Boolean.FALSE)) != false;
        }
        catch (SQLException e) {
            closedOrError = true;
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
        }
        if (wasFirstConnect.booleanValue() && conn != null && conn instanceof OracleConnection && ctx != null && (ctx.getProperty("script.runner.sqlplus.nolog") == null || !Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) && !closedOrError) {
            Integer numb;
            DBUtil dbinst = DBUtil.getInstance(conn);
            SQLException e = dbinst.getLastException();
            if (e != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
            }
            if ((numb = (Integer)ctx.getProperty("script.runner.lastsetserveroutput")) == null) {
                numb = 100000;
            }
            ArrayList<Integer> forBinds = new ArrayList<Integer>();
            forBinds.add(numb);
            dbinst.execute("begin dbms_output.enable(:size); end;", forBinds);
            SQLException ex = dbinst.getLastException();
            if (ex != null) {
                ctx.write("SET SETSERVEROUT ON:" + ex.getLocalizedMessage());
                return false;
            }
            ctx.putProperty("script.runner.lastsetserveroutput", new Integer(1000000));
            m_enableHashFlag.put(conn, true);
            ctx.putProperty("script.runner.serveroutputnologpending", Boolean.FALSE);
            this.isDbmsOn = true;
        }
        if (ctx.getProperty("script.runner.sqlplus.nolog") == null || !Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            ctx.putProperty("script.runner.serveroutputnologpending", Boolean.FALSE);
        }
        return true;
    }

    @Override
    public boolean runOnDisconnect(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return true;
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        super.endEvent(conn, ctx, cmd);
        if (this instanceof IOnConnection && cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CONNECT)) {
            this.runOnConnect(conn, ctx, cmd);
        }
    }

    public static enum FormatStyle {
        WRAPPED,
        WORD_WRAPPED,
        TRUNCATED;

    }
}

