/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowEncoding
implements IShowCommand {
    private static final String[] SHOWENCODING = new String[]{"encoding"};

    @Override
    public String[] getShowAliases() {
        return SHOWENCODING;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowEncoding(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowEncoding(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx.getEncoding() != null) {
                ctx.write("encoding \"" + ctx.getEncoding() + "\"\n");
            } else {
                ctx.write("encoding \"\" \n");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }
}

