/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.math.BigInteger;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowHeadsep
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWHEADSEP = new String[]{"heads", "headse", "headsep"};

    @Override
    public String[] getShowAliases() {
        return SHOWHEADSEP;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowHeadsep(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowHeadsep(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String onoroff = (String)ctx.getProperty("script.runner.setheadsep");
        if (onoroff.matches("(?i:on|off)")) {
            String str = "";
            if (onoroff.equalsIgnoreCase("ON")) {
                String hschar = (String)ctx.getProperty("script.runner.setheadsepchar");
                str = MessageFormat.format(Messages.getString("HEADSEP_ON"), hschar, String.format("%x", new BigInteger(hschar.getBytes())));
                str = str + Show.m_lineSeparator;
            } else {
                str = Messages.getString("HEADSEP_OFF") + Show.m_lineSeparator;
            }
            ctx.write(str);
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String onoroff = (String)ctx.getProperty("script.runner.setheadsep");
        if (onoroff.matches("(?i:on|off)")) {
            String str = "";
            if (onoroff.equalsIgnoreCase("ON")) {
                return StoreRegistry.getCommand("headsep", "ON");
            }
            return StoreRegistry.getCommand("headsep", "ON");
        }
        return StoreRegistry.getCommand("headsep", "ON");
    }
}

