/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.Show;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowPagesize
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWPAGESIZE = new String[]{"pages", "pagesi", "pagesiz", "pagesize"};

    @Override
    public String[] getShowAliases() {
        return SHOWPAGESIZE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowPagesize(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowPagesize(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Integer val = (Integer)ctx.getProperty("script.runner.setpagesize");
        String str = MessageFormat.format(Messages.getString("PAGESIZE"), val.toString()) + Show.m_lineSeparator;
        ctx.write(str);
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("pagesize", String.valueOf(ctx.getProperty("script.runner.setpagesize")));
    }
}

