/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IEndOfShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowAllNeither;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowRegistry;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowParameter
implements IShowCommand,
IEndOfShowCommand,
IShowAllNeither {
    private static final String[] SHOWPARAMETER = new String[]{"parameter", "parameters"};

    @Override
    public String[] getShowAliases() {
        return SHOWPARAMETER;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowParameter(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doShowParameter(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block30: {
            String toLower = ScriptUtils.eatOneWord(cmd.getSql()).toLowerCase();
            String userArgument = null;
            userArgument = toLower.startsWith(SHOWPARAMETER[1]) ? toLower.replaceAll("^" + SHOWPARAMETER[1], "").trim().split("\\s+")[0] : toLower.replaceAll("^" + SHOWPARAMETER[0], "").trim().split("\\s+")[0];
            if (userArgument.equalsIgnoreCase("flagger") && !ShowRegistry.get(userArgument)) {
                ctx.write(ScriptUtils.eatOneWord(cmd.getSql()) + " unsupported\n");
                return false;
            }
            String argument = "%";
            if (!userArgument.equals("")) {
                argument = "%" + userArgument + "%";
            }
            boolean amILocked = false;
            ResultSet rset = null;
            Connection currConn = ctx.getCurrentConnection();
            try {
                amILocked = LockManager.lock(currConn);
                if (!amILocked) break block30;
                String querySql = null;
                ctx.putProperty("sqldev.last.err.message.forsqlcode", null);
                querySql = VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(currConn)).compareTo(new Version("10.0")) >= 0 ? "SELECT   substr(NAME,0,50) NAME, DECODE(TYPE,1,'boolean',2,'string',3,'integer',4,'file',5,'number',  6,'big integer', 'unknown') TYPE, substr(DISPLAY_VALUE,0,100) VALUE FROM V$PARAMETER  WHERE UPPER(NAME) LIKE UPPER(:NMBIND_SHOW_OBJ) ORDER BY NAME,ROWNUM" : "SELECT substr(NAME,0,50) NAME, DECODE(TYPE,1,'boolean',2,'string',3,'integer',4,'file',6,'big integer',  'unknown') TYPE, substr(VALUE,0,100) VALUE FROM V$PARAMETER WHERE UPPER(NAME) LIKE UPPER(:NMBIND_SHOW_OBJ)  ORDER BY NAME,ROWNUM ";
                ArrayList<String> localBind = new ArrayList<String>();
                localBind.add(argument);
                rset = DBUtil.getInstance(currConn).executeQuery(querySql, localBind);
                if (rset != null) {
                    Integer fs;
                    ResultSetFormatter rFormat;
                    block31: {
                        rFormat = new ResultSetFormatter(ctx);
                        rFormat.setProgressUpdater(ctx.getTaskProgressUpdater());
                        fs = null;
                        try {
                            if (ctx.getProperty("script.runner.arraysize") != null) {
                                fs = Integer.valueOf((String)ctx.getProperty("script.runner.arraysize"));
                                break block31;
                            }
                            boolean doubleLocked = false;
                            Connection baseConn = ctx.getBaseConnection();
                            if (baseConn != null) {
                                doubleLocked = LockManager.lock(baseConn);
                            }
                            if (!doubleLocked) break block31;
                            try {
                                Properties props = ConnectionResolver.getConnectionInfo(ConnectionResolver.getConnectionName(baseConn));
                                fs = Integer.valueOf(props.getProperty("PreferfedFetchSize"));
                            }
                            finally {
                                LockManager.unlock(baseConn);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (fs != null) {
                        try {
                            rset.setFetchSize(fs);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    rFormat.rset2sqlplusShrinkToSize(rset, currConn, ctx.getOutputStream());
                    break block30;
                }
                ctx.write(Messages.getString("SHOWPARAMETERSNORESULTSET"));
            }
            catch (IOException e) {
                ctx.write(e.getLocalizedMessage());
            }
            catch (SQLException e) {
                ctx.putProperty("sqldev.last.err.message.forsqlcode", e.getMessage());
                ctx.write(e.getLocalizedMessage());
            }
            finally {
                if (rset != null) {
                    DBUtil.closeResultSet(rset);
                }
                if (amILocked) {
                    try {
                        LockManager.unlock(currConn);
                    }
                    catch (Exception e) {}
                }
            }
        }
        return true;
    }
}

