/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.net.URL;
import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowURLs
implements IShowCommand {
    private static final String[] SHOWURLS = new String[]{"url"};

    @Override
    public String[] getShowAliases() {
        return SHOWURLS;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowURLs(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowURLs(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx.getProperty("script.runner.topbase.url") != null) {
                ctx.write(SHOWURLS[0] + " top_base_url \"" + ((URL)ctx.getProperty("script.runner.topbase.url")).toString() + "\"");
            } else {
                ctx.write(SHOWURLS[0] + " top_base_url \"\"");
            }
            if (ctx.getProperty("script.runner.base.url") != null) {
                ctx.write("    base_url \"" + ((URL)ctx.getProperty("script.runner.base.url")).toString() + "\"");
            } else {
                ctx.write("    base_url \"\"");
            }
            if (ctx.getProperty("script.runner.node.url") != null) {
                String s = ((URL)ctx.getProperty("script.runner.node.url")).toString();
                int bslash = s.lastIndexOf(92);
                int fslash = s.lastIndexOf(47);
                if (fslash > bslash) {
                    bslash = fslash;
                }
                if (bslash != -1) {
                    ctx.write("    node_url " + Messages.getString("PARENT") + " \"" + s.substring(0, bslash) + "\"\n");
                } else {
                    ctx.write("    node_url \"" + s + "\"\n");
                }
            } else {
                ctx.write("    node_url \"\" \n");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }
}

