/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.util.Logger;
import oracle.jdbc.OracleConnection;

public class NLSLang {
    private static final String NLS_LANG = "NLS_LANG";
    private static HashMap<String, String> language = new HashMap();
    private static ArrayList<String> territory = new ArrayList();

    public static void main(String[] args) {
        ProcessBuilder pb = new ProcessBuilder("/bin/bash");
        System.out.println(NLSLang.getLanguageFromNLS_LANG());
        System.out.println(NLSLang.getTerritoryFromNLS_LANG());
        System.out.println(NLSLang.getCharSetFromNLS_LANG());
    }

    public static String setLangFromNLS_LANG() {
        if (NLSLang.getLanguageFromNLS_LANG() == null) {
            return null;
        }
        String nlslanguage = NLSLang.getLanguageFromNLS_LANG();
        if (!language.containsKey(nlslanguage.toUpperCase())) {
            Logger.log(NLSLang.class, Level.FINE, "Invalid NLS Language:" + nlslanguage.toUpperCase(), null);
            return null;
        }
        return "alter session set NLS_LANGUAGE='" + NLSLang.getLanguageFromNLS_LANG() + "'";
    }

    public static String setTerritoryFromNLS_LANG() {
        if (NLSLang.getTerritoryFromNLS_LANG() == null) {
            Logger.log(NLSLang.class, Level.FINE, "Invalid NLS Territory on NLS_LANG", null);
            return null;
        }
        return "alter session set NLS_TERRITORY='" + NLSLang.getTerritoryFromNLS_LANG() + "'";
    }

    public static String setEncodingFromNLS_LANG() {
        if (NLSLang.getCharSetFromNLS_LANG() == null) {
            return null;
        }
        System.out.println(MessageFormat.format("Set local console encoding:{0}", NLSLang.getCharSetFromNLS_LANG()));
        return null;
    }

    public static String getLanguageFromNLS_LANG() {
        String val = System.getenv(NLS_LANG);
        if (val != null && val.length() > 0) {
            if (val.contains("_")) {
                String[] vals = val.split("_");
                if (vals.length > 1 && vals[0].length() > 0) {
                    return vals[0];
                }
                return null;
            }
            if (val.contains(".")) {
                String[] vals = val.split(".");
                if (vals.length > 1) {
                    return vals[0];
                }
                return null;
            }
            return val;
        }
        return null;
    }

    public static String getTerritoryFromNLS_LANG() {
        String val = System.getenv(NLS_LANG);
        if (val != null && val.length() > 0) {
            if (!val.contains("_")) {
                return null;
            }
            if (val.contains(".")) {
                val = val.substring(0, val.indexOf(46));
            }
            return val.substring(val.indexOf("_") + 1, val.length());
        }
        return null;
    }

    public static String getCharSetFromNLS_LANG() {
        String val = System.getenv(NLS_LANG);
        if (val != null && val.length() > 0) {
            if (!val.contains(".")) {
                return null;
            }
            return val.substring(val.indexOf(".") + 1, val.length());
        }
        return null;
    }

    public static String getLanguage(String abbreviation) {
        for (String langSelection : language.keySet()) {
            String abrev = language.get(langSelection);
            if (!abrev.equalsIgnoreCase(abbreviation)) continue;
            return langSelection;
        }
        return null;
    }

    public static String getLanguageAbbreviation(String languageSelection) {
        for (String langSelection : language.keySet()) {
            if (!langSelection.equalsIgnoreCase(languageSelection)) continue;
            return language.get(langSelection);
        }
        return null;
    }

    public static boolean isNLSLANGSet() {
        return System.getenv(NLS_LANG) != null && System.getenv(NLS_LANG).length() > 0;
    }

    public static void setupNLSSession(ScriptRunnerContext ctx, Connection conn) {
        if (conn != null && conn instanceof OracleConnection) {
            PreparedStatement nlsStmt = null;
            if (NLSLang.setLangFromNLS_LANG() != null) {
                try {
                    nlsStmt = conn.prepareStatement(NLSLang.setLangFromNLS_LANG());
                    nlsStmt.execute();
                }
                catch (SQLException e) {
                    Logger.fine(NLS_LANG.getClass(), e);
                }
            }
            if (NLSLang.setTerritoryFromNLS_LANG() != null) {
                try {
                    nlsStmt = conn.prepareStatement(NLSLang.setTerritoryFromNLS_LANG());
                    nlsStmt.execute();
                }
                catch (SQLException e) {
                    Logger.fine(NLS_LANG.getClass(), e);
                }
            }
        }
    }

    static {
        language.put("AMERICAN", "us");
        language.put("ARABIC", "ar");
        language.put("BENGALI", "bn");
        language.put("BRAZILIAN PORTUGUESE", "ptb");
        language.put("BULGARIAN", "bg");
        language.put("CANADIAN FRENCH", "frc");
        language.put("CATALAN", "ca");
        language.put("CROATIAN", "hr");
        language.put("CZECH", "cs");
        language.put("DANISH", "dk");
        language.put("DUTCH", "nl");
        language.put("EGYPTIAN", "eg");
        language.put("ENGLISH", "gb");
        language.put("ESTONIAN", "et");
        language.put("FINNISH", "sf");
        language.put("FRENCH", "f");
        language.put("GERMAN DIN", "din");
        language.put("GERMAN", "d");
        language.put("GREEK", "el");
        language.put("HEBREW", "iw");
        language.put("HINDI", "hi");
        language.put("HUNGARIAN", "hu");
        language.put("ICELANDIC", "is");
        language.put("INDONESIAN", "in");
        language.put("ITALIAN", "i");
        language.put("JAPANESE", "ja");
        language.put("KOREAN", "ko");
        language.put("LATIN AMERICAN SPANISH", "esa");
        language.put("LATVIAN", "lv");
        language.put("LITHUANIAN", "lt");
        language.put("MALAY", "ms");
        language.put("MEXICAN SPANISH", "esm");
        language.put("NORWEGIAN", "n");
        language.put("POLISH", "pl");
        language.put("PORTUGUESE", "pt");
        language.put("ROMANIAN", "ro");
        language.put("RUSSIAN", "ru");
        language.put("SIMPLIFIED CHINESE", "zhs");
        language.put("SLOVAK", "sk");
        language.put("SLOVENIAN", "sl");
        language.put("SPANISH", "e");
        language.put("SWEDISH", "s");
        language.put("TAMIL", "ta");
        language.put("THAI", "th");
        language.put("TRADITIONAL CHINESE", "zht");
        language.put("TURKISH", "tr");
        language.put("UKRAINIAN", "uk");
        language.put("VIETNAMESE", "vn");
        territory.add("ALGERIA");
        territory.add("ICELAND");
        territory.add("QATAR");
        territory.add("AMERICA");
        territory.add("INDIA");
        territory.add("ROMANIA");
        territory.add("AUSTRALIA");
        territory.add("INDONESIA");
        territory.add("SAUDI ARABIA");
        territory.add("AUSTRIA");
        territory.add("IRAQ");
        territory.add("SINGAPORE");
        territory.add("BAHRAIN");
        territory.add("IRELAND");
        territory.add("SLOVAKIA");
        territory.add("BANGLADESH");
        territory.add("ISRAEL");
        territory.add("SLOVENIA");
        territory.add("BELGIUM");
        territory.add("ITALY");
        territory.add("SOMALIA");
        territory.add("BRAZIL");
        territory.add("JAPAN");
        territory.add("SOUTH AFRICA");
        territory.add("BULGARIA");
        territory.add("JORDAN");
        territory.add("SPAIN");
        territory.add("CANADA");
        territory.add("KAZAKHSTAN");
        territory.add("SUDAN");
        territory.add("CATALONIA");
        territory.add("KOREA");
        territory.add("SWEDEN");
        territory.add("CHINA");
        territory.add("KUWAIT");
        territory.add("SWITZERLAND");
        territory.add("CIS");
        territory.add("LATVIA");
        territory.add("SYRIA");
        territory.add("CROATIA");
        territory.add("LEBANON");
        territory.add("TAIWAN");
        territory.add("CYPRUS");
        territory.add("LIBYA");
        territory.add("THAILAND");
        territory.add("CZECH REPUBLIC");
        territory.add("LITHUANIA");
        territory.add("THE NETHERLANDS");
        territory.add("DENMARK");
        territory.add("LUXEMBOURG");
        territory.add("TUNISIA");
        territory.add("DJIBOUTI");
        territory.add("MALAYSIA");
        territory.add("TURKEY");
        territory.add("EGYPT");
        territory.add("MAURITANIA");
        territory.add("UKRAINE");
        territory.add("ESTONIA");
        territory.add("MEXICO");
        territory.add("UNITED ARAB EMIRATES");
        territory.add("FINLAND");
        territory.add("MOROCCO");
        territory.add("UNITED KINGDOM");
        territory.add("FRANCE");
        territory.add("NEW ZEALAND");
        territory.add("UZBEKISTAN");
        territory.add("GERMANY");
        territory.add("NORWAY");
        territory.add("VIETNAM");
        territory.add("GREECE");
        territory.add("OMAN");
        territory.add("YEMEN");
        territory.add("HONG KONG");
        territory.add("POLAND");
        territory.add("HUNGARY");
        territory.add("PORTUGAL");
    }
}

